/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeLabel;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.component.UITreeSelect;
import org.apache.myfaces.tobago.internal.component.AbstractUITree;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Position;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.EncodeUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeListboxRenderer
extends LayoutComponentRendererBase {
    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        this.setRendererTypeForCommandsAndNodes(component);
    }

    protected void setRendererTypeForCommandsAndNodes(UIComponent component) {
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UITreeNode) {
                child.setRendererType("TreeListboxNode");
            }
            this.setRendererTypeForCommandsAndNodes(child);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUITree tree = (AbstractUITree)component;
        String clientId = tree.getClientId(facesContext);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        Style style = new Style(facesContext, (LayoutBase)tree);
        Style scrollDivStyle = new Style();
        writer.startElement("div", (UIComponent)tree);
        scrollDivStyle.setWidth(Measure.valueOf((int)960));
        scrollDivStyle.setHeight(style.getHeight().subtract(15));
        scrollDivStyle.setPosition(Position.ABSOLUTE);
        writer.writeStyleAttribute(scrollDivStyle);
        writer.startElement("div", (UIComponent)tree);
        writer.writeClassAttribute(Classes.create((UIComponent)tree));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)tree);
        writer.writeStyleAttribute(style);
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute("value", ";", false);
        writer.endElement("input");
        if (tree.getSelectableAsEnum().isSupportedByTreeListbox()) {
            writer.startElement("input", (UIComponent)tree);
            writer.writeAttribute("type", "hidden", false);
            writer.writeNameAttribute(clientId + "-selectState");
            writer.writeIdAttribute(clientId + "-selectState");
            writer.writeAttribute("value", ";", false);
            writer.writeAttribute("data-tobago-selection-mode", tree.getSelectableAsEnum().name(), false);
            writer.endElement("input");
        }
        ArrayList<Integer> thisLevel = new ArrayList<Integer>();
        thisLevel.add(0);
        ArrayList<Integer> nextLevel = new ArrayList<Integer>();
        int depth = tree.getTreeDataModel().getDepth() != -1 ? tree.getTreeDataModel().getDepth() : 7;
        Measure currentWidth = tree.getCurrentWidth();
        Measure width = currentWidth.divide(depth);
        for (int level = 0; level < depth; ++level) {
            writer.startElement("div", null);
            writer.writeClassAttribute(Classes.create((UIComponent)tree, (String)"level"));
            Style levelStyle = new Style();
            levelStyle.setLeft(width.multiply(level));
            levelStyle.setWidth(width);
            writer.writeStyleAttribute(levelStyle);
            if (level > 0) {
                writer.startElement("select", null);
                writer.writeAttribute("disabled", true);
                writer.writeAttribute("size", 9);
                writer.writeClassAttribute(Classes.create((UIComponent)tree, (String)"select"));
                writer.endElement("select");
            }
            for (Integer rowIndex : thisLevel) {
                this.encodeSelectBox(facesContext, tree, writer, rowIndex, nextLevel);
            }
            thisLevel.clear();
            ArrayList<Integer> swap = thisLevel;
            thisLevel = nextLevel;
            nextLevel = swap;
            writer.endElement("div");
        }
        writer.endElement("div");
        writer.endElement("div");
        tree.setRowIndex(-1);
    }

    private void encodeSelectBox(FacesContext facesContext, AbstractUITree tree, TobagoResponseWriter writer, int parentRowIndex, List<Integer> foldersRowIndices) throws IOException {
        UITreeLabel label;
        tree.setRowIndex(parentRowIndex);
        UITreeNode node = (UITreeNode)ComponentUtils.findDescendant((UIComponent)tree, UITreeNode.class);
        String parentId = node.getClientId(facesContext);
        writer.startElement("select", (UIComponent)tree);
        writer.writeClassAttribute(Classes.create((UIComponent)tree, (String)"select"));
        if (parentId != null) {
            writer.writeAttribute("data-tobago-tree-parent", parentId, false);
        }
        writer.writeAttribute("size", 9);
        UITreeSelect select = (UITreeSelect)ComponentUtils.findDescendant((UIComponent)tree, UITreeSelect.class);
        String labelValue = select != null ? select.getLabel() : ((label = (UITreeLabel)ComponentUtils.findDescendant((UIComponent)tree, UITreeLabel.class)) != null ? label.getLabel() : null);
        if (labelValue != null) {
            writer.startElement("optgroup", (UIComponent)tree);
            writer.writeAttribute("label", labelValue, true);
            writer.endElement("optgroup");
        }
        List rowIndices = tree.getRowIndicesOfChildren();
        for (Integer rowIndex : rowIndices) {
            tree.setRowIndex(rowIndex.intValue());
            if (!tree.isRowAvailable()) break;
            for (UIComponent child : tree.getChildren()) {
                EncodeUtils.prepareRendererAll((FacesContext)facesContext, (UIComponent)child);
                RenderUtils.encode(facesContext, child);
            }
            if (!tree.isFolder()) continue;
            foldersRowIndices.add(rowIndex);
        }
        writer.endElement("select");
    }
}

