// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITree;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.TreeTagDeclaration}.
 */
public final class TreeTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(TreeTag.class);
  private javax.el.ValueExpression  selectable;
  private javax.el.ValueExpression  state;
  private javax.el.ValueExpression  value;
  private javax.el.ValueExpression  markup;
  private String var;
  private javax.el.ValueExpression  showRootJunction;
  private javax.el.ValueExpression  showRoot;

  @Override
  public String getComponentType() {
    return UITree.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "Tree";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UITree component = (UITree) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (selectable != null) {
      component.setValueExpression("selectable", selectable);
    }

    if (state != null) {
      if (!state.isLiteralText()) {
        component.setValueExpression("state", state);
      /*} else {
        component.setState(state.getExpressionString());*/
      }
    }
    if (value != null) {
      component.setValueExpression("value", value);
    }

    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (var != null) {
      component.setVar(var);
    }

    if (showRootJunction != null) {
      if (!showRootJunction.isLiteralText()) {
        component.setValueExpression("showRootJunction", showRootJunction);
      } else {
        component.setShowRootJunction(Boolean.parseBoolean(showRootJunction.getExpressionString()));
      }
    }
    if (showRoot != null) {
      if (!showRoot.isLiteralText()) {
        component.setValueExpression("showRoot", showRoot);
      } else {
        component.setShowRoot(Boolean.parseBoolean(showRoot.getExpressionString()));
      }
    }
  }

  public javax.el.ValueExpression getSelectable() {
    return selectable;
  }

  public void setSelectable(final javax.el.ValueExpression selectable) {
    this.selectable = selectable;
  }

  public javax.el.ValueExpression getState() {
    return state;
  }

  public void setState(final javax.el.ValueExpression state) {
    this.state = state;
  }

  public javax.el.ValueExpression getValue() {
    return value;
  }

  public void setValue(final javax.el.ValueExpression value) {
    this.value = value;
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public String getVar() {
    return var;
  }

  public void setVar(final String var) {
    this.var = var;
  }

  public javax.el.ValueExpression getShowRootJunction() {
    return showRootJunction;
  }

  public void setShowRootJunction(final javax.el.ValueExpression showRootJunction) {
    this.showRootJunction = showRootJunction;
  }

  public javax.el.ValueExpression getShowRoot() {
    return showRoot;
  }

  public void setShowRoot(final javax.el.ValueExpression showRoot) {
    this.showRoot = showRoot;
  }



  @Override
  public void release() {
    super.release();
    selectable = null;
    state = null;
    value = null;
    markup = null;
    var = null;
    showRootJunction = null;
    showRoot = null;
  }
}