/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.ActionSource;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectMany;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.view.facelets.FaceletContext;
import javax.servlet.jsp.JspException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UISheet;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.TransientStateHolder;
import org.apache.myfaces.tobago.event.AbstractPopupActionListener;
import org.apache.myfaces.tobago.internal.component.AbstractUIForm;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.component.AbstractUIPage;
import org.apache.myfaces.tobago.internal.component.AbstractUIPopup;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.internal.util.ObjectUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentUtils.class);
    public static final String SUB_SEPARATOR = "::";
    private static final String RENDER_KEY_PREFIX = "org.apache.myfaces.tobago.util.ComponentUtils.RendererKeyPrefix_";
    private static final String PAGE_KEY = "org.apache.myfaces.tobago.Page.Key";
    public static final Class[] ACTION_ARGS = new Class[0];
    public static final Class[] ACTION_LISTENER_ARGS = new Class[]{ActionEvent.class};
    public static final Class[] VALUE_CHANGE_LISTENER_ARGS = new Class[]{ValueChangeEvent.class};
    public static final Class[] VALIDATOR_ARGS = new Class[]{FacesContext.class, UIComponent.class, Object.class};
    public static final String LIST_SEPARATOR_CHARS = ", ";
    public static final String DATA_ATTRIBUTES_KEY = "javax.faces.component.DATA_ATTRIBUTES_KEY";

    private ComponentUtils() {
    }

    public static boolean hasErrorMessages(FacesContext context) {
        Iterator iter = context.getMessages();
        while (iter.hasNext()) {
            FacesMessage message = (FacesMessage)iter.next();
            if (FacesMessage.SEVERITY_ERROR.compareTo((Object)message.getSeverity()) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean containsPopupActionListener(UICommand command) {
        ActionListener[] actionListeners;
        for (ActionListener actionListener : actionListeners = command.getActionListeners()) {
            if (!(actionListener instanceof AbstractPopupActionListener)) continue;
            return true;
        }
        return false;
    }

    public static String getFacesMessageAsString(FacesContext facesContext, UIComponent component) {
        Iterator messages = facesContext.getMessages(component.getClientId(facesContext));
        StringBuilder stringBuffer = new StringBuilder();
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            stringBuffer.append(message.getDetail());
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public static boolean isInPopup(UIComponent component) {
        while (component != null) {
            if (component instanceof AbstractUIPopup) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    public static void resetPage(FacesContext context) {
        UIViewRoot view = context.getViewRoot();
        if (view != null) {
            view.getAttributes().remove(PAGE_KEY);
        }
    }

    public static UIViewRoot findViewRoot(FaceletContext faceletContext, UIComponent component) {
        UIViewRoot viewRoot = ComponentUtils.findAncestor(component, UIViewRoot.class);
        if (viewRoot != null) {
            return viewRoot;
        }
        return faceletContext.getFacesContext().getViewRoot();
    }

    public static AbstractUIPage findPage(FacesContext context, UIComponent component) {
        UIViewRoot view = context.getViewRoot();
        if (view != null) {
            TransientStateHolder stateHolder = (TransientStateHolder)view.getAttributes().get(PAGE_KEY);
            if (stateHolder == null || stateHolder.isEmpty()) {
                AbstractUIPage page = ComponentUtils.findPage(component);
                stateHolder = new TransientStateHolder(page);
                context.getViewRoot().getAttributes().put(PAGE_KEY, stateHolder);
            }
            return (AbstractUIPage)stateHolder.get();
        }
        return ComponentUtils.findPage(component);
    }

    public static AbstractUIPage findPage(UIComponent component) {
        if (component instanceof UIViewRoot) {
            return ComponentUtils.findPageBreadthFirst(component);
        }
        while (component != null) {
            if (component instanceof AbstractUIPage) {
                return (AbstractUIPage)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static AbstractUIPage findPage(FacesContext facesContext) {
        return ComponentUtils.findPageBreadthFirst((UIComponent)facesContext.getViewRoot());
    }

    private static AbstractUIPage findPageBreadthFirst(UIComponent component) {
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof AbstractUIPage)) continue;
            return (AbstractUIPage)child;
        }
        for (UIComponent child : component.getChildren()) {
            AbstractUIPage result = ComponentUtils.findPageBreadthFirst(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static AbstractUIForm findForm(UIComponent component) {
        while (component != null) {
            if (component instanceof AbstractUIForm) {
                return (AbstractUIForm)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static <T> T findAncestor(UIComponent component, Class<T> type) {
        while (component != null) {
            if (type.isAssignableFrom(component.getClass())) {
                return (T)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static List<AbstractUIForm> findSubForms(UIComponent component) {
        ArrayList<AbstractUIForm> collect = new ArrayList<AbstractUIForm>();
        ComponentUtils.findSubForms(collect, component);
        return collect;
    }

    private static void findSubForms(List<AbstractUIForm> collect, UIComponent component) {
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent child = (UIComponent)kids.next();
            if (child instanceof AbstractUIForm) {
                collect.add((AbstractUIForm)child);
                continue;
            }
            ComponentUtils.findSubForms(collect, child);
        }
    }

    public static <T extends UIComponent> T findDescendant(UIComponent component, Class<T> type) {
        for (UIComponent child : component.getChildren()) {
            if (type.isAssignableFrom(child.getClass())) {
                return (T)child;
            }
            T descendant = ComponentUtils.findDescendant(child, type);
            if (descendant == null) continue;
            return descendant;
        }
        return null;
    }

    public static <T extends UIComponent> T findFacetDescendant(UIComponent component, String facet, Class<T> type) {
        UIComponent facetComponent = component.getFacet(facet);
        if (facetComponent != null) {
            if (type.isAssignableFrom(facetComponent.getClass())) {
                return (T)facetComponent;
            }
            return ComponentUtils.findDescendant(facetComponent, type);
        }
        return null;
    }

    public static <T extends UIComponent> T findChild(UIComponent component, Class<T> type) {
        for (UIComponent child : component.getChildren()) {
            if (!type.isAssignableFrom(child.getClass())) continue;
            return (T)child;
        }
        return null;
    }

    public static <T extends UIComponent> List<T> findDescendantList(UIComponent component, Class<T> type) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (UIComponent child : component.getChildren()) {
            if (type.isAssignableFrom(child.getClass())) {
                result.add(child);
            }
            result.addAll(ComponentUtils.findDescendantList(child, type));
        }
        return result;
    }

    public static String findClientIdFor(UIComponent component, FacesContext facesContext) {
        UIComponent forComponent = ComponentUtils.findFor(component);
        if (forComponent != null) {
            String clientId = forComponent.getClientId(facesContext);
            if (LOG.isDebugEnabled()) {
                LOG.debug("found clientId: '" + clientId + "'");
            }
            return clientId;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("found no clientId");
        }
        return null;
    }

    public static UIComponent findFor(UIComponent component) {
        String forValue = (String)component.getAttributes().get("for");
        if (forValue == null) {
            return component.getParent();
        }
        return ComponentUtils.findComponent(component, forValue);
    }

    @Deprecated
    public static void evaluateAutoFor(UIComponent component) {
        block2: {
            UIComponent child;
            String forComponent = (String)component.getAttributes().get("for");
            if (LOG.isDebugEnabled()) {
                LOG.debug("for = '" + forComponent + "'");
            }
            if (!"@auto".equals(forComponent)) break block2;
            Iterator iterator = component.getParent().getChildren().iterator();
            while (iterator.hasNext() && !ComponentUtils.setForToInput(component, child = (UIComponent)iterator.next(), AbstractUIInput.class, false)) {
            }
        }
    }

    public static void evaluateAutoFor(UIComponent component, Class<? extends UIComponent> clazz) {
        String forComponent = (String)component.getAttributes().get("for");
        if (LOG.isDebugEnabled()) {
            LOG.debug("for = '" + forComponent + "'");
        }
        if ("@auto".equals(forComponent)) {
            for (UIComponent child : component.getParent().getChildren()) {
                if (!ComponentUtils.setForToInput(component, child, clazz, component instanceof NamingContainer)) continue;
                return;
            }
            for (UIComponent child : component.getParent().getParent().getChildren()) {
                if (!ComponentUtils.setForToInput(component, child, clazz, component.getParent() instanceof NamingContainer)) continue;
                return;
            }
        }
    }

    private static boolean setForToInput(UIComponent component, UIComponent child, Class<? extends UIComponent> clazz, boolean namingContainer) {
        if (clazz.isAssignableFrom(child.getClass())) {
            String forComponent = namingContainer ? ":::" + child.getId() : child.getId();
            component.getAttributes().put("for", forComponent);
            return true;
        }
        return false;
    }

    public static boolean isInActiveForm(UIComponent component) {
        while (component != null) {
            AbstractUIForm form;
            if (component instanceof AbstractUIForm && (form = (AbstractUIForm)component).isSubmitted()) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    public static FacesMessage.Severity getMaximumSeverity(UIComponent component) {
        boolean invalid = component instanceof UIInput && !((UIInput)component).isValid();
        FacesMessage.Severity max = invalid ? FacesMessage.SEVERITY_ERROR : null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Iterator messages = facesContext.getMessages(component.getClientId(facesContext));
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            if (max != null && message.getSeverity().getOrdinal() <= max.getOrdinal()) continue;
            max = message.getSeverity();
        }
        return max;
    }

    public static boolean isError(UIInput uiInput) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return !uiInput.isValid() || facesContext.getMessages(uiInput.getClientId(facesContext)).hasNext();
    }

    public static boolean isError(UIComponent component) {
        if (component instanceof AbstractUIInput) {
            return ComponentUtils.isError((AbstractUIInput)component);
        }
        return false;
    }

    public static boolean isOutputOnly(UIComponent component) {
        return ComponentUtils.getBooleanAttribute(component, "disabled") || ComponentUtils.getBooleanAttribute(component, "readonly");
    }

    public static boolean mayValidate(UIComponent component) {
        return !ComponentUtils.isOutputOnly(component) && ComponentUtils.isInActiveForm(component);
    }

    public static boolean mayUpdateModel(UIComponent component) {
        return ComponentUtils.mayValidate(component);
    }

    public static boolean getBooleanAttribute(UIComponent component, String name) {
        Object bool = component.getAttributes().get(name);
        if (bool == null) {
            return false;
        }
        if (bool instanceof ValueBinding) {
            bool = ((ValueBinding)bool).getValue(FacesContext.getCurrentInstance());
        }
        if (bool instanceof Boolean) {
            return (Boolean)bool;
        }
        if (bool instanceof String) {
            LOG.warn("Searching for a boolean, but find a String. Should not happen. attribute: '" + name + "' id: '" + component.getClientId(FacesContext.getCurrentInstance()) + "' comp: '" + component + "'");
            return Boolean.valueOf((String)bool);
        }
        LOG.warn("Unknown type '" + bool.getClass().getName() + "' for boolean attribute: " + name + " id: " + component.getClientId(FacesContext.getCurrentInstance()) + " comp: " + component);
        return false;
    }

    @Deprecated
    public static ValueBinding createValueBinding(String value) {
        return FacesContext.getCurrentInstance().getApplication().createValueBinding(value);
    }

    @Deprecated
    public static void setStyleClasses(UIComponent component, String styleClasses) {
        Deprecation.LOG.warn("style class " + styleClasses);
    }

    @Deprecated
    public static void setMarkup(UIComponent markupComponent, String markup) {
        Deprecation.LOG.error("markup=" + markup);
    }

    public static Object getAttribute(UIComponent component, String name) {
        Object value = component.getAttributes().get(name);
        if (value instanceof ValueBinding) {
            value = ((ValueBinding)value).getValue(FacesContext.getCurrentInstance());
        }
        return value;
    }

    public static Object getObjectAttribute(UIComponent component, String name) {
        return ComponentUtils.getAttribute(component, name);
    }

    public static String getStringAttribute(UIComponent component, String name) {
        return (String)ComponentUtils.getAttribute(component, name);
    }

    public static int getIntAttribute(UIComponent component, String name) {
        return ComponentUtils.getIntAttribute(component, name, 0);
    }

    public static int getIntAttribute(UIComponent component, String name, int defaultValue) {
        Object integer = component.getAttributes().get(name);
        if (integer instanceof Number) {
            return ((Number)integer).intValue();
        }
        if (integer instanceof String) {
            try {
                return Integer.parseInt((String)integer);
            }
            catch (NumberFormatException e) {
                LOG.warn("Can't parse number from string : \"" + integer + "\"!");
                return defaultValue;
            }
        }
        if (integer == null) {
            return defaultValue;
        }
        LOG.warn("Unknown type '" + integer.getClass().getName() + "' for integer attribute: " + name + " comp: " + component);
        return defaultValue;
    }

    public static Character getCharacterAttribute(UIComponent component, String name) {
        Object character = component.getAttributes().get(name);
        if (character == null) {
            return null;
        }
        if (character instanceof Character) {
            return (Character)character;
        }
        if (character instanceof String) {
            String asString = (String)character;
            return asString.length() > 0 ? Character.valueOf(asString.charAt(0)) : null;
        }
        LOG.warn("Unknown type '" + character.getClass().getName() + "' for integer attribute: " + name + " comp: " + component);
        return null;
    }

    public static boolean isFacetOf(UIComponent component, UIComponent parent) {
        for (Object o : parent.getFacets().keySet()) {
            UIComponent facet = parent.getFacet((String)o);
            if (!component.equals(facet)) continue;
            return true;
        }
        return false;
    }

    public static RendererBase getRenderer(FacesContext facesContext, UIComponent component) {
        return ComponentUtils.getRenderer(facesContext, component.getFamily(), component.getRendererType());
    }

    public static RendererBase getRenderer(FacesContext facesContext, String family, String rendererType) {
        if (rendererType == null) {
            return null;
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        StringBuilder key = new StringBuilder(RENDER_KEY_PREFIX);
        key.append(rendererType);
        RendererBase renderer = (RendererBase)((Object)requestMap.get(key.toString()));
        if (renderer == null) {
            Renderer myRenderer = ComponentUtils.getRendererInternal(facesContext, family, rendererType);
            if (myRenderer instanceof RendererBase) {
                requestMap.put(key.toString(), myRenderer);
                renderer = (RendererBase)myRenderer;
            } else {
                return null;
            }
        }
        return renderer;
    }

    private static Renderer getRendererInternal(FacesContext facesContext, String family, String rendererType) {
        RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = rkFactory.getRenderKit(facesContext, facesContext.getViewRoot().getRenderKitId());
        Renderer myRenderer = renderKit.getRenderer(family, rendererType);
        return myRenderer;
    }

    public static Object findParameter(UIComponent component, String name) {
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Select name='" + parameter.getName() + "'");
                LOG.debug("Select value='" + parameter.getValue() + "'");
            }
            if (!name.equals(parameter.getName())) continue;
            return parameter.getValue();
        }
        return null;
    }

    @Deprecated
    public static ActionListener createActionListener(String type) throws JspException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = type.getClass().getClassLoader();
            }
            Class<?> clazz = classLoader.loadClass(type);
            return (ActionListener)clazz.newInstance();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("type=" + type, (Throwable)e);
            }
            throw new JspException((Throwable)e);
        }
    }

    @Deprecated
    public static UIGraphic getFirstGraphicChild(UIComponent component) {
        UIGraphic graphic = null;
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIGraphic)) continue;
            graphic = (UIGraphic)child;
            break;
        }
        return graphic;
    }

    @Deprecated
    public static boolean isHoverEnabled(UIComponent component) {
        return ComponentUtils.getBooleanAttribute(component, "hover");
    }

    @Deprecated
    public static UIOutput getFirstNonGraphicChild(UIComponent component) {
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIOutput)) continue;
            return (UIOutput)child;
        }
        return null;
    }

    @Deprecated
    public static void setIntegerSizeProperty(UIComponent component, String name, String value) {
        Deprecation.LOG.error("name=" + name + " value=" + value);
    }

    @Deprecated
    public static String removePx(String value) {
        if (value != null && value.endsWith("px")) {
            value = value.substring(0, value.length() - 2);
        }
        return value;
    }

    @Deprecated
    public static void setValueForValueBinding(String name, Object value) {
        FacesContext context = FacesContext.getCurrentInstance();
        ValueBinding valueBinding = context.getApplication().createValueBinding(name);
        valueBinding.setValue(context, value);
    }

    @Deprecated
    public static boolean hasSelectedValue(List<SelectItem> items, Object value) {
        for (SelectItem item : items) {
            if (!ObjectUtils.equals(item.getValue(), value)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static int getIntValue(ValueBinding valueBinding) {
        return ComponentUtils.getAsInt(valueBinding.getValue(FacesContext.getCurrentInstance()));
    }

    @Deprecated
    private static int getAsInt(Object value) {
        int result;
        if (value instanceof Number) {
            result = ((Number)value).intValue();
        } else if (value instanceof String) {
            result = Integer.parseInt((String)value);
        } else {
            throw new IllegalArgumentException("Can't convert " + value + " to int!");
        }
        return result;
    }

    @Deprecated
    public static String createPickerId(FacesContext facesContext, UIComponent component, String postfix) {
        String id = ComponentUtils.getComponentId(facesContext, component);
        return id + "_picker" + postfix;
    }

    @Deprecated
    public static String getComponentId(FacesContext facesContext, UIComponent component) {
        String id = component.getId();
        return id;
    }

    @Deprecated
    public static UIComponent provideLabel(FacesContext facesContext, UIComponent component) {
        UIComponent label = component.getFacet("label");
        if (label == null) {
            Map attributes = component.getAttributes();
            Object labelText = component.getValueBinding("label");
            if (labelText == null) {
                labelText = attributes.get("label");
            }
            if (labelText != null) {
                Application application = FacesContext.getCurrentInstance().getApplication();
                label = application.createComponent("javax.faces.Output");
                label.setRendererType("Label");
                String idprefix = ComponentUtils.getComponentId(facesContext, component);
                label.setId(idprefix + "_" + "label");
                label.setRendered(true);
                if (labelText instanceof ValueBinding) {
                    label.setValueBinding("value", labelText);
                } else {
                    label.getAttributes().put("value", labelText);
                }
                component.getFacets().put("label", label);
            }
        }
        return label;
    }

    @Deprecated
    public static void setValidator(EditableValueHolder editableValueHolder, String validator) {
        Deprecation.LOG.error("validator=" + validator);
    }

    @Deprecated
    public static void setConverter(ValueHolder valueHolder, String converterId) {
        Deprecation.LOG.error("converterId=" + converterId);
    }

    @Deprecated
    public static void setAction(ActionSource component, String action) {
        Deprecation.LOG.error("action=" + action);
    }

    @Deprecated
    public static void setActionListener(ActionSource command, String actionListener) {
        Deprecation.LOG.error("actionListener=" + actionListener);
    }

    @Deprecated
    public static void setValueChangeListener(EditableValueHolder valueHolder, String valueChangeListener) {
        Deprecation.LOG.error("valueChangeListener=" + valueChangeListener);
    }

    @Deprecated
    public static void setValueBinding(UIComponent component, String name, String state) {
        Deprecation.LOG.error("name=" + name + " state=" + state);
    }

    @Deprecated
    public static String[] getMarkupBinding(FacesContext facesContext, SupportsMarkup component) {
        ValueBinding vb = ((UIComponent)component).getValueBinding("markup");
        if (vb != null) {
            Object markups = vb.getValue(facesContext);
            if (markups instanceof String[]) {
                return (String[])markups;
            }
            if (markups instanceof String) {
                String[] strings = StringUtils.split((String)markups, LIST_SEPARATOR_CHARS);
                ArrayList<String> result = new ArrayList<String>(strings.length);
                for (String string : strings) {
                    if (string.trim().length() == 0) continue;
                    result.add(string.trim());
                }
                return result.toArray(new String[result.size()]);
            }
            if (markups == null) {
                return ArrayUtils.EMPTY_STRING_ARRAY;
            }
            return new String[]{markups.toString()};
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public static UIComponent findComponent(UIComponent from, String relativeId) {
        int colonCount;
        UIComponent from1 = from;
        String relativeId1 = relativeId;
        int idLength = relativeId1.length();
        if (idLength > 0 && relativeId1.charAt(0) == '@' && relativeId1.equals("@this")) {
            return from1;
        }
        for (colonCount = 0; colonCount < idLength && relativeId1.charAt(colonCount) == UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance()); ++colonCount) {
        }
        if (colonCount > 1) {
            relativeId1 = relativeId1.substring(colonCount);
            for (int j = 1; j < colonCount; ++j) {
                while (from1.getParent() != null && !((from1 = from1.getParent()) instanceof NamingContainer)) {
                }
            }
        }
        return from1.findComponent(relativeId1);
    }

    public static String[] evaluateClientIds(FacesContext context, UIComponent component, String[] componentIds) {
        ArrayList<String> result = new ArrayList<String>(componentIds.length);
        for (String id : componentIds) {
            String clientId;
            if (StringUtils.isBlank(id) || (clientId = ComponentUtils.evaluateClientId(context, component, id)) == null) continue;
            result.add(clientId);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String evaluateClientId(FacesContext context, UIComponent component, String componentId) {
        UIComponent partiallyComponent = ComponentUtils.findComponent(component, componentId);
        if (partiallyComponent != null) {
            int rowIndex;
            String clientId = partiallyComponent.getClientId(context);
            if (partiallyComponent instanceof UISheet && (rowIndex = ((UISheet)partiallyComponent).getRowIndex()) >= 0 && clientId.endsWith(Integer.toString(rowIndex))) {
                return clientId.substring(0, clientId.lastIndexOf(UINamingContainer.getSeparatorChar((FacesContext)context)));
            }
            return clientId;
        }
        LOG.error("No component found for id='" + componentId + "', search base component is '" + component.getClientId(context) + "'");
        return null;
    }

    public static String[] splitList(String renderers) {
        return StringUtils.split(renderers, LIST_SEPARATOR_CHARS);
    }

    public static Object getConvertedValue(FacesContext facesContext, UIComponent component, String stringValue) {
        try {
            RendererBase renderer = ComponentUtils.getRenderer(facesContext, component);
            if (renderer != null) {
                if (component instanceof UISelectMany) {
                    Object converted = renderer.getConvertedValue(facesContext, component, new String[]{stringValue});
                    return converted instanceof Collection ? CollectionUtils.get((Object)converted, (int)0) : ((Object[])converted)[0];
                }
                return renderer.getConvertedValue(facesContext, component, stringValue);
            }
            if (component instanceof ValueHolder) {
                Class valueType;
                ValueBinding vb;
                Converter converter = ((ValueHolder)component).getConverter();
                if (converter == null && (vb = component.getValueBinding("value")) != null && (valueType = vb.getType(facesContext)) != null) {
                    converter = facesContext.getApplication().createConverter(valueType);
                }
                if (converter != null) {
                    converter.getAsObject(facesContext, component, stringValue);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Can't convert string value '" + stringValue + "'", (Throwable)e);
        }
        return stringValue;
    }

    public static Markup updateMarkup(UIComponent component, Markup markup) {
        if (markup == null) {
            markup = Markup.NULL;
        }
        if (ComponentUtils.getBooleanAttribute(component, "disabled")) {
            markup = markup.add(Markup.DISABLED);
        }
        if (ComponentUtils.getBooleanAttribute(component, "readonly")) {
            markup = markup.add(Markup.READONLY);
        }
        if (component instanceof UIInput) {
            UIInput input = (UIInput)component;
            FacesMessage.Severity maximumSeverity = ComponentUtils.getMaximumSeverity((UIComponent)input);
            markup = markup.add(ComponentUtils.markupOfSeverity(maximumSeverity));
            if (input.isRequired()) {
                markup = markup.add(Markup.REQUIRED);
            }
        }
        return markup;
    }

    public static Markup markupOfSeverity(FacesMessage.Severity maximumSeverity) {
        if (FacesMessage.SEVERITY_FATAL.equals(maximumSeverity)) {
            return Markup.FATAL;
        }
        if (FacesMessage.SEVERITY_ERROR.equals(maximumSeverity)) {
            return Markup.ERROR;
        }
        if (FacesMessage.SEVERITY_WARN.equals(maximumSeverity)) {
            return Markup.WARN;
        }
        if (FacesMessage.SEVERITY_INFO.equals(maximumSeverity)) {
            return Markup.INFO;
        }
        return null;
    }

    public static void addCurrentMarkup(SupportsMarkup component, Markup markup) {
        component.setCurrentMarkup(markup.add(component.getCurrentMarkup()));
    }

    @Deprecated
    public static boolean hasChildrenWithMessages(FacesContext facesContext, NamingContainer container) {
        if (container instanceof UIComponent) {
            String clientId = ((UIComponent)container).getClientId(facesContext);
            Iterator ids = facesContext.getClientIdsWithMessages();
            while (ids.hasNext()) {
                String id = (String)ids.next();
                if (!id.startsWith(clientId)) continue;
                return true;
            }
        }
        return false;
    }

    public static FacesMessage.Severity getMaximumSeverityOfChildrenMessages(FacesContext facesContext, NamingContainer container) {
        if (container instanceof UIComponent) {
            String clientId = ((UIComponent)container).getClientId(facesContext);
            FacesMessage.Severity max = null;
            Iterator ids = facesContext.getClientIdsWithMessages();
            while (ids.hasNext()) {
                String id = (String)ids.next();
                if (id == null || !id.startsWith(clientId)) continue;
                Iterator messages = facesContext.getMessages(id);
                while (messages.hasNext()) {
                    FacesMessage message = (FacesMessage)messages.next();
                    if (max != null && message.getSeverity().getOrdinal() <= max.getOrdinal()) continue;
                    max = message.getSeverity();
                }
            }
            return max;
        }
        return null;
    }

    @Deprecated
    public static String[] getChildrenWithMessages(FacesContext facesContext, NamingContainer container) {
        if (container instanceof UIComponent) {
            ArrayList<String> clientIds = new ArrayList<String>();
            String clientId = ((UIComponent)container).getClientId(facesContext);
            Iterator ids = facesContext.getClientIdsWithMessages();
            while (ids.hasNext()) {
                String id = (String)ids.next();
                if (!id.startsWith(clientId)) continue;
                clientIds.add(id);
            }
            return clientIds.toArray(new String[clientIds.size()]);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public static void putDataAttributeWithPrefix(UIComponent component, String name, Object value) {
        if (name.startsWith("data-")) {
            ComponentUtils.putDataAttribute(component, name.substring(5), value);
        } else {
            LOG.error("The name must start with 'data-' but it doesn't: '" + name + "'");
        }
    }

    public static void putDataAttribute(UIComponent component, Object name, Object value) {
        Map<Object, Object> map = ComponentUtils.getDataAttributes(component);
        if (map == null) {
            map = new HashMap<Object, Object>();
            component.getAttributes().put(DATA_ATTRIBUTES_KEY, map);
        }
        map.put(name, value);
    }

    public static Map<Object, Object> getDataAttributes(UIComponent component) {
        return (Map)component.getAttributes().get(DATA_ATTRIBUTES_KEY);
    }

    public static Object getDataAttribute(UIComponent component, String name) {
        Map<Object, Object> map = ComponentUtils.getDataAttributes(component);
        return map != null ? map.get(name) : null;
    }

    public static boolean invokeOnComponent(FacesContext context, UIComponent component, String clientId, ContextCallback callback) {
        return component.invokeOnComponent(context, clientId, callback);
    }
}

