/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIColumn;
import org.apache.myfaces.tobago.event.SortActionEvent;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.SelectedState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetState
implements Serializable {
    private static final long serialVersionUID = 7765536344426661777L;
    private static final Logger LOG = LoggerFactory.getLogger(SheetState.class);
    public static final String SEPARATOR = ",";
    private int first;
    private String sortedColumnId;
    private boolean ascending;
    private boolean toBeSorted;
    private String columnWidths;
    private List<Integer> selectedRows;
    private Integer[] scrollPosition;
    private ExpandedState expandedState;
    private SelectedState selectedState;

    public SheetState() {
        this.reset();
    }

    public void reset() {
        this.first = -1;
        this.sortedColumnId = null;
        this.ascending = true;
        this.toBeSorted = false;
        this.columnWidths = null;
        this.resetSelected();
        if (this.expandedState != null) {
            this.expandedState.reset();
        }
        if (this.selectedState != null) {
            this.selectedState.clear();
        }
        this.scrollPosition = null;
    }

    public void resetSelected() {
        this.selectedRows = new ArrayList<Integer>();
    }

    public List<Integer> getSelectedRows() {
        return this.selectedRows;
    }

    public void setSelectedRows(List<Integer> selectedRows) {
        assert (selectedRows != null);
        this.selectedRows = selectedRows;
    }

    public String getSortedColumnId() {
        return this.sortedColumnId;
    }

    public void setSortedColumnId(String sortedColumnId) {
        if (StringUtils.notEquals(this.sortedColumnId, sortedColumnId)) {
            this.sortedColumnId = sortedColumnId;
            this.toBeSorted = true;
        }
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        if (this.ascending != ascending) {
            this.ascending = ascending;
            this.toBeSorted = true;
        }
    }

    public String getColumnWidths() {
        return this.columnWidths;
    }

    public void setColumnWidths(String columnWidths) {
        this.columnWidths = columnWidths;
    }

    public int getFirst() {
        return this.first;
    }

    public void setFirst(int first) {
        this.first = first;
    }

    public void updateSortState(SortActionEvent sortEvent) {
        UIColumn actualColumn = sortEvent.getColumn();
        if (actualColumn.getId().equals(this.sortedColumnId)) {
            this.setAscending(!this.isAscending());
        } else {
            this.setAscending(true);
            this.setSortedColumnId(actualColumn.getId());
        }
    }

    public Integer[] getScrollPosition() {
        return this.scrollPosition;
    }

    public void setScrollPosition(Integer[] scrollPosition) {
        this.scrollPosition = scrollPosition;
    }

    public ExpandedState getExpandedState() {
        if (this.expandedState == null) {
            this.expandedState = new ExpandedState(2);
        }
        return this.expandedState;
    }

    public void setExpandedState(ExpandedState expandedState) {
        this.expandedState = expandedState;
    }

    public SelectedState getSelectedState() {
        if (this.selectedState == null) {
            this.selectedState = new SelectedState();
        }
        return this.selectedState;
    }

    public void setSelectedState(SelectedState selectedState) {
        this.selectedState = selectedState;
    }

    public boolean isToBeSorted() {
        return this.toBeSorted;
    }

    public void setToBeSorted(boolean toBeSorted) {
        this.toBeSorted = toBeSorted;
    }

    @Deprecated
    public static Integer[] parseScrollPosition(String value) {
        Integer[] position = null;
        if (!StringUtils.isBlank(value)) {
            int sep = value.indexOf(";");
            if (LOG.isInfoEnabled()) {
                LOG.info("value = \"" + value + "\"  sep = " + sep + "");
            }
            if (sep == -1) {
                throw new NumberFormatException(value);
            }
            int left = Integer.parseInt(value.substring(0, sep));
            int top = Integer.parseInt(value.substring(sep + 1));
            position = new Integer[]{left, top};
        }
        return position;
    }
}

