/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.apache.myfaces.tobago.model.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandedState
implements Serializable {
    private int defaultExpandedLevels;
    private Set<TreePath> expandedSet;
    private Set<TreePath> collapsedSet;

    public ExpandedState(int defaultExpandedLevels) {
        this.defaultExpandedLevels = defaultExpandedLevels;
        this.expandedSet = new HashSet<TreePath>();
        this.collapsedSet = new HashSet<TreePath>();
    }

    public boolean isExpanded(TreeNode node) {
        TreePath path = new TreePath(node);
        return this.isExpanded(path);
    }

    public boolean isExpanded(TreePath path) {
        if (this.expandedSet.contains(path)) {
            return true;
        }
        if (this.collapsedSet.contains(path)) {
            return false;
        }
        return path.getLength() < this.defaultExpandedLevels;
    }

    public void expand(TreeNode node) {
        this.expand(node, false);
    }

    public void expand(TreeNode node, boolean parents) {
        TreePath path = new TreePath(node);
        this.expand(path, parents);
    }

    public void expand(TreePath path) {
        this.expand(path, false);
    }

    public void expand(TreePath path, boolean parents) {
        if (path.getLength() >= this.defaultExpandedLevels) {
            this.expandedSet.add(path);
        } else {
            this.collapsedSet.remove(path);
        }
        if (parents && !path.isRoot()) {
            this.expand(path.getParent(), true);
        }
    }

    public void expand(int level) {
        ArrayList<TreePath> toRemove = new ArrayList<TreePath>();
        if (level > this.defaultExpandedLevels) {
            this.defaultExpandedLevels = level;
            for (TreePath treePath : this.expandedSet) {
                if (treePath.getLength() >= this.defaultExpandedLevels) continue;
                toRemove.add(treePath);
            }
            this.expandedSet.removeAll(toRemove);
            this.collapsedSet.clear();
        } else {
            for (TreePath treePath : this.collapsedSet) {
                if (treePath.getLength() >= level) continue;
                toRemove.add(treePath);
            }
            this.collapsedSet.removeAll(toRemove);
        }
    }

    public void expandAll() {
        this.defaultExpandedLevels = Integer.MAX_VALUE;
        this.expandedSet.clear();
        this.collapsedSet.clear();
    }

    public void collapse(TreeNode node) {
        TreePath path = new TreePath(node);
        this.collapse(path);
    }

    public void collapse(TreePath path) {
        if (path.getLength() < this.defaultExpandedLevels) {
            this.collapsedSet.add(path);
        } else {
            this.expandedSet.remove(path);
        }
    }

    public void collapse(int level) {
        ArrayList<TreePath> toRemove = new ArrayList<TreePath>();
        if (--level < this.defaultExpandedLevels) {
            this.defaultExpandedLevels = level;
            for (TreePath treePath : this.collapsedSet) {
                if (treePath.getLength() < this.defaultExpandedLevels) continue;
                toRemove.add(treePath);
            }
            this.collapsedSet.removeAll(toRemove);
            this.expandedSet.clear();
        } else {
            for (TreePath treePath : this.expandedSet) {
                if (treePath.getLength() < level) continue;
                toRemove.add(treePath);
            }
            this.expandedSet.removeAll(toRemove);
        }
    }

    public void collapseAll() {
        this.defaultExpandedLevels = 0;
        this.expandedSet.clear();
        this.collapsedSet.clear();
    }

    public void collapseAllButRoot() {
        this.defaultExpandedLevels = 1;
        this.expandedSet.clear();
        this.collapsedSet.clear();
    }

    public void reset() {
        this.expandedSet.clear();
        this.collapsedSet.clear();
    }

    public Set<TreePath> getExpandedSet() {
        return Collections.unmodifiableSet(this.expandedSet);
    }

    public Set<TreePath> getCollapsedSet() {
        return Collections.unmodifiableSet(this.collapsedSet);
    }
}

