/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.layout;

import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.tobago.internal.layout.Interval;
import org.apache.myfaces.tobago.layout.Measure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalList
extends ArrayList<Interval> {
    private static final Logger LOG = LoggerFactory.getLogger(IntervalList.class);
    private Measure minimum;
    private Measure current;

    public void evaluate() {
        List<Measure> minimumList = this.collectMinimum();
        List<Measure> maximumList = this.collectMaximum();
        this.minimum = Measure.max(minimumList);
        Measure maximum = Measure.min(maximumList);
        if (this.minimum.greaterThan(maximum)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Layout: Found a minimum constraint " + this.minimum + " which is greater than a maximum constraint " + maximum + "!");
            }
            this.current = this.minimum;
        } else {
            List<Measure> preferred = this.findPreferredInInterval(this.minimum, maximum);
            this.current = !preferred.isEmpty() ? Measure.max(preferred) : this.minimum;
        }
    }

    private List<Measure> collectMinimum() {
        ArrayList<Measure> result = new ArrayList<Measure>();
        for (Interval interval : this) {
            if (interval.getMinimum() != null) {
                result.add(interval.getMinimum());
            }
            if (interval.getCurrent() == null) continue;
            result.add(interval.getCurrent());
        }
        return result;
    }

    private List<Measure> collectMaximum() {
        ArrayList<Measure> result = new ArrayList<Measure>();
        for (Interval interval : this) {
            if (interval.getMaximum() == null) continue;
            result.add(interval.getMaximum());
        }
        return result;
    }

    private List<Measure> findPreferredInInterval(Measure min, Measure max) {
        ArrayList<Measure> result = new ArrayList<Measure>();
        for (Interval interval : this) {
            Measure value = interval.getCurrent();
            if (value == null) {
                value = interval.getPreferred();
            }
            if (value == null || !value.greaterOrEqualThan(min) || !value.lessOrEqualThan(max)) continue;
            result.add(value);
        }
        return result;
    }

    public Measure getMinimum() {
        return this.minimum;
    }

    public Measure getCurrent() {
        return this.current;
    }
}

