/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.context;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.myfaces.tobago.context.ThemeImpl;
import org.apache.myfaces.tobago.internal.config.ThemeBuilder;
import org.apache.myfaces.tobago.internal.config.TobagoConfigFragment;
import org.apache.myfaces.tobago.internal.config.TobagoConfigParser;
import org.apache.myfaces.tobago.internal.context.ResourceManagerImpl;
import org.apache.myfaces.tobago.internal.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceLocator {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceLocator.class);
    private static final String META_INF_TOBAGO_CONFIG_XML = "META-INF/tobago-config.xml";
    private static final String META_INF_RESOURCE_INDEX = "META-INF/tobago-resource-index.txt";
    private static final String META_INF_RESOURCES = "META-INF/resources";
    private ServletContext servletContext;
    private ResourceManagerImpl resourceManager;
    private ThemeBuilder themeBuilder;

    public ResourceLocator(ServletContext servletContext, ResourceManagerImpl resourceManager, ThemeBuilder themeBuilder) {
        this.servletContext = servletContext;
        this.resourceManager = resourceManager;
        this.themeBuilder = themeBuilder;
    }

    public void locate() throws ServletException {
        this.locateResourcesInWar(this.servletContext, this.resourceManager, "/");
        this.locateResourcesFromClasspath(this.resourceManager);
        this.locateResourcesServlet30Alike(this.resourceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locateResourcesInWar(ServletContext servletContext, ResourceManagerImpl resources, String path) throws ServletException {
        Set resourcePaths;
        if (path.startsWith("/WEB-INF/")) {
            return;
        }
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        if ((resourcePaths = servletContext.getResourcePaths(path)) == null || resourcePaths.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping empty resource path: path='{}'", (Object)path);
            }
            return;
        }
        for (String childPath : resourcePaths) {
            InputStream inputStream;
            if (childPath.endsWith("/")) {
                if (childPath.equals(path)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("childPath dir {}", (Object)childPath);
                }
                this.locateResourcesInWar(servletContext, resources, childPath);
                continue;
            }
            if (childPath.endsWith(".properties")) {
                inputStream = servletContext.getResourceAsStream(childPath);
                try {
                    this.addProperties(inputStream, resources, childPath, false, 0);
                    continue;
                }
                finally {
                    IoUtils.closeQuietly(inputStream);
                    continue;
                }
            }
            if (childPath.endsWith(".properties.xml")) {
                inputStream = servletContext.getResourceAsStream(childPath);
                try {
                    this.addProperties(inputStream, resources, childPath, true, 0);
                    continue;
                }
                catch (RuntimeException e) {
                    LOG.error("childPath = \"" + childPath + "\" ", (Throwable)e);
                    throw e;
                }
                finally {
                    IoUtils.closeQuietly(inputStream);
                    continue;
                }
            }
            resources.add(childPath);
        }
    }

    private void locateResourcesFromClasspath(ResourceManagerImpl resources) throws ServletException {
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info("Searching for and 'META-INF/tobago-config.xml'");
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urls = classLoader.getResources(META_INF_TOBAGO_CONFIG_XML);
            while (urls.hasMoreElements()) {
                URL tobagoConfigUrl = urls.nextElement();
                TobagoConfigFragment tobagoConfig = new TobagoConfigParser().parse(tobagoConfigUrl);
                for (ThemeImpl theme : tobagoConfig.getThemeDefinitions()) {
                    this.detectThemeVersion(tobagoConfigUrl, theme);
                    this.themeBuilder.addTheme(theme);
                    String prefix = this.ensureSlash(theme.getResourcePath());
                    String protocol = tobagoConfigUrl.getProtocol();
                    if (!("jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol))) {
                        LOG.warn("Unknown protocol '" + tobagoConfigUrl + "'");
                    }
                    this.addResources(resources, tobagoConfigUrl, prefix, 0);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            throw new ServletException((Throwable)e);
        }
    }

    private void locateResourcesServlet30Alike(ResourceManagerImpl resources) throws ServletException {
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info("Searching for 'META-INF/resources'");
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urls = classLoader.getResources(META_INF_RESOURCES);
            while (urls.hasMoreElements()) {
                URL resourcesUrl = urls.nextElement();
                LOG.info("resourcesUrl='" + resourcesUrl + "'");
                if (!resourcesUrl.toString().matches(".*/WEB-INF/lib/.*\\.jar\\!.*")) {
                    LOG.info("skip ...");
                    continue;
                }
                LOG.info("going on ...");
                String protocol = resourcesUrl.getProtocol();
                if (!("jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol))) {
                    LOG.warn("Unknown protocol '" + resourcesUrl + "'");
                }
                this.addResourcesFromZip(resources, resourcesUrl.getFile(), resourcesUrl.getProtocol(), "/META-INF/resources", META_INF_RESOURCES.length() + 1);
            }
        }
        catch (IOException e) {
            String msg = "while loading ";
            LOG.error("while loading ", (Throwable)e);
            throw new ServletException("while loading ", (Throwable)e);
        }
    }

    private void addResources(ResourceManagerImpl resources, URL themeUrl, String prefix, int skipPrefix) throws IOException, ServletException {
        String fileName = themeUrl.getFile();
        LOG.info("fileName='" + fileName + "'");
        String resourceIndex = fileName.substring(0, fileName.lastIndexOf(META_INF_TOBAGO_CONFIG_XML)) + META_INF_RESOURCE_INDEX;
        LOG.info("resourceIndex='" + resourceIndex + "'");
        URL resource = this.findMatchingResourceIndexUrl(themeUrl);
        LOG.info("resource='" + resource + "'");
        if (resource != null) {
            this.addResourcesFromIndexFile(resources, resource.openStream(), skipPrefix);
        } else {
            this.addResourcesFromZip(resources, fileName, themeUrl.getProtocol(), prefix, skipPrefix);
        }
    }

    private URL findMatchingResourceIndexUrl(URL themeUrl) throws IOException {
        String themeProtocol = themeUrl.getProtocol();
        String themeDir = themeUrl.getFile().substring(0, themeUrl.getFile().length() - META_INF_TOBAGO_CONFIG_XML.length());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> urls = classLoader.getResources(META_INF_RESOURCE_INDEX);
        URL url = null;
        while (!(!urls.hasMoreElements() || (url = urls.nextElement()).getProtocol().equals(themeProtocol) && url.getFile().startsWith(themeDir))) {
            url = null;
        }
        return url;
    }

    private void addResourcesFromIndexFile(ResourceManagerImpl resources, InputStream indexStream, int skipPrefix) throws IOException, ServletException {
        String name;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(indexStream));
        while (null != (name = reader.readLine())) {
            this.addResource(resources, name, skipPrefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResourcesFromZip(ResourceManagerImpl resources, String fileName, String protocol, String prefix, int skipPrefix) throws ServletException, IOException {
        URL jarFile;
        int exclamationPoint = fileName.indexOf("!");
        if (exclamationPoint != -1) {
            fileName = fileName.substring(0, exclamationPoint);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Adding resources from fileName='" + fileName + "' prefix='" + prefix + "' skip=" + skipPrefix + "");
        }
        if (protocol.equals("vfs")) {
            LOG.warn("Protocol '" + protocol + "' is not supported. If resource is needed by the application, you'llneed to put a index file tobago-resource-index.txt in the JAR. File='" + fileName + "'");
            return;
        }
        try {
            if (protocol.equals("vfszip")) {
                fileName = new File(fileName).getParentFile().getParentFile().getPath();
                if (File.separatorChar == '\\' && fileName.contains("\\")) {
                    fileName = fileName.replace('\\', '/');
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Fixed slashes for virtual filesystem protocol on windows system: " + fileName);
                    }
                }
            }
            jarFile = new URL(fileName);
        }
        catch (MalformedURLException e) {
            jarFile = new URL("file:" + fileName);
        }
        InputStream stream = null;
        ZipInputStream zipStream = null;
        try {
            stream = jarFile.openStream();
            zipStream = new ZipInputStream(stream);
            ZipEntry nextEntry = zipStream.getNextEntry();
            while (nextEntry != null) {
                String name;
                if (!nextEntry.isDirectory() && (name = "/" + nextEntry.getName()).startsWith(prefix)) {
                    this.addResource(resources, name, skipPrefix);
                }
                nextEntry = zipStream.getNextEntry();
            }
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(stream);
            IoUtils.closeQuietly(zipStream);
            throw throwable;
        }
        IoUtils.closeQuietly(stream);
        IoUtils.closeQuietly(zipStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResource(ResourceManagerImpl resources, String name, int skipPrefix) throws ServletException {
        if (!name.endsWith(".class")) {
            if (name.endsWith(".properties")) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Adding properties from: '" + name.substring(1) + "'");
                }
                InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name.substring(1));
                try {
                    this.addProperties(inputStream, resources, name, false, skipPrefix);
                }
                finally {
                    IoUtils.closeQuietly(inputStream);
                }
            } else if (name.endsWith(".properties.xml")) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Adding properties from: '" + name.substring(1) + "'");
                }
                InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name.substring(1));
                try {
                    this.addProperties(inputStream, resources, name, true, skipPrefix);
                }
                finally {
                    IoUtils.closeQuietly(inputStream);
                }
            } else {
                resources.add(name.substring(skipPrefix));
            }
        }
    }

    private String ensureSlash(String resourcePath) {
        if (!resourcePath.startsWith("/")) {
            resourcePath = '/' + resourcePath;
        }
        if (!resourcePath.endsWith("/")) {
            resourcePath = resourcePath + '/';
        }
        return resourcePath;
    }

    private void addProperties(InputStream stream, ResourceManagerImpl resources, String childPath, boolean xml, int skipPrefix) throws ServletException {
        String directory = childPath.substring(skipPrefix, childPath.lastIndexOf(47));
        String filename = childPath.substring(childPath.lastIndexOf(47) + 1);
        int end = filename.lastIndexOf(46);
        if (xml) {
            end = filename.lastIndexOf(46, end - 1);
        }
        String locale = filename.substring(0, end);
        Properties temp = new Properties();
        try {
            if (xml) {
                temp.loadFromXML(stream);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(childPath);
                    LOG.debug("xml properties: {}", (Object)temp.size());
                }
            } else {
                temp.load(stream);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(childPath);
                    LOG.debug("    properties: {}", (Object)temp.size());
                }
            }
        }
        catch (IOException e) {
            String msg = "while loading " + childPath;
            LOG.error(msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
        finally {
            IoUtils.closeQuietly(stream);
        }
        Enumeration<?> e = temp.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            resources.add(directory + '/' + locale + '/' + key, temp.getProperty(key));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(directory + '/' + locale + '/' + key + "=" + temp.getProperty(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectThemeVersion(URL tobagoConfigUrl, ThemeImpl theme) throws IOException {
        if (theme.isVersioned()) {
            String themeUrlStr = tobagoConfigUrl.toString();
            int index = themeUrlStr.indexOf(META_INF_TOBAGO_CONFIG_XML);
            String metaInf = themeUrlStr.substring(0, index) + "META-INF/MANIFEST.MF";
            Properties properties = new Properties();
            URL url = new URL(metaInf);
            InputStream inputStream = null;
            String version = null;
            try {
                inputStream = url.openStream();
                properties.load(inputStream);
                version = properties.getProperty("Implementation-Version");
            }
            catch (FileNotFoundException e) {
                LOG.error("No Manifest-File found.");
            }
            finally {
                IoUtils.closeQuietly(inputStream);
            }
            if (version != null) {
                theme.setVersion(version);
            } else {
                theme.setVersioned(false);
                LOG.error("No Implementation-Version found in Manifest-File for theme: '" + theme.getName() + "'. Resetting the theme to unversioned. Please correct the Manifest-File.");
            }
        }
    }
}

