/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.lifecycle;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseId;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.internal.component.AbstractUIPage;
import org.apache.myfaces.tobago.internal.lifecycle.PhaseExecutor;
import org.apache.myfaces.tobago.internal.lifecycle.TobagoLifecycle;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.Secret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class RestoreViewExecutor
implements PhaseExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreViewExecutor.class);

    RestoreViewExecutor() {
    }

    public boolean execute(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map sessionMap = externalContext.getSessionMap();
        UIViewRoot viewRoot = (UIViewRoot)sessionMap.get(TobagoLifecycle.VIEW_ROOT_KEY);
        if (viewRoot != null) {
            facesContext.setViewRoot(viewRoot);
            sessionMap.remove(TobagoLifecycle.VIEW_ROOT_KEY);
            List messageHolders = (List)sessionMap.get(TobagoLifecycle.FACES_MESSAGES_KEY);
            if (messageHolders != null) {
                for (Object[] messageHolder : messageHolders) {
                    facesContext.addMessage((String)messageHolder[0], (FacesMessage)messageHolder[1]);
                }
            }
            sessionMap.remove(TobagoLifecycle.FACES_MESSAGES_KEY);
            if (viewRoot.getChildCount() > 0 && viewRoot.getChildren().get(0) instanceof AbstractUIPage) {
                ((UIComponent)viewRoot.getChildren().get(0)).decode(facesContext);
            }
            facesContext.renderResponse();
            return true;
        }
        if (facesContext.getViewRoot() != null) {
            facesContext.getViewRoot().setLocale(facesContext.getExternalContext().getRequestLocale());
            ComponentUtils.resetPage((FacesContext)facesContext);
            RestoreViewExecutor.recursivelyHandleComponentReferencesAndSetValid(facesContext, (UIComponent)facesContext.getViewRoot());
            return false;
        }
        String viewId = RestoreViewExecutor.deriveViewId(facesContext);
        if (viewId == null) {
            if (externalContext.getRequestServletPath() == null) {
                return true;
            }
            if (!externalContext.getRequestServletPath().endsWith("/")) {
                try {
                    externalContext.redirect(externalContext.getRequestServletPath() + "/");
                    facesContext.responseComplete();
                    return true;
                }
                catch (IOException e) {
                    throw new FacesException("redirect failed", (Throwable)e);
                }
            }
        }
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        boolean postBack = this.isPostBack(facesContext);
        if (postBack) {
            viewRoot = viewHandler.restoreView(facesContext, viewId);
        }
        if (viewRoot == null) {
            viewRoot = viewHandler.createView(facesContext, viewId);
            viewRoot.setViewId(viewId);
            facesContext.renderResponse();
        }
        facesContext.setViewRoot(viewRoot);
        ComponentUtils.resetPage((FacesContext)facesContext);
        if (!postBack) {
            facesContext.renderResponse();
        }
        if (!this.isSessionSecretValid(facesContext)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Secret is invalid!");
            }
            facesContext.renderResponse();
        }
        RestoreViewExecutor.recursivelyHandleComponentReferencesAndSetValid(facesContext, (UIComponent)viewRoot);
        facesContext.getExternalContext().getRequestMap().put(TobagoLifecycle.VIEW_ROOT_KEY, viewRoot);
        return false;
    }

    private boolean isPostBack(FacesContext facesContext) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        return requestParameterMap.containsKey("javax.faces.ViewState");
    }

    private boolean isSessionSecretValid(FacesContext facesContext) {
        if (TobagoConfig.getInstance((FacesContext)FacesContext.getCurrentInstance()).isCheckSessionSecret()) {
            return Secret.check((FacesContext)facesContext);
        }
        return true;
    }

    public PhaseId getPhase() {
        return PhaseId.RESTORE_VIEW;
    }

    private static String deriveViewId(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String viewId = externalContext.getRequestPathInfo();
        if (viewId == null) {
            String suffix;
            viewId = externalContext.getRequestServletPath();
            if (viewId == null) {
                String msg = "RequestServletPath is null, cannot determine viewId of current page.";
                LOG.error("RequestServletPath is null, cannot determine viewId of current page.");
                throw new FacesException("RequestServletPath is null, cannot determine viewId of current page.");
            }
            String defaultSuffix = externalContext.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            String string = suffix = defaultSuffix != null ? defaultSuffix : ".xhtml .jsp";
            if (suffix.charAt(0) != '.') {
                String msg = "Default suffix must start with a dot!";
                LOG.error("Default suffix must start with a dot!");
                throw new FacesException("Default suffix must start with a dot!");
            }
            int dot = viewId.lastIndexOf(46);
            if (dot == -1) {
                LOG.error("Assumed extension mapping, but there is no extension in " + viewId);
                viewId = null;
            } else {
                viewId = viewId.substring(0, dot) + suffix;
            }
        }
        return viewId;
    }

    public static void recursivelyHandleComponentReferencesAndSetValid(FacesContext facesContext, UIComponent parent) {
        boolean forceHandle = false;
        Method handleBindingsMethod = RestoreViewExecutor.getBindingMethod(parent);
        if (handleBindingsMethod != null) {
            try {
                handleBindingsMethod.invoke((Object)parent, new Object[0]);
            }
            catch (Throwable th) {
                LOG.error("Exception while invoking handleBindings on component with client-id:" + parent.getClientId(facesContext), th);
            }
        } else {
            Iterator it = parent.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent component = (UIComponent)it.next();
                ValueBinding binding = component.getValueBinding("binding");
                if (binding != null && !binding.isReadOnly(facesContext)) {
                    binding.setValue(facesContext, (Object)component);
                }
                if (component instanceof UIInput) {
                    ((UIInput)component).setValid(true);
                }
                RestoreViewExecutor.recursivelyHandleComponentReferencesAndSetValid(facesContext, component);
            }
        }
    }

    private static Method getBindingMethod(UIComponent parent) {
        Class<?>[] interfaces;
        for (Class<?> clazz : interfaces = parent.getClass().getInterfaces()) {
            if (!clazz.getName().contains("BindingAware")) continue;
            try {
                return parent.getClass().getMethod("handleBindings", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }
}

