/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITextarea;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputRendererBase
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(InputRendererBase.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        if (!(component instanceof UIInput)) {
            return;
        }
        UIInput input = (UIInput)component;
        if (ComponentUtils.isOutputOnly(component)) {
            return;
        }
        String clientId = component.getClientId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(clientId)) {
            String newValue = (String)requestParameterMap.get(clientId);
            if (LOG.isDebugEnabled()) {
                boolean password = ComponentUtils.getBooleanAttribute(component, "password");
                LOG.debug("clientId='{}'", (Object)clientId);
                LOG.debug("requestParameterMap.get(clientId)='{}'", (Object)StringUtils.toConfidentialString(newValue, password));
            }
            if (input instanceof UITextarea) {
                UITextarea textarea = (UITextarea)input;
                if (ComponentUtils.getDataAttribute((UIComponent)input, "html-editor") != null && "auto".equals(textarea.getSanitize())) {
                    Sanitizer sanitizer = TobagoConfig.getInstance(facesContext).getSanitizer();
                    newValue = sanitizer.sanitize(newValue);
                }
            }
            input.setSubmittedValue((Object)newValue);
        }
    }
}

