/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import org.apache.myfaces.tobago.internal.component.AbstractUIGridLayout;
import org.apache.myfaces.tobago.internal.component.AbstractUILayoutBase;
import org.apache.myfaces.tobago.internal.layout.Interval;
import org.apache.myfaces.tobago.internal.layout.IntervalList;
import org.apache.myfaces.tobago.internal.layout.LayoutUtils;
import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.LayoutManager;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.Orientation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUITabGroupLayout
extends AbstractUILayoutBase
implements LayoutManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUIGridLayout.class);
    private boolean horizontalAuto;
    private boolean verticalAuto;

    public void init() {
        for (LayoutComponent component : this.getLayoutContainer().getComponents()) {
            if (!(component instanceof LayoutContainer) || !component.isRendered()) continue;
            ((LayoutContainer)((Object)component)).getLayoutManager().init();
        }
    }

    public void fixRelativeInsideAuto(Orientation orientation, boolean auto) {
        if (orientation == Orientation.HORIZONTAL) {
            this.horizontalAuto = auto;
        } else {
            this.verticalAuto = auto;
        }
        for (LayoutComponent component : this.getLayoutContainer().getComponents()) {
            if (!(component instanceof LayoutContainer) || !component.isRendered()) continue;
            ((LayoutContainer)((Object)component)).getLayoutManager().fixRelativeInsideAuto(orientation, auto);
        }
    }

    public void preProcessing(Orientation orientation) {
        IntervalList intervals = new IntervalList();
        for (LayoutComponent component : this.getLayoutContainer().getComponents()) {
            if (component instanceof LayoutContainer && component.isRendered()) {
                ((LayoutContainer)((Object)component)).getLayoutManager().preProcessing(orientation);
            }
            if ((orientation != Orientation.HORIZONTAL || !this.horizontalAuto) && (orientation != Orientation.VERTICAL || !this.verticalAuto)) continue;
            intervals.add(new Interval(component, orientation));
        }
        if (intervals.size() >= 1) {
            intervals.evaluate();
            Measure size = intervals.getCurrent();
            LayoutUtils.setCurrentSize(orientation, this.getLayoutContainer(), size);
        }
    }

    public void mainProcessing(Orientation orientation) {
        if (orientation == Orientation.HORIZONTAL && !this.horizontalAuto || orientation == Orientation.VERTICAL && !this.verticalAuto) {
            LayoutContainer container = this.getLayoutContainer();
            Measure available = LayoutUtils.getCurrentSize(orientation, container);
            if (available != null) {
                for (LayoutComponent component : this.getLayoutContainer().getComponents()) {
                    LayoutUtils.setCurrentSize(orientation, component, available);
                }
            } else {
                LOG.warn("No width/height set but needed for *!");
            }
        }
        for (LayoutComponent component : this.getLayoutContainer().getComponents()) {
            if (!(component instanceof LayoutContainer) || !component.isRendered()) continue;
            ((LayoutContainer)((Object)component)).getLayoutManager().mainProcessing(orientation);
        }
    }

    public void postProcessing(Orientation orientation) {
        for (LayoutComponent component : this.getLayoutContainer().getComponents()) {
            if (!(component instanceof LayoutContainer) || !component.isRendered()) continue;
            ((LayoutContainer)((Object)component)).getLayoutManager().postProcessing(orientation);
        }
    }

    private LayoutContainer getLayoutContainer() {
        return (LayoutContainer)this.getParent();
    }

    public boolean getRendersChildren() {
        return false;
    }
}

