/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.event;

import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.tobago.event.AbstractPopupActionListener;
import org.apache.myfaces.tobago.internal.component.AbstractUIPopup;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopupActionListener
extends AbstractPopupActionListener
implements StateHolder {
    private static final Logger LOG = LoggerFactory.getLogger(PopupActionListener.class);
    private String popupId;

    public PopupActionListener() {
    }

    public PopupActionListener(String popupId) {
        this.popupId = popupId;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add ActionListener: {}", (Object)popupId);
        }
    }

    protected AbstractUIPopup getPopup(ActionEvent actionEvent) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        AbstractUIPopup popup = (AbstractUIPopup)ComponentUtils.findComponent(actionEvent.getComponent(), this.popupId);
        if (popup == null) {
            LOG.error("Found no popup for \"{}\"! Search base componentId : {}" + this.popupId, (Object)actionEvent.getComponent().getClientId(facesContext));
        }
        return popup;
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.popupId = (String)values[0];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.popupId};
        return values;
    }

    public void setTransient(boolean newTransientValue) {
    }
}

