/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.tobago.application.ProjectStage;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.internal.util.IoUtils;
import org.apache.myfaces.tobago.internal.util.MimeTypeUtils;
import org.apache.myfaces.tobago.internal.util.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = -4491419290205206466L;
    private static final Logger LOG = LoggerFactory.getLogger(ResourceServlet.class);
    private Long expires;
    private int bufferSize;
    private Set<String> resourceDirs = new HashSet<String>();
    private boolean nosniffHeader;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        TobagoConfig tobagoConfig = TobagoConfig.getInstance(servletConfig.getServletContext());
        if (tobagoConfig.getProjectStage() == ProjectStage.Production) {
            this.expires = 86400000L;
        }
        Theme defaultTheme = tobagoConfig.getDefaultTheme();
        this.addResourceDir(defaultTheme.getFallbackList());
        this.addResourceDir(tobagoConfig.getSupportedThemes());
        String expiresString = servletConfig.getInitParameter("expires");
        if (expiresString != null) {
            try {
                this.expires = new Long(expiresString) * 1000L;
            }
            catch (NumberFormatException e) {
                LOG.error("Caught: " + e.getMessage(), (Throwable)e);
            }
        }
        String bufferSizeString = servletConfig.getInitParameter("bufferSize");
        this.bufferSize = 4096;
        if (bufferSizeString != null) {
            try {
                this.bufferSize = Integer.parseInt(bufferSizeString);
            }
            catch (NumberFormatException e) {
                LOG.error("Caught: " + e.getMessage(), (Throwable)e);
            }
        }
        this.nosniffHeader = tobagoConfig.isSetNosniffHeader();
    }

    private void addResourceDir(List<Theme> themes) {
        for (Theme theme : themes) {
            this.addResourceDir(theme);
        }
    }

    private void addResourceDir(Theme theme) {
        String dir = theme.getResourcePath();
        if (dir.startsWith("/")) {
            this.resourceDirs.add(dir.substring(1));
        } else {
            this.resourceDirs.add(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        InputStream inputStream;
        block9: {
            String contentType;
            String requestURI = request.getRequestURI();
            String resource = requestURI.substring(request.getContextPath().length() + 1);
            for (String resourceDir : this.resourceDirs) {
                if (!resource.startsWith(resourceDir + "/")) continue;
                int dirLength = resourceDir.length();
                if (dirLength >= resource.length() || !Character.isDigit(resource.charAt(dirLength + 1))) break;
                resource = resourceDir + resource.substring(resource.indexOf(47, dirLength + 1));
                break;
            }
            if (this.expires != null) {
                response.setDateHeader("Last-Modified", 0L);
                response.setHeader("Cache-Control", "Public, max-age=" + this.expires);
                response.setDateHeader("Expires", System.currentTimeMillis() + this.expires);
            }
            if ((contentType = MimeTypeUtils.getMimeTypeForFile(requestURI)) != null) {
                response.setContentType(contentType);
                if (this.nosniffHeader) {
                    ResponseUtils.ensureNosniffHeader(response);
                }
            } else {
                LOG.warn("Unsupported mime type of resource='" + resource + "' (because of security reasons)");
                response.setStatus(403);
                return;
            }
            inputStream = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                inputStream = classLoader.getResourceAsStream("META-INF/resources/" + resource);
                if (inputStream == null) {
                    inputStream = classLoader.getResourceAsStream(resource);
                }
                if (inputStream != null) {
                    this.copy(inputStream, (OutputStream)response.getOutputStream());
                    break block9;
                }
                String message = "Resource '" + resource + "' not found!";
                LOG.warn(message);
                response.setStatus(404);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(inputStream);
    }

    protected long getLastModified(HttpServletRequest request) {
        if (this.expires != null) {
            return 0L;
        }
        return super.getLastModified(request);
    }

    private void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int count;
        byte[] buffer = new byte[this.bufferSize];
        while (-1 != (count = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, count);
        }
    }
}

