/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.TreeDataModel;
import org.apache.myfaces.tobago.model.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNodeDataModel
extends TreeDataModel {
    private static final Logger LOG = LoggerFactory.getLogger(TreeNodeDataModel.class);
    private TreeNode data;
    private int rowIndex = -1;
    private Map<Integer, Data> mapping;
    private Map<TreeNode, Integer> back;
    private boolean showRoot;
    private ExpandedState expandedState;

    public TreeNodeDataModel(TreeNode data, boolean showRoot, ExpandedState expandedState) {
        this.data = data;
        this.showRoot = showRoot;
        this.mapping = new HashMap<Integer, Data>();
        this.back = new HashMap<TreeNode, Integer>();
        this.expandedState = expandedState;
        this.reset();
    }

    @Override
    public void reset() {
        this.mapping.clear();
        this.back.clear();
        TreeNode current = this.data;
        int counter = this.back.size();
        while (current != null) {
            this.mapping.put(counter, new Data(current));
            this.back.put(current, counter);
            current = current.getChildCount() > 0 && this.expandedState.isExpanded(current) ? current.getChildAt(0) : this.getNextNodeButNoChild(current);
            ++counter;
        }
    }

    @Override
    public void update(ExpandedState expandedState) {
        this.expandedState = expandedState;
        TreeNode current = this.data;
        int counter = this.back.size();
        while (current != null) {
            if (!this.back.containsKey(current)) {
                this.mapping.put(counter, new Data(current));
                this.back.put(current, counter);
                ++counter;
            }
            if (current.getChildCount() > 0 && expandedState.isExpanded(current)) {
                current = current.getChildAt(0);
                continue;
            }
            current = this.getNextNodeButNoChild(current);
        }
    }

    private TreeNode getNextNodeButNoChild(TreeNode node) {
        TreeNode next;
        while ((next = this.nextSibling(node)) == null) {
            if ((node = node.getParent()) != null) continue;
            return null;
        }
        return next;
    }

    private TreeNode nextSibling(TreeNode node) {
        TreeNode parent = node.getParent();
        if (parent == null) {
            return null;
        }
        for (int i = 0; i < parent.getChildCount() - 1; ++i) {
            if (parent.getChildAt(i) != node) continue;
            return parent.getChildAt(i + 1);
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.mapping.size();
    }

    public TreeNode getRowData() {
        return this.mapping.get(this.rowIndex).getNode();
    }

    @Override
    public int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public int getLevel() {
        int count = -1;
        for (TreeNode node = this.getRowData(); node != null; node = node.getParent()) {
            ++count;
        }
        return count;
    }

    @Override
    public TreePath getPath() {
        return new TreePath(this.getRowData());
    }

    @Override
    public int getDepth() {
        if (this.data instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)this.data).getDepth();
        }
        return -1;
    }

    @Override
    public boolean isFolder() {
        return !this.getRowData().isLeaf();
    }

    @Override
    public Object getWrappedData() {
        return this.data;
    }

    @Override
    public boolean isRowAvailable() {
        return 0 <= this.rowIndex && this.rowIndex < this.getRowCount();
    }

    @Override
    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    @Override
    public void setWrappedData(Object data) {
        this.data = (TreeNode)data;
    }

    @Override
    public boolean isRowVisible() {
        if (!this.isRowAvailable()) {
            return false;
        }
        TreeNode start = this.getRowData();
        if (start.getParent() == null) {
            return this.showRoot;
        }
        for (TreeNode node = start.getParent(); node != null && this.back.get(node) != null; node = node.getParent()) {
            Data data = this.mapping.get(this.back.get(node));
            if (data.getNode().getParent() == null && !this.showRoot) {
                return true;
            }
            if (this.expandedState.isExpanded(new TreePath(node))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getRowClientId() {
        if (this.isRowAvailable()) {
            return this.mapping.get(this.rowIndex).getClientId();
        }
        return null;
    }

    @Override
    public void setRowClientId(String clientId) {
        if (this.isRowAvailable()) {
            this.mapping.get(this.rowIndex).setClientId(clientId);
        } else {
            LOG.warn("No row index set: clientId='" + clientId + "'");
        }
    }

    @Override
    public String getRowParentClientId() {
        if (this.isRowAvailable()) {
            TreeNode parent = this.mapping.get(this.rowIndex).getNode().getParent();
            if (parent != null && this.back.get(parent) != null) {
                return this.mapping.get(this.back.get(parent)).getClientId();
            }
            return null;
        }
        return null;
    }

    @Override
    public List<Integer> getRowIndicesOfChildren() {
        TreeNode node = this.getRowData();
        int n = node.getChildCount();
        ArrayList<Integer> children = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            Integer integer = this.back.get(node.getChildAt(i));
            if (integer == null) continue;
            children.add(integer);
        }
        return children;
    }

    @Override
    public List<Boolean> getJunctions() {
        Stack<Boolean> junctions = new Stack<Boolean>();
        for (TreeNode node = this.getRowData(); node != null; node = node.getParent()) {
            junctions.add(this.hasNextSibling(node));
        }
        Collections.reverse(junctions);
        return junctions;
    }

    private boolean hasNextSibling(TreeNode node) {
        TreeNode parent = node.getParent();
        return parent != null && parent.getChildAt(parent.getChildCount() - 1) != node;
    }

    private static class Data {
        private TreeNode node;
        private String clientId;

        private Data(TreeNode node) {
            this.node = node;
        }

        public TreeNode getNode() {
            return this.node;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }
    }
}

