/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIObject;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectTag.class);
    private ValueExpression markup;
    private ValueExpression src;
    private ValueExpression name;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Object";
    }

    public String getRendererType() {
        return "Object";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UIObject component = (UIObject)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.src != null) {
            component.setValueExpression("src", this.src);
        }
        if (this.name != null) {
            component.setValueExpression("name", this.name);
        }
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getSrc() {
        return this.src;
    }

    public void setSrc(ValueExpression src) {
        this.src = src;
    }

    public ValueExpression getName() {
        return this.name;
    }

    public void setName(ValueExpression name) {
        this.name = name;
    }

    public void release() {
        super.release();
        this.markup = null;
        this.src = null;
        this.name = null;
    }
}

