/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.apache.myfaces.tobago.application.ProjectStage;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.UserAgent;
import org.apache.myfaces.tobago.internal.config.TobagoConfigImpl;
import org.apache.myfaces.tobago.internal.context.ClientPropertiesKey;
import org.apache.myfaces.tobago.internal.context.ImageCacheKey;
import org.apache.myfaces.tobago.internal.context.JspCacheKey;
import org.apache.myfaces.tobago.internal.context.MeasureValue;
import org.apache.myfaces.tobago.internal.context.MiscCacheKey;
import org.apache.myfaces.tobago.internal.context.PropertyCacheKey;
import org.apache.myfaces.tobago.internal.context.RendererCacheKey;
import org.apache.myfaces.tobago.internal.context.StringValue;
import org.apache.myfaces.tobago.internal.context.ThemeConfigCacheKey;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerImpl
implements ResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceManagerImpl.class);
    private static final String PROPERTY = "property";
    private static final String JSP = "jsp";
    private static final String TAG = "tag";
    private static final String MINIMIZE_SUFFIX = ".min";
    public static final String[] EXT_NONE = new String[]{""};
    public static final String[] EXT_JS = new String[]{".js"};
    public static final String[] EXT_CSS = new String[]{".css"};
    public static final String[] EXT_GIF = new String[]{".gif"};
    public static final String[] EXT_PNG = new String[]{".png"};
    public static final String[] EXT_JPG = new String[]{".jpg"};
    public static final String[] EXT_ICO = new String[]{".ico"};
    public static final String[] EXT_IMAGES = new String[]{".svg", ".png", ".gif", ".jpg"};
    public static final String[] EXT_JSP = new String[]{".jsp"};
    public static final String[] EXT_JSPX = new String[]{".jspx"};
    public static final String[] EXT_XHTML = new String[]{".xhtml"};
    public static final String[] EXT_SVG = new String[]{".svg"};
    private boolean production;
    private final Map<String, String> resourceList = new ConcurrentHashMap<String, String>(100, 0.75f, 1);
    private final Map<RendererCacheKey, Renderer> rendererCache = new ConcurrentHashMap<RendererCacheKey, Renderer>(100, 0.75f, 1);
    private final Map<ImageCacheKey, StringValue> imageCache = new ConcurrentHashMap<ImageCacheKey, StringValue>(100, 0.75f, 1);
    private final Map<JspCacheKey, String> jspCache = new ConcurrentHashMap<JspCacheKey, String>(100, 0.75f, 1);
    private final Map<MiscCacheKey, String[]> miscCache = new ConcurrentHashMap<MiscCacheKey, String[]>(100, 0.75f, 1);
    private final Map<PropertyCacheKey, StringValue> propertyCache = new ConcurrentHashMap<PropertyCacheKey, StringValue>(100, 0.75f, 1);
    private final Map<ThemeConfigCacheKey, MeasureValue> themeCache = new ConcurrentHashMap<ThemeConfigCacheKey, MeasureValue>(100, 0.75f, 1);
    private final Map<String, String[]> extensionCache = new ConcurrentHashMap<String, String[]>(10, 0.75f, 1);
    private TobagoConfigImpl tobagoConfig;

    public ResourceManagerImpl(TobagoConfigImpl tobagoConfig) {
        this.tobagoConfig = tobagoConfig;
        this.production = tobagoConfig.getProjectStage() == ProjectStage.Production;
        this.extensionCache.put("", EXT_NONE);
        this.extensionCache.put(".js", EXT_JS);
        this.extensionCache.put(".css", EXT_CSS);
        this.extensionCache.put(".gif", EXT_GIF);
        this.extensionCache.put(".png", EXT_PNG);
        this.extensionCache.put(".jpg", EXT_JPG);
        this.extensionCache.put(".ico", EXT_ICO);
        this.extensionCache.put(".jsp", EXT_JSP);
        this.extensionCache.put(".jspx", EXT_JSPX);
        this.extensionCache.put(".xhtml", EXT_XHTML);
        this.extensionCache.put(".svg", EXT_SVG);
    }

    public void add(String resourceKey) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding resourceKey = '{}'", (Object)resourceKey);
        }
        this.resourceList.put(resourceKey, "");
    }

    public void add(String resourceKey, String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding resourceKey = '{}' value= '{}'", (Object)resourceKey, (Object)value);
        }
        this.resourceList.put(resourceKey, value);
    }

    @Deprecated
    public String getJsp(UIViewRoot viewRoot, String name) {
        String result = null;
        if (name != null) {
            ClientPropertiesKey clientKey = ClientPropertiesKey.get(FacesContext.getCurrentInstance());
            JspCacheKey cacheKey = new JspCacheKey(clientKey, name);
            result = this.jspCache.get(cacheKey);
            if (result != null) {
                return result;
            }
            try {
                result = (String)this.getPaths(clientKey, "", JSP, name, EXT_NONE, false, true, true, null, true, false).get(0);
                this.jspCache.put(cacheKey, result);
            }
            catch (Exception e) {
                LOG.error("name = '" + name + "' clientProperties = '" + clientKey.toString() + "'", (Throwable)e);
            }
        }
        return result;
    }

    @Deprecated
    public String getProperty(UIViewRoot viewRoot, String bundle, String propertyKey) {
        return this.getProperty(FacesContext.getCurrentInstance(), bundle, propertyKey);
    }

    public String getProperty(FacesContext facesContext, String bundle, String propertyKey) {
        if (bundle != null && propertyKey != null) {
            ClientPropertiesKey clientKey = ClientPropertiesKey.get(facesContext);
            PropertyCacheKey cacheKey = new PropertyCacheKey(clientKey, bundle, propertyKey);
            StringValue result = this.propertyCache.get(cacheKey);
            if (result == null) {
                List properties = this.getPaths(clientKey, "", PROPERTY, bundle, EXT_NONE, false, true, false, propertyKey, true, false);
                result = properties != null ? new StringValue((String)properties.get(0)) : StringValue.NULL;
                this.propertyCache.put(cacheKey, result);
            }
            return result.getValue();
        }
        return null;
    }

    @Deprecated
    public Renderer getRenderer(UIViewRoot viewRoot, String rendererType) {
        return this.getRenderer(FacesContext.getCurrentInstance(), rendererType);
    }

    public Renderer getRenderer(FacesContext facesContext, String rendererType) {
        Renderer renderer = null;
        if (rendererType != null) {
            ClientPropertiesKey clientKey = ClientPropertiesKey.get(facesContext);
            RendererCacheKey cacheKey = new RendererCacheKey(clientKey, rendererType);
            renderer = this.rendererCache.get(cacheKey);
            if (renderer != null) {
                return renderer;
            }
            String simpleClassName = null;
            try {
                simpleClassName = this.getRendererClassName(rendererType);
                List classes = this.getPaths(clientKey, "", TAG, simpleClassName, EXT_NONE, false, true, true, null, false, false);
                if (classes != null && !classes.isEmpty()) {
                    Class clazz = (Class)classes.get(0);
                    renderer = (Renderer)clazz.newInstance();
                    this.rendererCache.put(cacheKey, renderer);
                } else {
                    LOG.error("Don't find any RendererClass for " + simpleClassName + ". Please check you configuration.");
                }
            }
            catch (InstantiationException e) {
                LOG.error("name = '" + simpleClassName + "' clientProperties = '" + clientKey.toString() + "'", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error("name = '" + simpleClassName + "' clientProperties = '" + clientKey.toString() + "'", (Throwable)e);
            }
        }
        return renderer;
    }

    @Deprecated
    public String[] getScripts(UIViewRoot viewRoot, String name) {
        return this.getScripts(FacesContext.getCurrentInstance(), name);
    }

    public String[] getScripts(FacesContext facesContext, String name) {
        return this.getStrings(facesContext, name, null);
    }

    @Deprecated
    public String[] getStyles(UIViewRoot viewRoot, String name) {
        return this.getStyles(FacesContext.getCurrentInstance(), name);
    }

    public String[] getStyles(FacesContext facesContext, String name) {
        return this.getStrings(facesContext, name, null);
    }

    @Deprecated
    public String getThemeProperty(UIViewRoot viewRoot, String bundle, String propertyKey) {
        if (bundle != null && propertyKey != null) {
            ClientPropertiesKey clientKey = ClientPropertiesKey.get(FacesContext.getCurrentInstance());
            PropertyCacheKey cacheKey = new PropertyCacheKey(clientKey, bundle, propertyKey);
            StringValue result = this.propertyCache.get(cacheKey);
            if (result == null) {
                List properties = this.getPaths(clientKey, "", PROPERTY, bundle, EXT_NONE, false, true, false, propertyKey, true, true);
                result = properties != null ? new StringValue((String)properties.get(0)) : StringValue.NULL;
                this.propertyCache.put(cacheKey, result);
            }
            return result.getValue();
        }
        return null;
    }

    public Measure getThemeMeasure(FacesContext facesContext, Configurable configurable, String name) {
        return this.getThemeMeasure(facesContext, configurable.getRendererType(), configurable.getCurrentMarkup(), name);
    }

    public Measure getThemeMeasure(FacesContext facesContext, String rendererType, Markup markup, String name) {
        ClientPropertiesKey clientKey = ClientPropertiesKey.get(facesContext);
        ThemeConfigCacheKey cacheKey = new ThemeConfigCacheKey(clientKey, rendererType, markup, name);
        MeasureValue result = this.themeCache.get(cacheKey);
        if (result == null) {
            List properties = this.getPaths(clientKey, "", PROPERTY, "tobago-theme-config", EXT_NONE, false, true, false, rendererType + "." + name, true, true);
            Measure measure = null;
            if (properties != null) {
                measure = Measure.valueOf(properties.get(0));
            }
            if (markup != null) {
                for (String m : markup) {
                    List mProperties = this.getPaths(clientKey, "", PROPERTY, "tobago-theme-config", EXT_NONE, false, true, false, rendererType + "[" + m + "]" + "." + name, true, true);
                    if (mProperties == null) continue;
                    Measure summand = Measure.valueOf(mProperties.get(0));
                    measure = summand.add(measure);
                }
            }
            result = measure != null ? new MeasureValue(measure) : MeasureValue.NULL;
            this.themeCache.put(cacheKey, result);
        }
        return result.getValue();
    }

    @Deprecated
    public String getImage(UIViewRoot viewRoot, String name) {
        return this.getImage(FacesContext.getCurrentInstance(), name);
    }

    @Deprecated
    public String getImage(FacesContext facesContext, String name) {
        return this.getImage(facesContext, name, false);
    }

    @Deprecated
    public String getImage(UIViewRoot viewRoot, String name, boolean ignoreMissing) {
        return this.getImage(FacesContext.getCurrentInstance(), name, ignoreMissing);
    }

    @Deprecated
    public String getImage(FacesContext facesContext, String nameWithExtension, boolean ignoreMissing) {
        if (nameWithExtension != null) {
            int dot = nameWithExtension.lastIndexOf(46);
            if (dot == -1) {
                dot = nameWithExtension.length();
            }
            return this.getImage(facesContext, nameWithExtension.substring(0, dot), nameWithExtension.substring(dot), ignoreMissing);
        }
        return null;
    }

    public String getImage(FacesContext facesContext, String name, String extension, boolean ignoreMissing) {
        if (name != null) {
            String[] extensions = extension == null ? EXT_IMAGES : this.getExtensions(extension);
            ClientPropertiesKey clientKey = ClientPropertiesKey.get(facesContext);
            ImageCacheKey cacheKey = new ImageCacheKey(clientKey, name, extension);
            StringValue result = this.imageCache.get(cacheKey);
            if (result == null) {
                List paths = this.getPaths(clientKey, "", null, name, extensions, false, true, true, null, true, ignoreMissing);
                result = paths != null ? new StringValue((String)paths.get(0)) : StringValue.NULL;
                this.imageCache.put(cacheKey, result);
            }
            if (LOG.isDebugEnabled() && result.getValue() == null) {
                LOG.debug("Can't find image for '{}'", (Object)name);
            }
            return result.getValue();
        }
        return null;
    }

    private List getPaths(ClientPropertiesKey clientKey, String prefix, String subDir, String name, String[] extensions, boolean reverseOrder, boolean single, boolean returnKey, String key, boolean returnStrings, boolean ignoreMissing) {
        ArrayList matches = new ArrayList();
        String contentType = clientKey.getContentType();
        Theme theme = clientKey.getTheme();
        UserAgent browser = clientKey.getUserAgent();
        List<String> locales = LocaleUtils.getLocaleSuffixList(clientKey.getLocale());
        for (String localeSuffix : locales) {
            for (String extension : extensions) {
                boolean found;
                if (this.production) {
                    found = this.checkPath(prefix, reverseOrder, returnKey, returnStrings, matches, name, MINIMIZE_SUFFIX, localeSuffix, extension, key);
                    if (found && (single || !returnStrings)) {
                        return matches;
                    }
                    if (found || !(found = this.checkPath(prefix, reverseOrder, returnKey, returnStrings, matches, name, null, localeSuffix, extension, key)) || !single && returnStrings) continue;
                    return matches;
                }
                found = this.checkPath(prefix, reverseOrder, returnKey, returnStrings, matches, name, null, localeSuffix, extension, key);
                if (!found || !single && returnStrings) continue;
                return matches;
            }
        }
        for (Theme currentTheme : theme.getFallbackList()) {
            for (String resourceDirectory : this.tobagoConfig.getResourceDirs()) {
                for (String browserType : browser.getFallbackList()) {
                    for (String localeSuffix : locales) {
                        for (String extension : extensions) {
                            boolean found;
                            if (this.production) {
                                found = this.checkPath(prefix, reverseOrder, returnKey, returnStrings, matches, resourceDirectory, contentType, currentTheme, browserType, subDir, name, MINIMIZE_SUFFIX, localeSuffix, extension, key);
                                if (found && (single || !returnStrings)) {
                                    return matches;
                                }
                                if (found || !(found = this.checkPath(prefix, reverseOrder, returnKey, returnStrings, matches, resourceDirectory, contentType, currentTheme, browserType, subDir, name, null, localeSuffix, extension, key)) || !single && returnStrings) continue;
                                return matches;
                            }
                            found = this.checkPath(prefix, reverseOrder, returnKey, returnStrings, matches, resourceDirectory, contentType, currentTheme, browserType, subDir, name, null, localeSuffix, extension, key);
                            if (!found || !single && returnStrings) continue;
                            return matches;
                        }
                    }
                }
            }
        }
        if (matches.isEmpty()) {
            if ("style/style".equals(name) && EXT_CSS == extensions) {
                ignoreMissing = true;
            }
            if (!this.production && !ignoreMissing) {
                LOG.warn("Path not found, and no fallback (using empty string) resourceDirs='" + this.tobagoConfig.getResourceDirs() + "' contentType='" + contentType + "' theme='" + theme.getName() + "' browser='" + browser + "' subDir='" + subDir + "' name='" + name + "' extension='" + Arrays.toString(extensions) + "' key='" + key + "'");
            }
            return null;
        }
        return matches;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkPath(String prefix, boolean reverseOrder, boolean returnKey, boolean returnStrings, List matches, String name, String minimizeSuffix, String localeSuffix, String extension, String key) {
        String path = this.makePath(name, minimizeSuffix, localeSuffix, extension, key);
        if (returnStrings && this.resourceList.containsKey(path)) {
            String result;
            String string = result = returnKey ? prefix + path : prefix + this.resourceList.get(path);
            if (reverseOrder) {
                matches.add(0, result);
            } else {
                matches.add(result);
            }
            if (!LOG.isTraceEnabled()) return true;
            LOG.trace("testing path: {} *", (Object)path);
            return true;
        }
        if (!returnStrings) {
            try {
                path = path.substring(1).replace('/', '.');
                Class<?> clazz = Class.forName(path);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("testing path: " + path + " *");
                }
                matches.add(clazz);
                return true;
            }
            catch (ClassNotFoundException e) {
                if (!LOG.isTraceEnabled()) return false;
                LOG.trace("testing path: " + path);
                return false;
            }
        } else {
            if (!LOG.isTraceEnabled()) return false;
            LOG.trace("testing path: " + path);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkPath(String prefix, boolean reverseOrder, boolean returnKey, boolean returnStrings, List matches, String resourceDirectory, String contentType, Theme currentTheme, String browserType, String subDir, String name, String minimizeSuffix, String localeSuffix, String extension, String key) {
        String path = this.makePath(resourceDirectory, contentType, currentTheme, browserType, subDir, name, minimizeSuffix, localeSuffix, extension, key, null);
        if (returnStrings && this.resourceList.containsKey(path)) {
            String result;
            if (prefix.length() == 0 && returnKey && resourceDirectory.equals(currentTheme.getResourcePath())) {
                result = this.makePath(resourceDirectory, contentType, currentTheme, browserType, subDir, name, minimizeSuffix, localeSuffix, extension, key, currentTheme.getVersion());
            } else {
                String string = result = returnKey ? prefix + path : prefix + this.resourceList.get(path);
            }
            if (reverseOrder) {
                matches.add(0, result);
            } else {
                matches.add(result);
            }
            if (!LOG.isTraceEnabled()) return true;
            LOG.trace("testing path: {} *", (Object)path);
            return true;
        }
        if (!returnStrings) {
            try {
                path = path.substring(1).replace('/', '.');
                Class<?> clazz = Class.forName(path);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("testing path: " + path + " *");
                }
                matches.add(clazz);
                return true;
            }
            catch (ClassNotFoundException e) {
                if (!LOG.isTraceEnabled()) return false;
                LOG.trace("testing path: " + path);
                return false;
            }
        } else {
            if (!LOG.isTraceEnabled()) return false;
            LOG.trace("testing path: " + path);
        }
        return false;
    }

    private String makePath(String project, String language, Theme theme, String browser, String subDir, String name, String minimizeSuffix, String localeSuffix, String extension, String key, String version) {
        StringBuilder searchtext = new StringBuilder(64);
        searchtext.append('/');
        searchtext.append(project);
        if (version != null) {
            searchtext.append('/');
            searchtext.append(version);
        }
        searchtext.append('/');
        searchtext.append(language);
        searchtext.append('/');
        searchtext.append(theme.getName());
        searchtext.append('/');
        searchtext.append(browser);
        if (subDir != null) {
            searchtext.append('/');
            searchtext.append(subDir);
        }
        searchtext.append('/');
        searchtext.append(name);
        if (minimizeSuffix != null) {
            searchtext.append(minimizeSuffix);
        }
        searchtext.append(localeSuffix);
        searchtext.append(extension);
        if (key != null) {
            searchtext.append('/');
            searchtext.append(key);
        }
        return searchtext.toString();
    }

    private String makePath(String name, String minimizeSuffix, String localeSuffix, String extension, String key) {
        StringBuilder searchtext = new StringBuilder(64);
        searchtext.append('/');
        searchtext.append(name);
        if (minimizeSuffix != null) {
            searchtext.append(minimizeSuffix);
        }
        searchtext.append(localeSuffix);
        searchtext.append(extension);
        if (key != null) {
            searchtext.append('/');
            searchtext.append(key);
        }
        return searchtext.toString();
    }

    private String getRendererClassName(String rendererType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("rendererType = '{}'", (Object)rendererType);
        }
        String name = "javax.faces.Text".equals(rendererType) ? "Out" : rendererType;
        if ((name = name + "Renderer").startsWith("javax.faces.")) {
            LOG.warn("patching renderer from {}", (Object)name);
            name = name.substring("javax.faces.".length());
            LOG.warn("patching renderer to {}", (Object)name);
        }
        return name;
    }

    private String[] getStrings(FacesContext facesContext, String name, String type) {
        String[] result = new String[]{};
        if (name != null) {
            String[] extensions;
            String nameWithoutExtension;
            int dot = name.lastIndexOf(46);
            if (dot == -1) {
                nameWithoutExtension = name;
                extensions = EXT_NONE;
            } else {
                nameWithoutExtension = name.substring(0, dot);
                String extension = name.substring(dot);
                extensions = this.getExtensions(extension);
            }
            ClientPropertiesKey key = ClientPropertiesKey.get(facesContext);
            MiscCacheKey miscKey = new MiscCacheKey(key, name);
            String[] cacheResult = this.miscCache.get(miscKey);
            if (cacheResult != null) {
                return cacheResult;
            }
            try {
                List matches = this.getPaths(key, "", type, nameWithoutExtension, extensions, true, false, true, null, true, false);
                if (matches != null) {
                    result = matches.toArray(new String[matches.size()]);
                }
                this.miscCache.put(miscKey, result);
            }
            catch (Exception e) {
                LOG.error("name = '" + name + "' clientProperties = '" + key.toString() + "'", (Throwable)e);
            }
        }
        return result;
    }

    private String[] getExtensions(String extension) {
        String[] extensions;
        String[] cached = this.extensionCache.get(extension);
        if (cached != null) {
            extensions = cached;
        } else {
            extensions = new String[]{extension};
            this.extensionCache.put(extension, extensions);
            if (LOG.isInfoEnabled()) {
                LOG.info("Adding extension '{}' to cache.", (Object)extension);
            }
        }
        return extensions;
    }

    public String toString() {
        return "ResourceManagerImpl{production=" + this.production + ", resourceList=" + this.resourceList.size() + ", rendererCache=" + this.rendererCache.size() + ", imageCache=" + this.imageCache.size() + ", jspCache=" + this.jspCache.size() + ", miscCache=" + this.miscCache.size() + ", propertyCache=" + this.propertyCache.size() + ", themeCache=" + this.themeCache.size() + ", extensionCache=" + this.extensionCache.size() + '}';
    }
}

