/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.myfaces.tobago.application.ProjectStage;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.ThemeImpl;
import org.apache.myfaces.tobago.internal.config.ContentSecurityPolicy;
import org.apache.myfaces.tobago.internal.config.RenderersConfig;
import org.apache.myfaces.tobago.internal.config.RenderersConfigImpl;
import org.apache.myfaces.tobago.internal.util.JndiUtils;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TobagoConfigImpl
extends TobagoConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoConfigImpl.class);
    private List<Theme> supportedThemes;
    private List<String> supportedThemeNames = new ArrayList<String>();
    private Theme defaultTheme;
    private String defaultThemeName;
    private List<String> resourceDirs;
    private Map<String, Theme> availableThemes;
    private RenderersConfig renderersConfig;
    private ProjectStage projectStage;
    private boolean createSessionSecret = true;
    private boolean checkSessionSecret = true;
    private boolean preventFrameAttacks = true;
    private ContentSecurityPolicy contentSecurityPolicy;
    private boolean setNosniffHeader = true;
    private Map<String, String> defaultValidatorInfo;
    private Sanitizer sanitizer;
    private boolean autoAccessKeyFromLabel = true;
    private boolean classicDateTimePicker = false;
    private Map<String, String> mimeTypes;
    private boolean unmodifiable = false;

    protected TobagoConfigImpl() {
        this.supportedThemes = new ArrayList<Theme>();
        this.resourceDirs = new ArrayList<String>();
        this.contentSecurityPolicy = new ContentSecurityPolicy(ContentSecurityPolicy.Mode.OFF.getValue());
        this.mimeTypes = new HashMap<String, String>();
    }

    protected void lock() {
        this.unmodifiable = true;
        this.supportedThemes = Collections.unmodifiableList(this.supportedThemes);
        for (Theme theme : this.supportedThemes) {
            ((ThemeImpl)theme).lock();
        }
        this.supportedThemeNames = Collections.unmodifiableList(this.supportedThemeNames);
        this.resourceDirs = Collections.unmodifiableList(this.resourceDirs);
        this.availableThemes = Collections.unmodifiableMap(this.availableThemes);
        if (this.renderersConfig instanceof RenderersConfigImpl) {
            ((RenderersConfigImpl)this.renderersConfig).lock();
        }
        this.contentSecurityPolicy.lock();
        this.mimeTypes = Collections.unmodifiableMap(this.mimeTypes);
    }

    private void checkLocked() throws IllegalStateException {
        if (this.unmodifiable) {
            throw new RuntimeException("The configuration must not be changed after initialization!");
        }
    }

    protected void addSupportedThemeName(String name) {
        this.checkLocked();
        this.supportedThemeNames.add(name);
    }

    protected void resolveThemes() {
        this.checkLocked();
        if (this.defaultThemeName != null) {
            this.defaultTheme = this.availableThemes.get(this.defaultThemeName);
            this.checkThemeIsAvailable(this.defaultThemeName, this.defaultTheme);
            if (LOG.isDebugEnabled()) {
                LOG.debug("name = '{}'", (Object)this.defaultThemeName);
                LOG.debug("defaultTheme = '{}'", (Object)this.defaultTheme);
            }
        } else {
            int deep = 0;
            for (Map.Entry<String, Theme> entry : this.availableThemes.entrySet()) {
                Theme theme = entry.getValue();
                if (theme.getFallbackList().size() <= deep) continue;
                this.defaultTheme = theme;
                deep = theme.getFallbackList().size();
            }
            if (this.defaultTheme == null) {
                String error = "Did not found any theme! Please ensure you have a tobago-config.xml with a theme-definition in your theme JAR. Please add a theme JAR to your WEB-INF/lib";
                LOG.error("Did not found any theme! Please ensure you have a tobago-config.xml with a theme-definition in your theme JAR. Please add a theme JAR to your WEB-INF/lib");
                throw new RuntimeException("Did not found any theme! Please ensure you have a tobago-config.xml with a theme-definition in your theme JAR. Please add a theme JAR to your WEB-INF/lib");
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Using default Theme {}", (Object)this.defaultTheme.getName());
            }
        }
        if (!this.supportedThemeNames.isEmpty()) {
            for (String name : this.supportedThemeNames) {
                Theme theme = this.availableThemes.get(name);
                this.checkThemeIsAvailable(name, theme);
                this.supportedThemes.add(theme);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("name = '{}'", (Object)name);
                LOG.debug("supportedThemes.last() = '{}'", (Object)this.supportedThemes.get(this.supportedThemes.size() - 1));
            }
        }
    }

    private void checkThemeIsAvailable(String name, Theme theme) {
        if (theme == null) {
            String error = "Theme not found! name: '" + name + "'. " + "Please ensure you have a tobago-config.xml with a theme-definition in your " + "theme JAR. Found the following themes: " + this.availableThemes.keySet();
            LOG.error(error);
            throw new RuntimeException(error);
        }
    }

    @Override
    public Theme getTheme(String name) {
        if (name == null) {
            LOG.debug("searching theme: null");
            return this.defaultTheme;
        }
        if (this.defaultTheme.getName().equals(name)) {
            return this.defaultTheme;
        }
        for (Theme theme : this.supportedThemes) {
            if (!theme.getName().equals(name)) continue;
            return theme;
        }
        LOG.debug("searching theme '{}' not found. Using default: {}", (Object)name, (Object)this.defaultTheme);
        return this.defaultTheme;
    }

    protected void setDefaultThemeName(String defaultThemeName) {
        this.checkLocked();
        this.defaultThemeName = defaultThemeName;
    }

    @Override
    public List<Theme> getSupportedThemes() {
        return this.supportedThemes;
    }

    protected void addResourceDir(String resourceDir) {
        this.checkLocked();
        if (!this.resourceDirs.contains(resourceDir)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("adding resourceDir = '{}'", (Object)resourceDir);
            }
            this.resourceDirs.add(0, resourceDir);
        }
    }

    public List<String> getResourceDirs() {
        return this.resourceDirs;
    }

    @Override
    public Theme getDefaultTheme() {
        return this.defaultTheme;
    }

    protected void setAvailableThemes(Map<String, Theme> availableThemes) {
        this.checkLocked();
        this.availableThemes = availableThemes;
        for (Theme theme : this.availableThemes.values()) {
            this.addResourceDir(theme.getResourcePath());
        }
    }

    protected RenderersConfig getRenderersConfig() {
        return this.renderersConfig;
    }

    protected void setRenderersConfig(RenderersConfig renderersConfig) {
        this.checkLocked();
        this.renderersConfig = renderersConfig;
    }

    @Override
    public ProjectStage getProjectStage() {
        return this.projectStage;
    }

    protected void initProjectState(ServletContext servletContext) {
        this.checkLocked();
        String stageName = null;
        try {
            InitialContext ctx = new InitialContext();
            Object obj = JndiUtils.getJndiProperty((Context)ctx, "jsf", "ProjectStage");
            if (obj != null) {
                if (obj instanceof String) {
                    stageName = (String)obj;
                } else {
                    LOG.warn("JNDI lookup for key {} should return a java.lang.String value", (Object)"java:comp/env/jsf/ProjectStage");
                }
            }
        }
        catch (NamingException ctx) {
            // empty catch block
        }
        if (stageName == null) {
            stageName = servletContext.getInitParameter("javax.faces.PROJECT_STAGE");
        }
        if (stageName == null) {
            stageName = System.getProperty("org.apache.myfaces.PROJECT_STAGE");
        }
        if (stageName != null) {
            try {
                this.projectStage = ProjectStage.valueOf(stageName);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Couldn't discover the current project stage", (Throwable)e);
            }
        }
        if (this.projectStage == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Couldn't discover the current project stage, using {}", (Object)ProjectStage.Production);
            }
            this.projectStage = ProjectStage.Production;
        }
    }

    protected synchronized void initDefaultValidatorInfo() {
        FacesContext facesContext;
        if (this.defaultValidatorInfo != null) {
            this.checkLocked();
        }
        if ((facesContext = FacesContext.getCurrentInstance()) != null) {
            try {
                Application application = facesContext.getApplication();
                Map map = application.getDefaultValidatorInfo();
                this.defaultValidatorInfo = map.size() > 0 ? Collections.unmodifiableMap(map) : Collections.emptyMap();
            }
            catch (Exception e) {
                LOG.error("Can't initialize default validators (this happens with some JBoss servers).");
                this.defaultValidatorInfo = Collections.emptyMap();
            }
        }
    }

    @Override
    public boolean isCreateSessionSecret() {
        return this.createSessionSecret;
    }

    protected void setCreateSessionSecret(boolean createSessionSecret) {
        this.checkLocked();
        this.createSessionSecret = createSessionSecret;
    }

    @Override
    public boolean isCheckSessionSecret() {
        return this.checkSessionSecret;
    }

    protected void setCheckSessionSecret(boolean checkSessionSecret) {
        this.checkLocked();
        this.checkSessionSecret = checkSessionSecret;
    }

    @Override
    public boolean isPreventFrameAttacks() {
        return this.preventFrameAttacks;
    }

    protected void setPreventFrameAttacks(boolean preventFrameAttacks) {
        this.checkLocked();
        this.preventFrameAttacks = preventFrameAttacks;
    }

    @Override
    public ContentSecurityPolicy getContentSecurityPolicy() {
        return this.contentSecurityPolicy;
    }

    @Override
    public boolean isSetNosniffHeader() {
        return this.setNosniffHeader;
    }

    protected void setSetNosniffHeader(boolean setNosniffHeader) {
        this.checkLocked();
        this.setNosniffHeader = setNosniffHeader;
    }

    public Map<String, String> getDefaultValidatorInfo() {
        if (this.defaultValidatorInfo == null) {
            this.initDefaultValidatorInfo();
        }
        return this.defaultValidatorInfo;
    }

    @Override
    public Sanitizer getSanitizer() {
        return this.sanitizer;
    }

    protected void setSanitizer(Sanitizer sanitizer) {
        this.checkLocked();
        this.sanitizer = sanitizer;
    }

    @Override
    public boolean isAutoAccessKeyFromLabel() {
        return this.autoAccessKeyFromLabel;
    }

    public void setAutoAccessKeyFromLabel(boolean autoAccessKeyFromLabel) {
        this.checkLocked();
        this.autoAccessKeyFromLabel = autoAccessKeyFromLabel;
    }

    @Override
    public Map<String, String> getMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public boolean isClassicDateTimePicker() {
        return this.classicDateTimePicker;
    }

    public void setClassicDateTimePicker(boolean classicDateTimePicker) {
        this.classicDateTimePicker = classicDateTimePicker;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TobagoConfigImpl{");
        builder.append("\nsupportedThemes=[");
        for (Theme supportedTheme : this.supportedThemes) {
            builder.append(supportedTheme.getName());
            builder.append(", ");
        }
        builder.append("], \ndefaultTheme=");
        builder.append(this.defaultTheme.getName());
        builder.append(", \nresourceDirs=");
        builder.append(this.resourceDirs);
        builder.append(", \navailableThemes=");
        builder.append(this.availableThemes.keySet());
        builder.append(", \nprojectStage=");
        builder.append((Object)this.projectStage);
        builder.append(", \ncreateSessionSecret=");
        builder.append(this.createSessionSecret);
        builder.append(", \ncheckSessionSecret=");
        builder.append(this.checkSessionSecret);
        builder.append(", \npreventFrameAttacks=");
        builder.append(this.preventFrameAttacks);
        builder.append(", \ncontentSecurityPolicy=");
        builder.append(this.contentSecurityPolicy);
        builder.append(", \nsetNosniffHeader=");
        builder.append(this.setNosniffHeader);
        builder.append(", \ndefaultValidatorInfo=");
        builder.append(this.defaultValidatorInfo);
        builder.append(", \nsanitizer=");
        builder.append(this.sanitizer);
        builder.append(", \nautoAccessKeyFromLabel=");
        builder.append(this.autoAccessKeyFromLabel);
        builder.append(", \nclassicDateTimePicker=");
        builder.append(this.classicDateTimePicker);
        builder.append(", \nthemes=");
        HashSet<Theme> all = new HashSet<Theme>(this.availableThemes.values());
        builder.append(all);
        builder.append(", \nmimeTypes=");
        builder.append(this.mimeTypes);
        builder.append('}');
        return builder.toString();
    }
}

