/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.util.List;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumn;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnNode;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnSelector;
import org.apache.myfaces.tobago.internal.component.AbstractUILayoutBase;
import org.apache.myfaces.tobago.internal.component.AbstractUISheet;
import org.apache.myfaces.tobago.internal.layout.Grid;
import org.apache.myfaces.tobago.internal.layout.IntervalList;
import org.apache.myfaces.tobago.internal.layout.LayoutUtils;
import org.apache.myfaces.tobago.internal.layout.OriginCell;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.AutoLayoutToken;
import org.apache.myfaces.tobago.layout.LayoutBox;
import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.LayoutManager;
import org.apache.myfaces.tobago.layout.LayoutToken;
import org.apache.myfaces.tobago.layout.LayoutTokens;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.Orientation;
import org.apache.myfaces.tobago.layout.RelativeLayoutToken;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRenderer;
import org.apache.myfaces.tobago.util.LayoutInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUISheetLayout
extends AbstractUILayoutBase
implements LayoutManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUISheetLayout.class);
    private boolean horizontalAuto;
    private boolean verticalAuto;

    @Override
    public void init() {
        this.layoutHeader();
        for (LayoutComponent component : this.getLayoutContainer().getComponents()) {
            if (!(component instanceof LayoutContainer) || !component.isRendered()) continue;
            ((LayoutContainer)((Object)component)).getLayoutManager().init();
        }
    }

    @Override
    public void fixRelativeInsideAuto(Orientation orientation, boolean auto) {
        if (orientation == Orientation.HORIZONTAL) {
            this.horizontalAuto = auto;
        } else {
            this.verticalAuto = auto;
        }
        for (LayoutComponent component : this.getLayoutContainer().getComponents()) {
            if (!(component instanceof LayoutContainer) || !component.isRendered()) continue;
            ((LayoutContainer)((Object)component)).getLayoutManager().fixRelativeInsideAuto(orientation, auto);
        }
    }

    @Override
    public void preProcessing(Orientation orientation) {
        IntervalList intervals = new IntervalList();
        for (LayoutComponent component : this.getLayoutContainer().getComponents()) {
            if (component == null || !(component instanceof LayoutContainer) || !component.isRendered()) continue;
            ((LayoutContainer)((Object)component)).getLayoutManager().preProcessing(orientation);
        }
    }

    @Override
    public void mainProcessing(Orientation orientation) {
        if (orientation == Orientation.HORIZONTAL && !this.horizontalAuto || orientation == Orientation.VERTICAL && !this.verticalAuto) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            LayoutContainer container = this.getLayoutContainer();
            AbstractUISheet sheet = (AbstractUISheet)container;
            if (orientation == Orientation.HORIZONTAL) {
                this.ensureColumnWidthList(facesContext, sheet);
                List<Integer> widthList = sheet.getWidthList();
                int index = 0;
                for (LayoutComponent component : sheet.getComponents()) {
                    if (component == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("todo: UIColumnSelector must be a LayoutComponent!");
                        }
                        ++index;
                        continue;
                    }
                    UIColumn column = component instanceof AbstractUIColumnNode ? (UIColumn)component : (UIColumn)((UIComponent)component).getParent();
                    if (!column.isRendered()) continue;
                    if (column instanceof LayoutBox) {
                        LayoutBox box = (LayoutBox)column;
                        Measure width = Measure.valueOf(widthList.get(index));
                        width = width.subtractNotNegative(LayoutUtils.getBorderBegin(orientation, box));
                        width = width.subtractNotNegative(LayoutUtils.getPaddingBegin(orientation, box));
                        width = width.subtractNotNegative(LayoutUtils.getPaddingEnd(orientation, box));
                        width = width.subtractNotNegative(LayoutUtils.getBorderEnd(orientation, box));
                        LayoutComponentRenderer renderer = sheet.getLayoutComponentRenderer(facesContext);
                        width = width.subtractNotNegative(renderer.getCustomMeasure(facesContext, sheet, "columnSeparator"));
                        LayoutUtils.setCurrentSize(orientation, component, width);
                        if (component instanceof LayoutContainer) {
                            ((LayoutContainer)((Object)component)).getLayoutManager().mainProcessing(orientation);
                        }
                    }
                    ++index;
                }
            }
        }
    }

    @Override
    public void postProcessing(Orientation orientation) {
        AbstractUISheet sheet = (AbstractUISheet)this.getLayoutContainer();
        for (LayoutComponent component : sheet.getComponents()) {
            if (component == null) continue;
            Measure position = LayoutUtils.getBorderBegin(orientation, sheet);
            if (orientation == Orientation.HORIZONTAL) {
                component.setLeft(position);
            } else {
                component.setTop(position);
            }
            if (!(component instanceof LayoutContainer) || !component.isRendered()) continue;
            ((LayoutContainer)((Object)component)).getLayoutManager().postProcessing(orientation);
        }
    }

    private LayoutContainer getLayoutContainer() {
        return (LayoutContainer)this.getParent();
    }

    public boolean getRendersChildren() {
        return false;
    }

    private void ensureColumnWidthList(FacesContext facesContext, AbstractUISheet data) {
        List<Integer> currentWidthList = null;
        List<AbstractUIColumn> renderedColumns = data.getRenderedColumns();
        Map attributes = data.getAttributes();
        String widthListString = null;
        SheetState state = data.getSheetState(facesContext);
        if (state != null) {
            widthListString = state.getColumnWidths();
        }
        if (widthListString == null) {
            widthListString = (String)attributes.get("widthListString");
        }
        if (widthListString != null) {
            try {
                currentWidthList = StringUtils.parseIntegerList(widthListString);
            }
            catch (NumberFormatException e) {
                LOG.warn("Unexpected value for column width list: '" + widthListString + "'");
            }
        }
        if (currentWidthList != null && currentWidthList.size() != renderedColumns.size() + 1) {
            currentWidthList = null;
        }
        Measure space = data.getCurrentWidth();
        LayoutComponentRenderer renderer = data.getLayoutComponentRenderer(facesContext);
        space = space.subtractNotNegative(renderer.getBorderLeft(facesContext, data));
        space = space.subtractNotNegative(renderer.getBorderRight(facesContext, data));
        Measure verticalScrollbarWeight = renderer.getVerticalScrollbarWeight(facesContext, data);
        boolean needVerticalScrollbar = this.needVerticalScrollbar(facesContext, data);
        if (needVerticalScrollbar) {
            space = space.subtractNotNegative(verticalScrollbarWeight);
        }
        if (currentWidthList == null) {
            LayoutTokens tokens = data.getColumnLayout();
            List<AbstractUIColumn> allColumns = data.getAllColumns();
            LayoutTokens newTokens = new LayoutTokens();
            for (int i = 0; i < allColumns.size(); ++i) {
                AbstractUIColumn column = allColumns.get(i);
                if (!column.isRendered()) continue;
                if (tokens == null) {
                    if (column instanceof AbstractUIColumn && column.getWidth() != null) {
                        newTokens.addToken(LayoutTokens.parseToken(column.getWidth().serialize()));
                        continue;
                    }
                    newTokens.addToken(RelativeLayoutToken.DEFAULT_INSTANCE);
                    continue;
                }
                if (i < tokens.getSize()) {
                    newTokens.addToken(tokens.get(i));
                    continue;
                }
                newTokens.addToken(RelativeLayoutToken.DEFAULT_INSTANCE);
            }
            LayoutInfo layoutInfo = new LayoutInfo(newTokens.getSize(), space.getPixel(), newTokens, data.getClientId(facesContext), false);
            Measure columnSelectorWidth = data.getLayoutComponentRenderer(facesContext).getCustomMeasure(facesContext, data, "columnSelectorWidth");
            this.parseFixedWidth(layoutInfo, renderedColumns, columnSelectorWidth);
            layoutInfo.parseColumnLayout(space.getPixel());
            currentWidthList = layoutInfo.getSpaceList();
            int freeWidth = space.getPixel();
            for (Integer width : currentWidthList) {
                freeWidth -= width.intValue();
            }
            if (needVerticalScrollbar) {
                if (freeWidth > 0) {
                    currentWidthList.add(freeWidth + verticalScrollbarWeight.getPixel());
                } else {
                    currentWidthList.add(verticalScrollbarWeight.getPixel());
                }
            } else {
                currentWidthList.add(Math.max(freeWidth, 0));
            }
        }
        if (renderedColumns.size() + 1 != currentWidthList.size()) {
            LOG.warn("widthList.size() = " + currentWidthList.size() + " != columns.size() = " + renderedColumns.size() + " + 1. The widthList: " + LayoutInfo.listToTokenString(currentWidthList));
        } else {
            data.setWidthList(currentWidthList);
        }
    }

    public boolean needVerticalScrollbar(FacesContext facesContext, AbstractUISheet sheet) {
        if (sheet.getNeedVerticalScrollbar() != null) {
            return sheet.getNeedVerticalScrollbar();
        }
        Boolean result = null;
        Object forceScrollbar = sheet.getAttributes().get("forceVerticalScrollbar");
        if (forceScrollbar != null) {
            if ("true".equals(forceScrollbar)) {
                result = true;
            } else if ("false".equals(forceScrollbar)) {
                result = false;
            } else if (!"auto".equals(forceScrollbar)) {
                LOG.warn("Illegal value for attribute 'forceVerticalScrollbar': '" + forceScrollbar + "'");
            }
        }
        if (result == null && !sheet.hasRowCount()) {
            result = true;
        }
        if (result == null) {
            if (sheet.getCurrentHeight() != null) {
                int first = sheet.getFirst();
                int rows = sheet.isRowsUnlimited() ? sheet.getRowCount() : Math.min(sheet.getRowCount(), first + sheet.getRows()) - first;
                Measure heightNeeded = this.getRowHeight(facesContext, sheet).multiply(rows);
                if (sheet.isShowHeader()) {
                    heightNeeded = heightNeeded.add(this.getHeaderHeight(facesContext, sheet));
                }
                if (sheet.isPagingVisible()) {
                    heightNeeded = heightNeeded.add(this.getFooterHeight(facesContext, sheet));
                }
                result = heightNeeded.greaterThan(sheet.getCurrentHeight());
            } else {
                result = false;
            }
        }
        sheet.setNeedVerticalScrollbar(result);
        return result;
    }

    private void parseFixedWidth(LayoutInfo layoutInfo, List<AbstractUIColumn> renderedColumns, Measure columnSelectorWidth) {
        LayoutTokens tokens = layoutInfo.getLayoutTokens();
        for (int i = 0; i < tokens.getSize(); ++i) {
            LayoutToken token = tokens.get(i);
            if (!(token instanceof AutoLayoutToken)) continue;
            int width = 0;
            if (!renderedColumns.isEmpty()) {
                if (i < renderedColumns.size()) {
                    AbstractUIColumn column = renderedColumns.get(i);
                    if (column instanceof AbstractUIColumnSelector) {
                        width = columnSelectorWidth.getPixel();
                    } else {
                        for (UIComponent component : column.getChildren()) {
                            width += 100;
                            LOG.error("100; // FIXME: make dynamic (was removed by changing the layout");
                        }
                    }
                    layoutInfo.update(width, i);
                } else {
                    layoutInfo.update(0, i);
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("More LayoutTokens found than rows! skipping!");
                    }
                }
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("set column " + i + " from 'auto' to width " + width);
        }
    }

    private Measure getHeaderHeight(FacesContext facesContext, AbstractUISheet sheet) {
        return sheet.isShowHeader() ? sheet.getLayoutComponentRenderer(facesContext).getCustomMeasure(facesContext, sheet, "headerHeight") : Measure.ZERO;
    }

    private Measure getRowHeight(FacesContext facesContext, AbstractUISheet sheet) {
        return sheet.getLayoutComponentRenderer(facesContext).getCustomMeasure(facesContext, sheet, "rowHeight");
    }

    private Measure getFooterHeight(FacesContext facesContext, AbstractUISheet sheet) {
        return sheet.isPagingVisible() ? sheet.getLayoutComponentRenderer(facesContext).getCustomMeasure(facesContext, sheet, "footerHeight") : Measure.ZERO;
    }

    private void layoutHeader() {
        AbstractUISheet sheet = (AbstractUISheet)this.getLayoutContainer();
        UIComponent header = sheet.getHeader();
        if (header == null) {
            LOG.warn("This should not happen. Please file a bug in the issue tracker to reproduce this case.");
            return;
        }
        LayoutTokens columns = new LayoutTokens();
        List<AbstractUIColumn> renderedColumns = sheet.getRenderedColumns();
        for (AbstractUIColumn ignored : renderedColumns) {
            columns.addToken(RelativeLayoutToken.DEFAULT_INSTANCE);
        }
        LayoutTokens rows = new LayoutTokens();
        rows.addToken(AutoLayoutToken.INSTANCE);
        Grid grid = new Grid(columns, rows);
        for (UIComponent child : header.getChildren()) {
            if (child instanceof LayoutComponent) {
                if (!child.isRendered()) continue;
                LayoutComponent c = (LayoutComponent)child;
                grid.add(new OriginCell(c), c.getColumnSpan(), c.getRowSpan());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Found unknown component in header.");
        }
        sheet.setHeaderGrid(grid);
    }
}

