/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.PhaseId;
import javax.faces.event.PreRenderComponentEvent;
import org.apache.myfaces.tobago.component.ColumnEvent;
import org.apache.myfaces.tobago.component.OnComponentPopulated;
import org.apache.myfaces.tobago.component.Sorter;
import org.apache.myfaces.tobago.component.SupportsRenderedPartially;
import org.apache.myfaces.tobago.event.PageActionEvent;
import org.apache.myfaces.tobago.event.SheetStateChangeEvent;
import org.apache.myfaces.tobago.event.SheetStateChangeListener;
import org.apache.myfaces.tobago.event.SheetStateChangeSource2;
import org.apache.myfaces.tobago.event.SortActionEvent;
import org.apache.myfaces.tobago.event.SortActionSource2;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumn;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnNode;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnSelector;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUIGridLayout;
import org.apache.myfaces.tobago.internal.component.AbstractUILayoutBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIOut;
import org.apache.myfaces.tobago.internal.layout.Grid;
import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.LayoutManager;
import org.apache.myfaces.tobago.layout.LayoutTokens;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.SelectedState;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRenderer;
import org.apache.myfaces.tobago.util.CreateComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ListenerFor(systemEventClass=PreRenderComponentEvent.class)
public abstract class AbstractUISheet
extends AbstractUIData
implements SheetStateChangeSource2,
SortActionSource2,
OnComponentPopulated,
LayoutContainer,
LayoutComponent,
SupportsRenderedPartially {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUISheet.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Data";
    @Deprecated
    public static final String FACET_SORTER = "sorter";
    public static final String SORTER_ID = "sorter";
    @Deprecated
    public static final String ATTR_SCROLL_POSITION = "attrScrollPosition";
    public static final String NONE = "none";
    public static final String SINGLE = "single";
    public static final String MULTI = "multi";
    private SheetState state;
    private List<Integer> widthList;
    private transient LayoutTokens columnLayout;
    private transient List<LayoutComponent> layoutComponents;
    private transient Boolean needVerticalScrollbar;
    private transient Grid headerGrid;

    public LayoutComponentRenderer getLayoutComponentRenderer(FacesContext context) {
        return (LayoutComponentRenderer)this.getRenderer(context);
    }

    @Override
    public void encodeBegin(FacesContext facesContext) throws IOException {
        SheetState state = this.getSheetState(facesContext);
        int first = state.getFirst();
        if (!(first <= -1 || this.hasRowCount() && first >= this.getRowCount())) {
            ValueExpression expression = this.getValueExpression("first");
            if (expression != null) {
                expression.setValue(facesContext.getELContext(), (Object)first);
            } else {
                this.setFirst(first);
            }
        }
        super.encodeBegin(facesContext);
    }

    public void setState(SheetState state) {
        this.state = state;
    }

    public SheetState getState() {
        return this.getSheetState(FacesContext.getCurrentInstance());
    }

    public SheetState getSheetState(FacesContext facesContext) {
        if (this.state != null) {
            return this.state;
        }
        ValueExpression expression = this.getValueExpression("state");
        if (expression != null) {
            ELContext elContext = facesContext.getELContext();
            SheetState sheetState = (SheetState)expression.getValue(elContext);
            if (sheetState == null) {
                sheetState = new SheetState();
                expression.setValue(elContext, (Object)sheetState);
            }
            return sheetState;
        }
        this.state = new SheetState();
        return this.state;
    }

    public abstract String getColumns();

    public LayoutTokens getColumnLayout() {
        String columns;
        if (this.columnLayout == null && (columns = this.getColumns()) != null) {
            this.columnLayout = LayoutTokens.parse(columns);
        }
        return this.columnLayout;
    }

    public void resetColumnWidths() {
        SheetState state = this.getState();
        if (state != null) {
            state.setColumnWidths(null);
        }
        this.getAttributes().remove("widthListString");
    }

    public int getLast() {
        int last = this.getFirst() + this.getRows();
        return last < this.getRowCount() ? last : this.getRowCount();
    }

    public int getLastRowIndexOfCurrentPage() {
        if (!this.hasRowCount()) {
            throw new IllegalArgumentException("Can't determine the last row, because the row count of the model is unknown.");
        }
        if (this.isRowsUnlimited()) {
            return this.getRowCount();
        }
        int last = this.getFirst() + this.getRows();
        return last < this.getRowCount() ? last : this.getRowCount();
    }

    public int getCurrentPage() {
        int rows = this.getRows();
        if (rows == 0) {
            return 0;
        }
        int first = this.getFirst();
        if (this.hasRowCount() && first >= this.getRowCount()) {
            return this.getPages() - 1;
        }
        return first / rows;
    }

    @Deprecated
    public int getPage() {
        return this.getCurrentPage() + 1;
    }

    public int getPages() {
        if (this.isRowsUnlimited()) {
            return 1;
        }
        if (!this.hasRowCount()) {
            throw new IllegalArgumentException("Can't determine the number of pages, because the row count of the model is unknown.");
        }
        return (this.getRowCount() - 1) / this.getRows() + 1;
    }

    public List<UIComponent> getRenderedChildrenOf(UIColumn column) {
        ArrayList<UIComponent> children = new ArrayList<UIComponent>();
        for (UIComponent kid : column.getChildren()) {
            if (!kid.isRendered()) continue;
            children.add(kid);
        }
        return children;
    }

    public boolean isAtBeginning() {
        return this.getFirst() == 0;
    }

    public boolean hasRowCount() {
        return this.getRowCount() != -1;
    }

    public boolean isPagingVisible() {
        return this.isShowPagingAlways() || this.needMoreThanOnePage();
    }

    public boolean needMoreThanOnePage() {
        if (this.isRowsUnlimited()) {
            return false;
        }
        if (!this.hasRowCount()) {
            return true;
        }
        return this.getRowCount() > this.getRows();
    }

    public abstract boolean isShowPagingAlways();

    public boolean isAtEnd() {
        if (!this.hasRowCount()) {
            int old = this.getRowIndex();
            this.setRowIndex(this.getFirst() + this.getRows() + 1);
            boolean atEnd = !this.isRowAvailable();
            this.setRowIndex(old);
            return atEnd;
        }
        return this.getFirst() >= this.getFirstRowIndexOfLastPage();
    }

    @Deprecated
    public int getLastPageIndex() {
        if (this.hasRowCount()) {
            return this.getFirstRowIndexOfLastPage();
        }
        return 0;
    }

    public int getFirstRowIndexOfLastPage() {
        int rowCount;
        if (this.isRowsUnlimited()) {
            return 0;
        }
        if (!this.hasRowCount()) {
            throw new IllegalArgumentException("Can't determine the last page, because the row count of the model is unknown.");
        }
        int rows = this.getRows();
        int tail = (rowCount = this.getRowCount()) % rows;
        return rowCount - (tail != 0 ? tail : rows);
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        this.updateSheetState(context);
    }

    private void updateSheetState(FacesContext facesContext) {
        SheetState state = this.getSheetState(facesContext);
        if (state != null) {
            Map attributes = this.getAttributes();
            List<Integer> list = (List<Integer>)attributes.get("selectedListString");
            state.setSelectedRows(list != null ? list : Collections.emptyList());
            state.setColumnWidths((String)attributes.get("widthListString"));
            state.setScrollPosition((Integer[])attributes.get(ATTR_SCROLL_POSITION));
            attributes.remove("selectedListString");
            attributes.remove(ATTR_SCROLL_POSITION);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] saveState = new Object[]{super.saveState(context), this.state};
        return saveState;
    }

    public void restoreState(FacesContext context, Object savedState) {
        Object[] values = (Object[])savedState;
        super.restoreState(context, values[0]);
        this.state = (SheetState)values[1];
    }

    public List<AbstractUIColumn> getAllColumns() {
        ArrayList<AbstractUIColumn> result = new ArrayList<AbstractUIColumn>();
        this.findColumns((UIComponent)this, result, true);
        return result;
    }

    public List<AbstractUIColumn> getRenderedColumns() {
        ArrayList<AbstractUIColumn> result = new ArrayList<AbstractUIColumn>();
        this.findColumns((UIComponent)this, result, false);
        return result;
    }

    private void findColumns(UIComponent component, List<AbstractUIColumn> result, boolean all) {
        for (UIComponent child : component.getChildren()) {
            if (!all && !child.isRendered()) continue;
            if (child instanceof AbstractUIColumn) {
                result.add((AbstractUIColumn)child);
                continue;
            }
            if (child instanceof AbstractUIData) continue;
            this.findColumns(child, result, all);
        }
    }

    public void queueEvent(FacesEvent facesEvent) {
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("Component is not a descendant of a UIViewRoot");
        }
        if (facesEvent.getComponent() == this && (facesEvent instanceof SheetStateChangeEvent || facesEvent instanceof PageActionEvent)) {
            facesEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            parent.queueEvent(facesEvent);
        } else {
            UIComponent source = facesEvent.getComponent();
            UIComponent sourceParent = source.getParent();
            if (sourceParent.getParent() == this && source.getId() != null && source.getId().endsWith("sorter")) {
                facesEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
                parent.queueEvent((FacesEvent)new SortActionEvent(this, (UIColumn)sourceParent));
            } else {
                super.queueEvent(facesEvent);
            }
        }
    }

    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        super.broadcast(facesEvent);
        if (facesEvent instanceof SheetStateChangeEvent) {
            MethodExpression listener = this.getStateChangeListenerExpression();
            listener.invoke(this.getFacesContext().getELContext(), new Object[]{facesEvent});
        } else if (facesEvent instanceof PageActionEvent) {
            if (facesEvent.getComponent() == this) {
                MethodExpression listener = this.getStateChangeListenerExpression();
                if (listener != null) {
                    listener.invoke(this.getFacesContext().getELContext(), new Object[]{facesEvent});
                }
                this.performPaging((PageActionEvent)facesEvent);
            }
        } else if (facesEvent instanceof SortActionEvent) {
            this.getSheetState(this.getFacesContext()).updateSortState((SortActionEvent)facesEvent);
            this.sort(this.getFacesContext(), (SortActionEvent)facesEvent);
        }
    }

    public void processEvent(ComponentSystemEvent event) {
        super.processEvent(event);
        if (event instanceof PreRenderComponentEvent) {
            this.sort(this.getFacesContext(), null);
        }
    }

    protected void sort(FacesContext facesContext, SortActionEvent event) {
        SheetState sheetState = this.getSheetState(this.getFacesContext());
        if (sheetState.isToBeSorted()) {
            MethodExpression expression = this.getSortActionListenerExpression();
            if (expression != null) {
                try {
                    if (event == null) {
                        event = new SortActionEvent(this, (UIColumn)this.findComponent(this.getSheetState(facesContext).getSortedColumnId()));
                    }
                    expression.invoke(facesContext.getELContext(), new Object[]{event});
                }
                catch (Exception e) {
                    LOG.warn("Sorting not possible!", (Throwable)e);
                }
            } else {
                new Sorter().perform(this);
            }
            sheetState.setToBeSorted(false);
        }
    }

    @Override
    public void addStateChangeListener(SheetStateChangeListener listener) {
        this.addFacesListener(listener);
    }

    @Override
    public SheetStateChangeListener[] getStateChangeListeners() {
        return (SheetStateChangeListener[])this.getFacesListeners(SheetStateChangeListener.class);
    }

    @Override
    public void removeStateChangeListener(SheetStateChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public List<Integer> getWidthList() {
        return this.widthList;
    }

    public void setWidthList(List<Integer> widthList) {
        this.widthList = widthList;
    }

    public Integer[] getScrollPosition() {
        Integer[] scrollPosition = (Integer[])this.getAttributes().get(ATTR_SCROLL_POSITION);
        if (scrollPosition == null) {
            scrollPosition = this.getSheetState(FacesContext.getCurrentInstance()).getScrollPosition();
        }
        return scrollPosition;
    }

    public UIComponent findComponent(String searchId) {
        return super.findComponent(this.stripRowIndex(searchId));
    }

    public String stripRowIndex(String searchId) {
        if (searchId.length() > 0 && Character.isDigit(searchId.charAt(0))) {
            for (int i = 1; i < searchId.length(); ++i) {
                char c = searchId.charAt(i);
                if (c == UINamingContainer.getSeparatorChar((FacesContext)this.getFacesContext())) {
                    searchId = searchId.substring(i + 1);
                    break;
                }
                if (!Character.isDigit(c)) break;
            }
        }
        return searchId;
    }

    public void performPaging(PageActionEvent pageEvent) {
        int first;
        if (LOG.isDebugEnabled()) {
            LOG.debug("action = '" + pageEvent.getAction().name() + "'");
        }
        switch (pageEvent.getAction()) {
            case FIRST: {
                first = 0;
                break;
            }
            case PREV: {
                first = this.getFirst() - this.getRows();
                first = first < 0 ? 0 : first;
                break;
            }
            case NEXT: {
                if (this.hasRowCount()) {
                    first = this.getFirst() + this.getRows();
                    first = first > this.getRowCount() ? this.getFirstRowIndexOfLastPage() : first;
                    break;
                }
                if (this.isAtEnd()) {
                    first = this.getFirst();
                    break;
                }
                first = this.getFirst() + this.getRows();
                break;
            }
            case LAST: {
                first = this.getFirstRowIndexOfLastPage();
                break;
            }
            case TO_ROW: {
                first = pageEvent.getValue() - 1;
                if (this.hasRowCount() && first > this.getFirstRowIndexOfLastPage()) {
                    first = this.getFirstRowIndexOfLastPage();
                    break;
                }
                if (first >= 0) break;
                first = 0;
                break;
            }
            case TO_PAGE: {
                int pageIndex = pageEvent.getValue() - 1;
                first = pageIndex * this.getRows();
                if (this.hasRowCount() && first > this.getFirstRowIndexOfLastPage()) {
                    first = this.getFirstRowIndexOfLastPage();
                    break;
                }
                if (first >= 0) break;
                first = 0;
                break;
            }
            default: {
                first = -1;
            }
        }
        ValueExpression expression = this.getValueExpression("first");
        if (expression != null) {
            expression.setValue(this.getFacesContext().getELContext(), (Object)first);
        } else {
            this.setFirst(first);
        }
        this.getState().setFirst(first);
    }

    @Override
    public List<LayoutComponent> getComponents() {
        if (this.layoutComponents != null) {
            return this.layoutComponents;
        }
        this.layoutComponents = new ArrayList<LayoutComponent>();
        for (UIComponent column : this.getChildren()) {
            if (column instanceof AbstractUIColumnSelector) {
                this.layoutComponents.add(null);
                continue;
            }
            if (column instanceof ColumnEvent) continue;
            if (column instanceof AbstractUIColumnNode) {
                this.layoutComponents.add((AbstractUIColumnNode)column);
                continue;
            }
            if (!(column instanceof UIColumn)) continue;
            LayoutComponent layoutComponent = null;
            for (UIComponent component : column.getChildren()) {
                if (!(component instanceof LayoutComponent)) continue;
                if (layoutComponent == null) {
                    layoutComponent = (LayoutComponent)component;
                    continue;
                }
                LOG.warn("Found more than one layout components inside of a UIColumn: column id='{}' renderer-type='{}'", (Object)column.getClientId(FacesContext.getCurrentInstance()), (Object)component.getRendererType());
            }
            if (layoutComponent != null) {
                this.layoutComponents.add(layoutComponent);
                continue;
            }
            FacesContext facesContext = FacesContext.getCurrentInstance();
            AbstractUIOut dummy = (AbstractUIOut)CreateComponentUtils.createComponent(facesContext, "org.apache.myfaces.tobago.Out", "Out", facesContext.getViewRoot().createUniqueId());
            dummy.setTransient(true);
            column.getChildren().add(dummy);
            this.layoutComponents.add(dummy);
            LOG.warn("Found no component inside of a UIColumn: column id='{}'. Creating a dummy with id='{}'!", (Object)column.getClientId(facesContext), (Object)dummy.getClientId(facesContext));
        }
        return this.layoutComponents;
    }

    @Override
    public void onComponentPopulated(FacesContext facesContext, UIComponent parent) {
        if (this.getLayoutManager() instanceof AbstractUIGridLayout) {
            LOG.warn("Found a GridLayout as layout facet in sheet. Will be ignored! Please remove it. The id of the sheet is: '" + this.getClientId(facesContext) + "'");
            this.getFacets().remove("layout");
        }
        if (this.getLayoutManager() == null) {
            this.setLayoutManager(CreateComponentUtils.createAndInitLayout(facesContext, "org.apache.myfaces.tobago.SheetLayout", "SheetLayout", parent));
        }
    }

    @Override
    public LayoutManager getLayoutManager() {
        return (LayoutManager)this.getFacet("layout");
    }

    @Override
    public void setLayoutManager(LayoutManager layoutManager) {
        this.getFacets().put("layout", (AbstractUILayoutBase)((Object)layoutManager));
    }

    @Override
    public boolean isLayoutChildren() {
        return this.isRendered();
    }

    @Override
    public boolean isRendersRowContainer() {
        return true;
    }

    public abstract boolean isShowHeader();

    public Boolean getNeedVerticalScrollbar() {
        return this.needVerticalScrollbar;
    }

    public void setNeedVerticalScrollbar(Boolean needVerticalScrollbar) {
        this.needVerticalScrollbar = needVerticalScrollbar;
    }

    @Override
    public ExpandedState getExpandedState() {
        return this.getState().getExpandedState();
    }

    @Override
    public SelectedState getSelectedState() {
        return this.getState().getSelectedState();
    }

    public Grid getHeaderGrid() {
        return this.headerGrid;
    }

    public void setHeaderGrid(Grid headerGrid) {
        this.headerGrid = headerGrid;
    }
}

