/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.ajax;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.myfaces.tobago.internal.ajax.AjaxNavigationState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxNavigationListener
implements PhaseListener {
    private static final Logger LOG = LoggerFactory.getLogger(AjaxNavigationListener.class);

    public void afterPhase(PhaseEvent phaseEvent) {
        FacesContext facesContext = phaseEvent.getFacesContext();
        this.debug(facesContext);
        if (!facesContext.getResponseComplete()) {
            if (phaseEvent.getPhaseId() == PhaseId.RESTORE_VIEW) {
                AjaxNavigationState.afterRestoreView(facesContext);
            } else if (phaseEvent.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
                AjaxNavigationState.afterInvokeApplication(facesContext);
            }
        }
        this.debug(facesContext);
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        FacesContext facesContext = phaseEvent.getFacesContext();
        this.debug(facesContext);
        if (!facesContext.getResponseComplete() && phaseEvent.getPhaseId() == PhaseId.RESTORE_VIEW) {
            AjaxNavigationState.beforeRestoreView(facesContext);
        }
        this.debug(facesContext);
    }

    private void debug(FacesContext facesContext) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("### debug getRenderResponse = {}", (Object)facesContext.getRenderResponse());
            if (facesContext.getViewRoot() != null) {
                LOG.trace("### debug getViewId = {}", (Object)facesContext.getViewRoot().getViewId());
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

