// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UITreeMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.TreeMenuTagDeclaration}.
 */
public final class TreeMenuTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(TreeMenuTag.class);
  private javax.el.ValueExpression  markup;
  private javax.el.ValueExpression  state;
  private javax.el.ValueExpression  showRoot;

  @Override
  public String getComponentType() {
    return UITreeMenu.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "TreeMenu";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UITreeMenu component = (UITreeMenu) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (state != null) {
      if (!state.isLiteralText()) {
        component.setValueExpression("state", state);
      /*} else {
        component.setState(state.getExpressionString());*/
      }
    }
    if (showRoot != null) {
      if (!showRoot.isLiteralText()) {
        component.setValueExpression("showRoot", showRoot);
      } else {
        component.setShowRoot(Boolean.parseBoolean(showRoot.getExpressionString()));
      }
    }
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.ValueExpression getState() {
    return state;
  }

  public void setState(final javax.el.ValueExpression state) {
    this.state = state;
  }

  public javax.el.ValueExpression getShowRoot() {
    return showRoot;
  }

  public void setShowRoot(final javax.el.ValueExpression showRoot) {
    this.showRoot = showRoot;
  }



  @Override
  public void release() {
    super.release();
    markup = null;
    state = null;
    showRoot = null;
  }
}