// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UITabGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.TabGroupTagDeclaration}.
 */
public final class TabGroupTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(TabGroupTag.class);
  private javax.el.MethodExpression  actionListener;
  private javax.el.ValueExpression  markup;
  private javax.el.MethodExpression  action;
  private javax.el.ValueExpression  showNavigationBar;
  private javax.el.MethodExpression  tabChangeListener;
  private javax.el.ValueExpression  selectedIndex;
  private javax.el.ValueExpression  switchType;
  private javax.el.ValueExpression  immediate;
  private javax.el.ValueExpression  renderedPartially;

  @Override
  public String getComponentType() {
    return UITabGroup.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "TabGroup";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UITabGroup component = (UITabGroup) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (actionListener != null) {
      component.addActionListener(new javax.faces.event.MethodExpressionActionListener(actionListener));
    }
    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (action != null) {
      component.setActionExpression(action);
    }
    if (showNavigationBar != null) {
      if (!showNavigationBar.isLiteralText()) {
        component.setValueExpression("showNavigationBar", showNavigationBar);
      } else {
        component.setShowNavigationBar(Boolean.parseBoolean(showNavigationBar.getExpressionString()));
      }
    }
    if (tabChangeListener != null) {
      component.addTabChangeListener(new org.apache.myfaces.tobago.event.MethodExpressionTabChangeListener(tabChangeListener));
    }
    if (selectedIndex != null) {
      if (!selectedIndex.isLiteralText()) {
        component.setValueExpression("selectedIndex", selectedIndex);
      } else {
        component.setSelectedIndex(Integer.parseInt(selectedIndex.getExpressionString()));
      }
    }
    if (switchType != null) {
      component.setValueExpression("switchType", switchType);
    }

    if (immediate != null) {
      if (!immediate.isLiteralText()) {
        component.setValueExpression("immediate", immediate);
      } else {
        component.setImmediate(Boolean.parseBoolean(immediate.getExpressionString()));
      }
    }
    if (renderedPartially != null) {
      if (!renderedPartially.isLiteralText()) {
        component.setValueExpression("renderedPartially", renderedPartially);
      } else {
        component.setRenderedPartially(splitList(renderedPartially.getExpressionString()));
      }
    }
  }

  public javax.el.MethodExpression getActionListener() {
    return actionListener;
  }

  public void setActionListener(final javax.el.MethodExpression actionListener) {
    this.actionListener = actionListener;
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.MethodExpression getAction() {
    return action;
  }

  public void setAction(final javax.el.MethodExpression action) {
    this.action = action;
  }

  public javax.el.ValueExpression getShowNavigationBar() {
    return showNavigationBar;
  }

  public void setShowNavigationBar(final javax.el.ValueExpression showNavigationBar) {
    this.showNavigationBar = showNavigationBar;
  }

  public javax.el.MethodExpression getTabChangeListener() {
    return tabChangeListener;
  }

  public void setTabChangeListener(final javax.el.MethodExpression tabChangeListener) {
    this.tabChangeListener = tabChangeListener;
  }

  public javax.el.ValueExpression getSelectedIndex() {
    return selectedIndex;
  }

  public void setSelectedIndex(final javax.el.ValueExpression selectedIndex) {
    this.selectedIndex = selectedIndex;
  }

  public javax.el.ValueExpression getSwitchType() {
    return switchType;
  }

  public void setSwitchType(final javax.el.ValueExpression switchType) {
    this.switchType = switchType;
  }

  public javax.el.ValueExpression getImmediate() {
    return immediate;
  }

  public void setImmediate(final javax.el.ValueExpression immediate) {
    this.immediate = immediate;
  }

  public javax.el.ValueExpression getRenderedPartially() {
    return renderedPartially;
  }

  public void setRenderedPartially(final javax.el.ValueExpression renderedPartially) {
    this.renderedPartially = renderedPartially;
  }



  @Override
  public void release() {
    super.release();
    actionListener = null;
    markup = null;
    action = null;
    showNavigationBar = null;
    tabChangeListener = null;
    selectedIndex = null;
    switchType = null;
    immediate = null;
    renderedPartially = null;
  }
}