// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UISheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.SheetTagDeclaration}.
 */
public final class SheetTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(SheetTag.class);
  private javax.el.ValueExpression  markup;
  private javax.el.ValueExpression  columns;
  private javax.el.ValueExpression  showDirectLinks;
  private javax.el.ValueExpression  showPageRange;
  private javax.el.ValueExpression  value;
  private javax.el.ValueExpression  forceVerticalScrollbar;
  private javax.el.MethodExpression  stateChangeListener;
  private javax.el.ValueExpression  rows;
  private javax.el.ValueExpression  showPagingAlways;
  private javax.el.ValueExpression  renderedPartially;
  private String var;
  private javax.el.ValueExpression  state;
  private javax.el.ValueExpression  showRowRange;
  private javax.el.ValueExpression  selectable;
  private javax.el.ValueExpression  showHeader;
  private javax.el.ValueExpression  directLinkCount;
  private javax.el.MethodExpression  sortActionListener;
  private javax.el.ValueExpression  first;

  @Override
  public String getComponentType() {
    return UISheet.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "Sheet";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UISheet component = (UISheet) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (columns != null) {
      component.setValueExpression("columns", columns);
    }

    if (showDirectLinks != null) {
      component.setValueExpression("showDirectLinks", showDirectLinks);
    }

    if (showPageRange != null) {
      component.setValueExpression("showPageRange", showPageRange);
    }

    if (value != null) {
      if (!value.isLiteralText()) {
        component.setValueExpression("value", value);
      /*} else {
        component.setValue(value.getExpressionString());*/
      }
    }
    if (forceVerticalScrollbar != null) {
      component.setValueExpression("forceVerticalScrollbar", forceVerticalScrollbar);
    }

    if (stateChangeListener != null) {
      component.addStateChangeListener(new org.apache.myfaces.tobago.event.MethodExpressionStateChangeListener(stateChangeListener));
    }
    if (rows != null) {
      if (!rows.isLiteralText()) {
        component.setValueExpression("rows", rows);
      } else {
        component.setRows(Integer.parseInt(rows.getExpressionString()));
      }
    }
    if (showPagingAlways != null) {
      if (!showPagingAlways.isLiteralText()) {
        component.setValueExpression("showPagingAlways", showPagingAlways);
      } else {
        component.setShowPagingAlways(Boolean.parseBoolean(showPagingAlways.getExpressionString()));
      }
    }
    if (renderedPartially != null) {
      if (!renderedPartially.isLiteralText()) {
        component.setValueExpression("renderedPartially", renderedPartially);
      } else {
        component.setRenderedPartially(splitList(renderedPartially.getExpressionString()));
      }
    }
    if (var != null) {
      component.setVar(var);
    }

    if (state != null) {
      if (!state.isLiteralText()) {
        component.setValueExpression("state", state);
      /*} else {
        component.setState(state.getExpressionString());*/
      }
    }
    if (showRowRange != null) {
      component.setValueExpression("showRowRange", showRowRange);
    }

    if (selectable != null) {
      component.setValueExpression("selectable", selectable);
    }

    if (showHeader != null) {
      if (!showHeader.isLiteralText()) {
        component.setValueExpression("showHeader", showHeader);
      } else {
        component.setShowHeader(Boolean.parseBoolean(showHeader.getExpressionString()));
      }
    }
    if (directLinkCount != null) {
      if (!directLinkCount.isLiteralText()) {
        component.setValueExpression("directLinkCount", directLinkCount);
      } else {
        component.setDirectLinkCount(Integer.parseInt(directLinkCount.getExpressionString()));
      }
    }
    if (sortActionListener != null) {
      component.setSortActionListenerExpression(sortActionListener);
    }
    if (first != null) {
      if (!first.isLiteralText()) {
        component.setValueExpression("first", first);
      } else {
        component.setFirst(Integer.parseInt(first.getExpressionString()));
      }
    }
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.ValueExpression getColumns() {
    return columns;
  }

  public void setColumns(final javax.el.ValueExpression columns) {
    this.columns = columns;
  }

  public javax.el.ValueExpression getShowDirectLinks() {
    return showDirectLinks;
  }

  public void setShowDirectLinks(final javax.el.ValueExpression showDirectLinks) {
    this.showDirectLinks = showDirectLinks;
  }

  public javax.el.ValueExpression getShowPageRange() {
    return showPageRange;
  }

  public void setShowPageRange(final javax.el.ValueExpression showPageRange) {
    this.showPageRange = showPageRange;
  }

  public javax.el.ValueExpression getValue() {
    return value;
  }

  public void setValue(final javax.el.ValueExpression value) {
    this.value = value;
  }

  public javax.el.ValueExpression getForceVerticalScrollbar() {
    return forceVerticalScrollbar;
  }

  public void setForceVerticalScrollbar(final javax.el.ValueExpression forceVerticalScrollbar) {
    this.forceVerticalScrollbar = forceVerticalScrollbar;
  }

  public javax.el.MethodExpression getStateChangeListener() {
    return stateChangeListener;
  }

  public void setStateChangeListener(final javax.el.MethodExpression stateChangeListener) {
    this.stateChangeListener = stateChangeListener;
  }

  public javax.el.ValueExpression getRows() {
    return rows;
  }

  public void setRows(final javax.el.ValueExpression rows) {
    this.rows = rows;
  }

  public javax.el.ValueExpression getShowPagingAlways() {
    return showPagingAlways;
  }

  public void setShowPagingAlways(final javax.el.ValueExpression showPagingAlways) {
    this.showPagingAlways = showPagingAlways;
  }

  public javax.el.ValueExpression getRenderedPartially() {
    return renderedPartially;
  }

  public void setRenderedPartially(final javax.el.ValueExpression renderedPartially) {
    this.renderedPartially = renderedPartially;
  }

  public String getVar() {
    return var;
  }

  public void setVar(final String var) {
    this.var = var;
  }

  public javax.el.ValueExpression getState() {
    return state;
  }

  public void setState(final javax.el.ValueExpression state) {
    this.state = state;
  }

  public javax.el.ValueExpression getShowRowRange() {
    return showRowRange;
  }

  public void setShowRowRange(final javax.el.ValueExpression showRowRange) {
    this.showRowRange = showRowRange;
  }

  public javax.el.ValueExpression getSelectable() {
    return selectable;
  }

  public void setSelectable(final javax.el.ValueExpression selectable) {
    this.selectable = selectable;
  }

  public javax.el.ValueExpression getShowHeader() {
    return showHeader;
  }

  public void setShowHeader(final javax.el.ValueExpression showHeader) {
    this.showHeader = showHeader;
  }

  public javax.el.ValueExpression getDirectLinkCount() {
    return directLinkCount;
  }

  public void setDirectLinkCount(final javax.el.ValueExpression directLinkCount) {
    this.directLinkCount = directLinkCount;
  }

  public javax.el.MethodExpression getSortActionListener() {
    return sortActionListener;
  }

  public void setSortActionListener(final javax.el.MethodExpression sortActionListener) {
    this.sortActionListener = sortActionListener;
  }

  public javax.el.ValueExpression getFirst() {
    return first;
  }

  public void setFirst(final javax.el.ValueExpression first) {
    this.first = first;
  }



  @Override
  public void release() {
    super.release();
    markup = null;
    columns = null;
    showDirectLinks = null;
    showPageRange = null;
    value = null;
    forceVerticalScrollbar = null;
    stateChangeListener = null;
    rows = null;
    showPagingAlways = null;
    renderedPartially = null;
    var = null;
    state = null;
    showRowRange = null;
    selectable = null;
    showHeader = null;
    directLinkCount = null;
    sortActionListener = null;
    first = null;
  }
}