// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UISelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.SelectItemTagDeclaration}.
 */
public final class SelectItemTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(SelectItemTag.class);
  private javax.el.ValueExpression  itemDescription;
  private javax.el.ValueExpression  markup;
  private javax.el.ValueExpression  itemValue;
  private javax.el.ValueExpression  itemLabel;
  private javax.el.ValueExpression  value;
  private javax.el.ValueExpression  itemImage;
  private javax.el.ValueExpression  itemDisabled;

  @Override
  public String getComponentType() {
    return UISelectItem.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return null;
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UISelectItem component = (UISelectItem) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (itemDescription != null) {
      component.setValueExpression("itemDescription", itemDescription);
    }

    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (itemValue != null) {
      component.setValueExpression("itemValue", itemValue);
    }

    if (itemLabel != null) {
      component.setValueExpression("itemLabel", itemLabel);
    }

    if (value != null) {
      if (!value.isLiteralText()) {
        component.setValueExpression("value", value);
      /*} else {
        component.setValue(value.getExpressionString());*/
      }
    }
    if (itemImage != null) {
      component.setValueExpression("itemImage", itemImage);
    }

    if (itemDisabled != null) {
      if (!itemDisabled.isLiteralText()) {
        component.setValueExpression("itemDisabled", itemDisabled);
      } else {
        component.setItemDisabled(Boolean.parseBoolean(itemDisabled.getExpressionString()));
      }
    }
  }

  public javax.el.ValueExpression getItemDescription() {
    return itemDescription;
  }

  public void setItemDescription(final javax.el.ValueExpression itemDescription) {
    this.itemDescription = itemDescription;
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.ValueExpression getItemValue() {
    return itemValue;
  }

  public void setItemValue(final javax.el.ValueExpression itemValue) {
    this.itemValue = itemValue;
  }

  public javax.el.ValueExpression getItemLabel() {
    return itemLabel;
  }

  public void setItemLabel(final javax.el.ValueExpression itemLabel) {
    this.itemLabel = itemLabel;
  }

  public javax.el.ValueExpression getValue() {
    return value;
  }

  public void setValue(final javax.el.ValueExpression value) {
    this.value = value;
  }

  public javax.el.ValueExpression getItemImage() {
    return itemImage;
  }

  public void setItemImage(final javax.el.ValueExpression itemImage) {
    this.itemImage = itemImage;
  }

  public javax.el.ValueExpression getItemDisabled() {
    return itemDisabled;
  }

  public void setItemDisabled(final javax.el.ValueExpression itemDisabled) {
    this.itemDisabled = itemDisabled;
  }



  @Override
  public void release() {
    super.release();
    itemDescription = null;
    markup = null;
    itemValue = null;
    itemLabel = null;
    value = null;
    itemImage = null;
    itemDisabled = null;
  }
}