// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UIPopup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.PopupTagDeclaration}.
 */
public final class PopupTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(PopupTag.class);
  private javax.el.ValueExpression  markup;
  private javax.el.ValueExpression  height;
  private javax.el.ValueExpression  left;
  private javax.el.ValueExpression  modal;
  private javax.el.ValueExpression  top;
  private javax.el.ValueExpression  width;

  @Override
  public String getComponentType() {
    return UIPopup.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "Popup";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UIPopup component = (UIPopup) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (height != null) {
      if (!height.isLiteralText()) {
        component.setValueExpression("height", height);
      } else {
        component.setHeight(org.apache.myfaces.tobago.layout.Measure.valueOf(height.getExpressionString()));
      }
    }
    if (left != null) {
      if (!left.isLiteralText()) {
        component.setValueExpression("left", left);
      } else {
        component.setLeft(org.apache.myfaces.tobago.layout.Measure.valueOf(left.getExpressionString()));
      }
    }
    if (modal != null) {
      if (!modal.isLiteralText()) {
        component.setValueExpression("modal", modal);
      } else {
        component.setModal(Boolean.parseBoolean(modal.getExpressionString()));
      }
    }
    if (top != null) {
      if (!top.isLiteralText()) {
        component.setValueExpression("top", top);
      } else {
        component.setTop(org.apache.myfaces.tobago.layout.Measure.valueOf(top.getExpressionString()));
      }
    }
    if (width != null) {
      if (!width.isLiteralText()) {
        component.setValueExpression("width", width);
      } else {
        component.setWidth(org.apache.myfaces.tobago.layout.Measure.valueOf(width.getExpressionString()));
      }
    }
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.ValueExpression getHeight() {
    return height;
  }

  public void setHeight(final javax.el.ValueExpression height) {
    this.height = height;
  }

  public javax.el.ValueExpression getLeft() {
    return left;
  }

  public void setLeft(final javax.el.ValueExpression left) {
    this.left = left;
  }

  public javax.el.ValueExpression getModal() {
    return modal;
  }

  public void setModal(final javax.el.ValueExpression modal) {
    this.modal = modal;
  }

  public javax.el.ValueExpression getTop() {
    return top;
  }

  public void setTop(final javax.el.ValueExpression top) {
    this.top = top;
  }

  public javax.el.ValueExpression getWidth() {
    return width;
  }

  public void setWidth(final javax.el.ValueExpression width) {
    this.width = width;
  }



  @Override
  public void release() {
    super.release();
    markup = null;
    height = null;
    left = null;
    modal = null;
    top = null;
    width = null;
  }
}