// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UIPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.PageTagDeclaration}.
 */
public final class PageTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(PageTag.class);
  private javax.el.ValueExpression  markup;
  private javax.el.ValueExpression  state;
  private javax.el.ValueExpression  focusId;
  private javax.el.ValueExpression  height;
  private javax.el.ValueExpression  width;
  private javax.el.ValueExpression  label;
  private javax.el.ValueExpression  applicationIcon;

  @Override
  public String getComponentType() {
    return UIPage.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "Page";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UIPage component = (UIPage) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (state != null) {
      if (!state.isLiteralText()) {
        component.setValueExpression("state", state);
      /*} else {
        component.setState(state.getExpressionString());*/
      }
    }
    if (focusId != null) {
      component.setValueExpression("focusId", focusId);
    }

    if (height != null) {
      if (!height.isLiteralText()) {
        component.setValueExpression("height", height);
      } else {
        component.setHeight(org.apache.myfaces.tobago.layout.Measure.valueOf(height.getExpressionString()));
      }
    }
    if (width != null) {
      if (!width.isLiteralText()) {
        component.setValueExpression("width", width);
      } else {
        component.setWidth(org.apache.myfaces.tobago.layout.Measure.valueOf(width.getExpressionString()));
      }
    }
    if (label != null) {
      component.setValueExpression("label", label);
    }

    if (applicationIcon != null) {
      component.setValueExpression("applicationIcon", applicationIcon);
    }

  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.ValueExpression getState() {
    return state;
  }

  public void setState(final javax.el.ValueExpression state) {
    this.state = state;
  }

  public javax.el.ValueExpression getFocusId() {
    return focusId;
  }

  public void setFocusId(final javax.el.ValueExpression focusId) {
    this.focusId = focusId;
  }

  public javax.el.ValueExpression getHeight() {
    return height;
  }

  public void setHeight(final javax.el.ValueExpression height) {
    this.height = height;
  }

  public javax.el.ValueExpression getWidth() {
    return width;
  }

  public void setWidth(final javax.el.ValueExpression width) {
    this.width = width;
  }

  public javax.el.ValueExpression getLabel() {
    return label;
  }

  public void setLabel(final javax.el.ValueExpression label) {
    this.label = label;
  }

  public javax.el.ValueExpression getApplicationIcon() {
    return applicationIcon;
  }

  public void setApplicationIcon(final javax.el.ValueExpression applicationIcon) {
    this.applicationIcon = applicationIcon;
  }



  @Override
  public void release() {
    super.release();
    markup = null;
    state = null;
    focusId = null;
    height = null;
    width = null;
    label = null;
    applicationIcon = null;
  }
}