// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UIMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.MessagesTagDeclaration}.
 */
public final class MessagesTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(MessagesTag.class);
  private javax.el.ValueExpression  markup;
  private javax.el.ValueExpression  showSummary;
  private javax.el.ValueExpression  orderBy;
  private javax.el.ValueExpression  globalOnly;
  private String forComponent;
  private javax.el.ValueExpression  maxSeverity;
  private javax.el.ValueExpression  minSeverity;
  private javax.el.ValueExpression  confirmation;
  private javax.el.ValueExpression  showDetail;
  private javax.el.ValueExpression  maxNumber;

  @Override
  public String getComponentType() {
    return UIMessages.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "Messages";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UIMessages component = (UIMessages) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (showSummary != null) {
      if (!showSummary.isLiteralText()) {
        component.setValueExpression("showSummary", showSummary);
      } else {
        component.setShowSummary(Boolean.parseBoolean(showSummary.getExpressionString()));
      }
    }
    if (orderBy != null) {
      if (!orderBy.isLiteralText()) {
        component.setValueExpression("orderBy", orderBy);
      } else {
        component.setOrderBy(org.apache.myfaces.tobago.internal.component.AbstractUIMessages.OrderBy.parse(orderBy.getExpressionString()));
      }
    }
    if (globalOnly != null) {
      component.setValueExpression("globalOnly", globalOnly);
    }

    if (forComponent != null) {
      component.setFor(forComponent);
    }

    if (maxSeverity != null) {
      if (!maxSeverity.isLiteralText()) {
        component.setValueExpression("maxSeverity", maxSeverity);
      } else {
        component.getAttributes().put("maxSeverity", maxSeverity.getExpressionString());
      }
    }
    if (minSeverity != null) {
      if (!minSeverity.isLiteralText()) {
        component.setValueExpression("minSeverity", minSeverity);
      } else {
        component.getAttributes().put("minSeverity", minSeverity.getExpressionString());
      }
    }
    if (confirmation != null) {
      if (!confirmation.isLiteralText()) {
        component.setValueExpression("confirmation", confirmation);
      } else {
        component.setConfirmation(Boolean.parseBoolean(confirmation.getExpressionString()));
      }
    }
    if (showDetail != null) {
      if (!showDetail.isLiteralText()) {
        component.setValueExpression("showDetail", showDetail);
      } else {
        component.setShowDetail(Boolean.parseBoolean(showDetail.getExpressionString()));
      }
    }
    if (maxNumber != null) {
      if (!maxNumber.isLiteralText()) {
        component.setValueExpression("maxNumber", maxNumber);
      } else {
        component.setMaxNumber(Integer.parseInt(maxNumber.getExpressionString()));
      }
    }
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.ValueExpression getShowSummary() {
    return showSummary;
  }

  public void setShowSummary(final javax.el.ValueExpression showSummary) {
    this.showSummary = showSummary;
  }

  public javax.el.ValueExpression getOrderBy() {
    return orderBy;
  }

  public void setOrderBy(final javax.el.ValueExpression orderBy) {
    this.orderBy = orderBy;
  }

  public javax.el.ValueExpression getGlobalOnly() {
    return globalOnly;
  }

  public void setGlobalOnly(final javax.el.ValueExpression globalOnly) {
    this.globalOnly = globalOnly;
  }

  public String getFor() {
    return forComponent;
  }

  public void setFor(final String forComponent) {
    this.forComponent = forComponent;
  }

  public javax.el.ValueExpression getMaxSeverity() {
    return maxSeverity;
  }

  public void setMaxSeverity(final javax.el.ValueExpression maxSeverity) {
    this.maxSeverity = maxSeverity;
  }

  public javax.el.ValueExpression getMinSeverity() {
    return minSeverity;
  }

  public void setMinSeverity(final javax.el.ValueExpression minSeverity) {
    this.minSeverity = minSeverity;
  }

  public javax.el.ValueExpression getConfirmation() {
    return confirmation;
  }

  public void setConfirmation(final javax.el.ValueExpression confirmation) {
    this.confirmation = confirmation;
  }

  public javax.el.ValueExpression getShowDetail() {
    return showDetail;
  }

  public void setShowDetail(final javax.el.ValueExpression showDetail) {
    this.showDetail = showDetail;
  }

  public javax.el.ValueExpression getMaxNumber() {
    return maxNumber;
  }

  public void setMaxNumber(final javax.el.ValueExpression maxNumber) {
    this.maxNumber = maxNumber;
  }



  @Override
  public void release() {
    super.release();
    markup = null;
    showSummary = null;
    orderBy = null;
    globalOnly = null;
    forComponent = null;
    maxSeverity = null;
    minSeverity = null;
    confirmation = null;
    showDetail = null;
    maxNumber = null;
  }
}