// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UILabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.LabelTagDeclaration}.
 */
public final class LabelTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(LabelTag.class);
  private javax.el.ValueExpression  markup;
  private javax.el.ValueExpression  accessKey;
  private String forComponent;
  private javax.el.ValueExpression  labelWithAccessKey;
  private javax.el.ValueExpression  tip;
  private javax.el.ValueExpression  inline;
  private javax.el.ValueExpression  value;

  @Override
  public String getComponentType() {
    return UILabel.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "Label";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UILabel component = (UILabel) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (accessKey != null) {
      if (!accessKey.isLiteralText()) {
        component.setValueExpression("accessKey", accessKey);
      } else {
        component.setAccessKey(accessKey.getExpressionString().charAt(0));
      }
    }
    if (forComponent != null) {
      component.setFor(forComponent);
    }

    if (labelWithAccessKey != null) {
      component.setValueExpression("labelWithAccessKey", labelWithAccessKey);
    }

    if (tip != null) {
      component.setValueExpression("tip", tip);
    }

    if (inline != null) {
      if (!inline.isLiteralText()) {
        component.setValueExpression("inline", inline);
      } else {
        component.setInline(Boolean.parseBoolean(inline.getExpressionString()));
      }
    }
    if (value != null) {
      component.setValueExpression("value", value);
    }

  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.ValueExpression getAccessKey() {
    return accessKey;
  }

  public void setAccessKey(final javax.el.ValueExpression accessKey) {
    this.accessKey = accessKey;
  }

  public String getFor() {
    return forComponent;
  }

  public void setFor(final String forComponent) {
    this.forComponent = forComponent;
  }

  public javax.el.ValueExpression getLabelWithAccessKey() {
    return labelWithAccessKey;
  }

  public void setLabelWithAccessKey(final javax.el.ValueExpression labelWithAccessKey) {
    this.labelWithAccessKey = labelWithAccessKey;
  }

  public javax.el.ValueExpression getTip() {
    return tip;
  }

  public void setTip(final javax.el.ValueExpression tip) {
    this.tip = tip;
  }

  public javax.el.ValueExpression getInline() {
    return inline;
  }

  public void setInline(final javax.el.ValueExpression inline) {
    this.inline = inline;
  }

  public javax.el.ValueExpression getValue() {
    return value;
  }

  public void setValue(final javax.el.ValueExpression value) {
    this.value = value;
  }



  @Override
  public void release() {
    super.release();
    markup = null;
    accessKey = null;
    forComponent = null;
    labelWithAccessKey = null;
    tip = null;
    inline = null;
    value = null;
  }
}