// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UIImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.ImageTagDeclaration}.
 */
public final class ImageTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(ImageTag.class);
  private javax.el.ValueExpression  markup;
  private javax.el.ValueExpression  tip;
  private javax.el.ValueExpression  height;
  private javax.el.ValueExpression  alt;
  private javax.el.ValueExpression  value;
  private javax.el.ValueExpression  border;
  private javax.el.ValueExpression  width;
  private javax.el.ValueExpression  disabled;

  @Override
  public String getComponentType() {
    return UIImage.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "Image";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UIImage component = (UIImage) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (tip != null) {
      component.setValueExpression("tip", tip);
    }

    if (height != null) {
      if (!height.isLiteralText()) {
        component.setValueExpression("height", height);
      } else {
        component.setHeight(org.apache.myfaces.tobago.layout.Measure.valueOf(height.getExpressionString()));
      }
    }
    if (alt != null) {
      component.setValueExpression("alt", alt);
    }

    if (value != null) {
      component.setValueExpression("value", value);
    }

    if (border != null) {
      component.setValueExpression("border", border);
    }

    if (width != null) {
      if (!width.isLiteralText()) {
        component.setValueExpression("width", width);
      } else {
        component.setWidth(org.apache.myfaces.tobago.layout.Measure.valueOf(width.getExpressionString()));
      }
    }
    if (disabled != null) {
      if (!disabled.isLiteralText()) {
        component.setValueExpression("disabled", disabled);
      } else {
        component.setDisabled(Boolean.parseBoolean(disabled.getExpressionString()));
      }
    }
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.ValueExpression getTip() {
    return tip;
  }

  public void setTip(final javax.el.ValueExpression tip) {
    this.tip = tip;
  }

  public javax.el.ValueExpression getHeight() {
    return height;
  }

  public void setHeight(final javax.el.ValueExpression height) {
    this.height = height;
  }

  public javax.el.ValueExpression getAlt() {
    return alt;
  }

  public void setAlt(final javax.el.ValueExpression alt) {
    this.alt = alt;
  }

  public javax.el.ValueExpression getValue() {
    return value;
  }

  public void setValue(final javax.el.ValueExpression value) {
    this.value = value;
  }

  public javax.el.ValueExpression getBorder() {
    return border;
  }

  public void setBorder(final javax.el.ValueExpression border) {
    this.border = border;
  }

  public javax.el.ValueExpression getWidth() {
    return width;
  }

  public void setWidth(final javax.el.ValueExpression width) {
    this.width = width;
  }

  public javax.el.ValueExpression getDisabled() {
    return disabled;
  }

  public void setDisabled(final javax.el.ValueExpression disabled) {
    this.disabled = disabled;
  }



  @Override
  public void release() {
    super.release();
    markup = null;
    tip = null;
    height = null;
    alt = null;
    value = null;
    border = null;
    width = null;
    disabled = null;
  }
}