// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.component;

import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIGridLayout;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.MethodBindingToMethodExpression;
import org.apache.myfaces.tobago.component.MethodExpressionToMethodBinding;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.renderkit.MarginValues;
import org.apache.myfaces.tobago.renderkit.SpacingValues;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRenderer;
import javax.el.ELException;
import javax.faces.FacesException;
import java.util.ArrayList;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;

/** 
 Renders a GridLayout.
  <pre>
  columns/rows ::= LAYOUT
  LAYOUT       ::= TOKEN [";" TOKEN]+
  TOKEN        ::= AUTO | PIXEL | PROPORTIONAL
  AUTO         ::= "auto" | "fixed"
  PIXEL        ::= NUMBER "px"
  PROPORTIONAL ::= [NUMBER] "*"
  </pre>
  <p/>
  <table border="1">
  <tr>
  <th>Parent</th>
  <th>Child</th>
  <th>Okay?</th>
  <th>Remarks</th>
  </tr>
  <tr>
  <td>AUTO</td>
  <td>any combination of AUTO or PIXEL but no PROPORTIONAL</td>
  <td>okay</td>
  <td>-</td>
  </tr>
  <tr>
  <td>AUTO</td>
  <td>any combination with at least one PROPORTIONAL</td>
  <td>wrong</td>
  <td>LayoutManager cannot compute the auto value.</td>
  </tr>
  <tr>
  <td>PIXEL</td>
  <td>any combination of AUTO or PIXEL but no PROPORTIONAL</td>
  <td>potentially wrong</td>
  <td>The values depend on each other, the programmer has to keep consistency manually.</td>
  </tr>
  <tr>
  <td>PIXEL</td>
  <td>any combination with at least one PROPORTIONAL</td>
  <td>okay</td>
  <td>-</td>
  </tr>
  <tr>
  <td>PROPORTIONAL</td>
  <td>any combination of AUTO or PIXEL but no PROPORTIONAL</td>
  <td>potentially wrong</td>
  <td>No automatic matching:<ul><li>too little space: scroll bar</li>
  <li>too much space: elements will be spread.</li></ul></td>
  </tr>
  <tr>
  <td>PROPORTIONAL</td>
  <td>any combination with at least one PROPORTIONAL</td>
  <td>okay</td>
  <td>-</td>
  </tr>
  </table>
  * UIComponent class, generated from template {@code component1.2.stg} with class
  * {@link org.apache.myfaces.tobago.internal.taglib.component.GridLayoutTagDeclaration}.
 */
public class UIGridLayout
    extends AbstractUIGridLayout implements SupportsMarkup {

  public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.GridLayout";

  public static final String COMPONENT_FAMILY = "org.apache.myfaces.tobago.GridLayout";

  private java.lang.Boolean rowOverflow;
  private org.apache.myfaces.tobago.context.Markup markup;
  private org.apache.myfaces.tobago.layout.Measure marginLeft;
  private org.apache.myfaces.tobago.layout.Measure marginTop;
  private org.apache.myfaces.tobago.layout.Measure marginRight;
  private java.lang.String columns;
  private java.lang.Boolean rigid;
  private org.apache.myfaces.tobago.layout.Measure cellspacing;
  private java.lang.String rows;
  private org.apache.myfaces.tobago.layout.Measure marginBottom;
  private java.lang.Boolean columnOverflow;
  private org.apache.myfaces.tobago.layout.Measure rowSpacing;
  private org.apache.myfaces.tobago.context.Markup currentMarkup;
  private org.apache.myfaces.tobago.layout.Measure margin;
  private java.lang.String border;
  private org.apache.myfaces.tobago.layout.Measure columnSpacing;

  public String getFamily() {
    return COMPONENT_FAMILY;
  }


  /**
  This attribute is a hint for the layout manager. Should not be used in most cases.

  */
  public boolean isRowOverflow() {
    if (rowOverflow != null) {
      return rowOverflow;
    }
    ValueExpression ve = getValueExpression("rowOverflow");
    if (ve != null) {
      try {
        Boolean bool = (Boolean) ve.getValue(getFacesContext().getELContext());
        if (bool != null) {
          return bool;
        }
      } catch (ELException e) {
  		  throw new FacesException(e);
  	  }
    }
    return false;
  }

  public void setRowOverflow(boolean rowOverflow) {
    this.rowOverflow = rowOverflow;
  }

  public org.apache.myfaces.tobago.context.Markup getMarkup() {
    if (markup != null) {
      return markup;
    }
    ValueExpression ve = getValueExpression("markup");
    if (ve != null) {
      try {
        Object object = ve.getValue(getFacesContext().getELContext());
        return Markup.valueOf(object);
      } catch (ELException e) {
  		  throw new FacesException(e);
  	  }
    }
    return null;
  }

  public void setMarkup(org.apache.myfaces.tobago.context.Markup markup) {
    this.markup = markup;
  }

  /**
  Left margin between container component and the children.

  */
  public org.apache.myfaces.tobago.layout.Measure getMarginLeft() {
    if (marginLeft != null) {
      return marginLeft;
    }
    ValueExpression ve = getValueExpression("marginLeft");
    if (ve != null) {
      try {
        Object object = ve.getValue(getFacesContext().getELContext());
        return Measure.valueOf(object);
      } catch (ELException e) {
  		  throw new FacesException(e);
  	  }
    }
    return getMargin() != null
   ? getMargin()
   : ((MarginValues)getRenderer(getFacesContext())).getMarginLeft(getFacesContext(), this);
  }

  public void setMarginLeft(org.apache.myfaces.tobago.layout.Measure marginLeft) {
    this.marginLeft = marginLeft;
  }

  /**
  Top margin between container component and the children.

  */
  public org.apache.myfaces.tobago.layout.Measure getMarginTop() {
    if (marginTop != null) {
      return marginTop;
    }
    ValueExpression ve = getValueExpression("marginTop");
    if (ve != null) {
      try {
        Object object = ve.getValue(getFacesContext().getELContext());
        return Measure.valueOf(object);
      } catch (ELException e) {
  		  throw new FacesException(e);
  	  }
    }
    return getMargin() != null
   ? getMargin()
   : ((MarginValues)getRenderer(getFacesContext())).getMarginTop(getFacesContext(), this);
  }

  public void setMarginTop(org.apache.myfaces.tobago.layout.Measure marginTop) {
    this.marginTop = marginTop;
  }

  /**
  Right margin between container component and the children.

  */
  public org.apache.myfaces.tobago.layout.Measure getMarginRight() {
    if (marginRight != null) {
      return marginRight;
    }
    ValueExpression ve = getValueExpression("marginRight");
    if (ve != null) {
      try {
        Object object = ve.getValue(getFacesContext().getELContext());
        return Measure.valueOf(object);
      } catch (ELException e) {
  		  throw new FacesException(e);
  	  }
    }
    return getMargin() != null
   ? getMargin()
   : ((MarginValues)getRenderer(getFacesContext())).getMarginRight(getFacesContext(), this);
  }

  public void setMarginRight(org.apache.myfaces.tobago.layout.Measure marginRight) {
    this.marginRight = marginRight;
  }

  /**
  This value defines the layout constraints for column layout.
   It is a semicolon separated list of layout tokens '[&lt;n>]*', '&lt;n>px' or 'auto'.
   Where &lt;n> is a non negative integer and the square brackets means optional.
   Example: '2*;*;100px;auto'.
  <br />Default: <code>1*</code>
  */
  public java.lang.String getColumns() {
    if (columns != null) {
      return columns;
    }
    ValueExpression ve = getValueExpression("columns");
    if (ve != null) {
      try {
        java.lang.String columns = (java.lang.String) ve.getValue(getFacesContext().getELContext());
        if (columns != null) {
          return columns;
        }
      } catch (ELException e) {
  		  throw new FacesException(e);
  	  }
    }
    return "1*";
  }

  public void setColumns(java.lang.String columns) {
    this.columns = columns;
  }

  /**
  This attribute advises the layout manager, to not use space that comes from non rendered components.

  */
  public boolean isRigid() {
    if (rigid != null) {
      return rigid;
    }
    ValueExpression ve = getValueExpression("rigid");
    if (ve != null) {
      try {
        Boolean bool = (Boolean) ve.getValue(getFacesContext().getELContext());
        if (bool != null) {
          return bool;
        }
      } catch (ELException e) {
  		  throw new FacesException(e);
  	  }
    }
    return false;
  }

  public void setRigid(boolean rigid) {
    this.rigid = rigid;
  }

  /**
  Spacing between component and layout cell's.
   Can be overwritten by columnSpacing and rowSpacing.

  @deprecated*/
  @Deprecated
  public org.apache.myfaces.tobago.layout.Measure getCellspacing() {
    if (cellspacing != null) {
      return cellspacing;
    }
    ValueExpression ve = getValueExpression("cellspacing");
    if (ve != null) {
      try {
        Object object = ve.getValue(getFacesContext().getELContext());
        return Measure.valueOf(object);
      } catch (ELException e) {
  		  throw new FacesException(e);
  	  }
    }
    return null;
  }

  @Deprecated
  public void setCellspacing(org.apache.myfaces.tobago.layout.Measure cellspacing) {
    this.cellspacing = cellspacing;
  }

  /**
  This value defines the layout constraints for column layout.
   It is a semicolon separated list of layout tokens '[&lt;n>]*', '&lt;n>px' or 'auto'.
   Where &lt;n> is a non negative integer and the square brackets means optional.
   Example: '2*;*;100px;auto'.
  <br />Default: <code>1*</code>
  */
  public java.lang.String getRows() {
    if (rows != null) {
      return rows;
    }
    ValueExpression ve = getValueExpression("rows");
    if (ve != null) {
      try {
        java.lang.String rows = (java.lang.String) ve.getValue(getFacesContext().getELContext());
        if (rows != null) {
          return rows;
        }
      } catch (ELException e) {
  		  throw new FacesException(e);
  	  }
    }
    return "1*";
  }

  public void setRows(java.lang.String rows) {
    this.rows = rows;
  }

  /**
  Bottom margin between container component and the children.

  */
  public org.apache.myfaces.tobago.layout.Measure getMarginBottom() {
    if (marginBottom != null) {
      return marginBottom;
    }
    ValueExpression ve = getValueExpression("marginBottom");
    if (ve != null) {
      try {
        Object object = ve.getValue(getFacesContext().getELContext());
        return Measure.valueOf(object);
      } catch (ELException e) {
  		  throw new FacesException(e);
  	  }
    }
    return getMargin() != null
   ? getMargin()
   : ((MarginValues)getRenderer(getFacesContext())).getMarginBottom(getFacesContext(), this);
  }

  public void setMarginBottom(org.apache.myfaces.tobago.layout.Measure marginBottom) {
    this.marginBottom = marginBottom;
  }

  /**
  This attribute is a hint for the layout manager. Should not be used in most cases.

  */
  public boolean isColumnOverflow() {
    if (columnOverflow != null) {
      return columnOverflow;
    }
    ValueExpression ve = getValueExpression("columnOverflow");
    if (ve != null) {
      try {
        Boolean bool = (Boolean) ve.getValue(getFacesContext().getELContext());
        if (bool != null) {
          return bool;
        }
      } catch (ELException e) {
  		  throw new FacesException(e);
  	  }
    }
    return false;
  }

  public void setColumnOverflow(boolean columnOverflow) {
    this.columnOverflow = columnOverflow;
  }

  /**
  Spacing between the rows in the actual layout.

  */
  public org.apache.myfaces.tobago.layout.Measure getRowSpacing() {
    if (rowSpacing != null) {
      return rowSpacing;
    }
    ValueExpression ve = getValueExpression("rowSpacing");
    if (ve != null) {
      try {
        Object object = ve.getValue(getFacesContext().getELContext());
        return Measure.valueOf(object);
      } catch (ELException e) {
  		  throw new FacesException(e);
  	  }
    }
    return getCellspacing() != null
   ? getCellspacing()
   : ((SpacingValues)getRenderer(getFacesContext())).getRowSpacing(getFacesContext(), this);
  }

  public void setRowSpacing(org.apache.myfaces.tobago.layout.Measure rowSpacing) {
    this.rowSpacing = rowSpacing;
  }

  public org.apache.myfaces.tobago.context.Markup getCurrentMarkup() {
    if (currentMarkup != null) {
      return currentMarkup;
    }
    return null;
  }

  public void setCurrentMarkup(org.apache.myfaces.tobago.context.Markup currentMarkup) {
    this.currentMarkup = currentMarkup;
  }

  /**
  Margin between container component and the children.

  */
  public org.apache.myfaces.tobago.layout.Measure getMargin() {
    if (margin != null) {
      return margin;
    }
    ValueExpression ve = getValueExpression("margin");
    if (ve != null) {
      try {
        Object object = ve.getValue(getFacesContext().getELContext());
        return Measure.valueOf(object);
      } catch (ELException e) {
  		  throw new FacesException(e);
  	  }
    }
    return null;
  }

  public void setMargin(org.apache.myfaces.tobago.layout.Measure margin) {
    this.margin = margin;
  }

  /**
  Border size of this component.

  */
  public java.lang.String getBorder() {
    if (border != null) {
      return border;
    }
    ValueExpression ve = getValueExpression("border");
    if (ve != null) {
      try {
        return (java.lang.String) ve.getValue(getFacesContext().getELContext());
      } catch (ELException e) {
  		  throw new FacesException(e);
  	  }
    }
    return null;
  }

  public void setBorder(java.lang.String border) {
    this.border = border;
  }

  /**
  Spacing between the columns in the actual layout.

  */
  public org.apache.myfaces.tobago.layout.Measure getColumnSpacing() {
    if (columnSpacing != null) {
      return columnSpacing;
    }
    ValueExpression ve = getValueExpression("columnSpacing");
    if (ve != null) {
      try {
        Object object = ve.getValue(getFacesContext().getELContext());
        return Measure.valueOf(object);
      } catch (ELException e) {
  		  throw new FacesException(e);
  	  }
    }
    return getCellspacing() != null
   ? getCellspacing()
   : ((SpacingValues)getRenderer(getFacesContext())).getColumnSpacing(getFacesContext(), this);
  }

  public void setColumnSpacing(org.apache.myfaces.tobago.layout.Measure columnSpacing) {
    this.columnSpacing = columnSpacing;
  }

  public void restoreState(FacesContext context, Object componentState) {
    Object[] values = (Object[]) componentState;
    super.restoreState(context, values[0]);
    rowOverflow = (java.lang.Boolean) values[1];
    markup = (org.apache.myfaces.tobago.context.Markup) values[2];
    marginLeft = (org.apache.myfaces.tobago.layout.Measure) values[3];
    marginTop = (org.apache.myfaces.tobago.layout.Measure) values[4];
    marginRight = (org.apache.myfaces.tobago.layout.Measure) values[5];
    columns = (java.lang.String) values[6];
    rigid = (java.lang.Boolean) values[7];
    cellspacing = (org.apache.myfaces.tobago.layout.Measure) values[8];
    rows = (java.lang.String) values[9];
    marginBottom = (org.apache.myfaces.tobago.layout.Measure) values[10];
    columnOverflow = (java.lang.Boolean) values[11];
    rowSpacing = (org.apache.myfaces.tobago.layout.Measure) values[12];
    margin = (org.apache.myfaces.tobago.layout.Measure) values[13];
    border = (java.lang.String) values[14];
    columnSpacing = (org.apache.myfaces.tobago.layout.Measure) values[15];
  }

  public Object saveState(FacesContext context) {
    Object[] values = new Object[16];
    values[0] = super.saveState(context);
    values[1] = rowOverflow;
    values[2] = markup;
    values[3] = marginLeft;
    values[4] = marginTop;
    values[5] = marginRight;
    values[6] = columns;
    values[7] = rigid;
    values[8] = cellspacing;
    values[9] = rows;
    values[10] = marginBottom;
    values[11] = columnOverflow;
    values[12] = rowSpacing;
    values[13] = margin;
    values[14] = border;
    values[15] = columnSpacing;
    currentMarkup = null;
    return values;
  }


}