/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Arrays;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeData;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.internal.component.AbstractUITree;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TreeRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtils.isOutputOnly((UIComponent)component)) {
            return;
        }
        AbstractUITree tree = (AbstractUITree)component;
        tree.setValid(true);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUITree tree = (AbstractUITree)component;
        String clientId = tree.getClientId(facesContext);
        UIComponent root = tree.getRoot();
        if (root == null) {
            LOG.error("Can't find the tree root. This may occur while updating a tree from Tobago 1.0 to 1.5. Please refer the documentation to see how to use tree tags.");
            return;
        }
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("div", (UIComponent)tree);
        writer.writeClassAttribute(Classes.create((UIComponent)tree));
        Style style = new Style(facesContext, (LayoutBase)tree);
        writer.writeStyleAttribute(style);
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)tree);
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute("value", ";", false);
        writer.endElement("input");
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId + "::" + "marked");
        writer.writeIdAttribute(clientId + "::" + "marked");
        writer.writeClassAttribute(Classes.create((UIComponent)tree, (String)"marked"));
        writer.writeAttribute("value", "", false);
        writer.endElement("input");
        RenderUtils.encode((FacesContext)facesContext, (UIComponent)root, Arrays.asList(UITreeNode.class, UITreeData.class));
        writer.endElement("div");
    }
}

