/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeMenu;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.context.UserAgent;
import org.apache.myfaces.tobago.event.TreeExpansionEvent;
import org.apache.myfaces.tobago.event.TreeMarkedEvent;
import org.apache.myfaces.tobago.layout.Display;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.VariableResolverUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeMenuNodeRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TreeMenuNodeRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        String marked;
        UITreeNode node = (UITreeNode)component;
        super.decode(facesContext, (UIComponent)node);
        if (ComponentUtils.isOutputOnly((UIComponent)node)) {
            return;
        }
        UITreeMenu tree = (UITreeMenu)ComponentUtils.findAncestor((UIComponent)node, UITreeMenu.class);
        String treeId = tree.getClientId(facesContext);
        String nodeStateId = node.nodeStateId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String id = node.getClientId(facesContext);
        boolean folder = node.isFolder();
        boolean expanded = Boolean.parseBoolean((String)requestParameterMap.get(id + "::" + "expanded"));
        if (node.isExpanded() != expanded) {
            new TreeExpansionEvent((UIComponent)node, node.isExpanded(), expanded).queue();
        }
        if ((marked = (String)requestParameterMap.get(treeId + "::" + "marked")) != null) {
            String searchString = treeId + ':' + nodeStateId;
            boolean markedValue = marked.equals(searchString);
            if (node.isMarked() != markedValue) {
                new TreeMarkedEvent((UIComponent)node, node.isMarked(), markedValue).queue();
            }
        } else {
            LOG.warn("This log message is help clarifying the occurrence of this else case.");
        }
    }

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        UITreeNode node = (UITreeNode)component;
        if (node.isMarked()) {
            node.setCurrentMarkup(Markup.MARKED.add(node.getCurrentMarkup()));
        }
        if (node.isFolder()) {
            node.setCurrentMarkup(Markup.FOLDER.add(node.getCurrentMarkup()));
            if (node.isExpanded()) {
                node.setCurrentMarkup(Markup.EXPANDED.add(node.getCurrentMarkup()));
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeNode node = (UITreeNode)component;
        UITreeMenu tree = (UITreeMenu)ComponentUtils.findAncestor((UIComponent)node, UITreeMenu.class);
        boolean folder = node.isFolder();
        String id = node.getClientId(facesContext);
        int level = node.getLevel();
        boolean root = level == 0;
        boolean expanded = folder && node.isExpanded() || level == 0;
        boolean showRoot = tree.isShowRoot();
        boolean ie6 = VariableResolverUtils.resolveClientProperties((FacesContext)facesContext).getUserAgent().equals(UserAgent.MSIE_6_0);
        String clientId = node.getClientId(facesContext);
        int colon2 = clientId.lastIndexOf(":");
        int colon1 = clientId.substring(0, colon2 - 1).lastIndexOf(":");
        String structure = clientId.substring(colon1 + 1, colon2);
        String parentStructure = this.getParentStructure(structure);
        String parentId = root ? null : clientId.substring(0, colon1 + 1) + parentStructure + clientId.substring(colon2);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        if (expanded) {
            tree.getExpandedCache().add(structure);
        }
        if (showRoot || !root) {
            writer.startElement("div", null);
            writer.writeIdAttribute(id);
            writer.writeClassAttribute(Classes.create((UIComponent)node));
            writer.writeAttribute("data-tobago-treeparent", parentId, false);
            HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)node);
            if (!root) {
                while (parentStructure != null) {
                    if (!tree.getExpandedCache().contains(parentStructure)) {
                        Style style = new Style();
                        style.setDisplay(Display.NONE);
                        writer.writeStyleAttribute(style);
                        break;
                    }
                    parentStructure = this.getParentStructure(parentStructure);
                }
            }
            if (folder) {
                this.encodeExpandedHidden(writer, node, id, expanded);
            }
            if (!folder && ie6) {
                String src = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)"image/1x1.gif");
                writer.startElement("img", null);
                writer.writeClassAttribute(Classes.create((UIComponent)node, (String)"icon"));
                writer.writeAttribute("src", src, false);
                writer.writeAttribute("alt", "", false);
                writer.writeStyleAttribute("width: 0px");
                writer.endElement("img");
            }
            RenderUtils.encodeChildren((FacesContext)facesContext, (UIComponent)node);
            if (folder) {
                this.encodeIcon(facesContext, writer, expanded, node);
            }
            writer.endElement("div");
        }
    }

    private String getParentStructure(String structure) {
        int underscore = structure.lastIndexOf("_");
        return underscore <= 0 ? null : structure.substring(0, underscore);
    }

    private void encodeExpandedHidden(TobagoResponseWriter writer, UITreeNode node, String clientId, boolean expanded) throws IOException {
        writer.startElement("input", (UIComponent)node);
        writer.writeAttribute("type", "hidden", false);
        writer.writeClassAttribute(Classes.create((UIComponent)node, (String)"expanded", (Markup)Markup.NULL));
        writer.writeNameAttribute(clientId + "::" + "expanded");
        writer.writeAttribute("value", Boolean.toString(expanded), false);
        writer.endElement("input");
    }

    private void encodeIcon(FacesContext facesContext, TobagoResponseWriter writer, boolean expanded, UITreeNode node) throws IOException {
        String srcOpen = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)"image/treeMenuOpen.gif");
        String srcClose = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)"image/treeMenuClose.gif");
        String src = expanded ? srcOpen : srcClose;
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)node, (String)"toggle"));
        writer.writeAttribute("src", src, false);
        writer.writeAttribute("data-tobago-srcopen", srcOpen, false);
        writer.writeAttribute("data-tobago-srcclose", srcClose, false);
        writer.writeAttribute("alt", "", false);
        writer.endElement("img");
    }
}

