/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.internal.component.AbstractUITree;
import org.apache.myfaces.tobago.internal.context.ResponseWriterDivider;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Position;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeListboxRenderer
extends LayoutComponentRendererBase {
    public static final String DIVIDER = TreeListboxRenderer.class.getName() + "DIVIDER";

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        this.setRendererTypeForCommandsAndNodes(component);
    }

    protected void setRendererTypeForCommandsAndNodes(UIComponent component) {
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UITreeNode) {
                child.setRendererType("TreeListboxNode");
            }
            this.setRendererTypeForCommandsAndNodes(child);
        }
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtils.isOutputOnly((UIComponent)component)) {
            return;
        }
        AbstractUITree tree = (AbstractUITree)component;
        tree.setValid(true);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUITree tree = (AbstractUITree)component;
        String clientId = tree.getClientId(facesContext);
        UIComponent root = tree.getRoot();
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("div", (UIComponent)tree);
        writer.writeClassAttribute(Classes.create((UIComponent)tree));
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)tree);
        Style style = new Style(facesContext, (LayoutBase)tree);
        writer.writeStyleAttribute(style);
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute("value", ";", false);
        writer.endElement("input");
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId + "::" + "marked");
        writer.writeIdAttribute(clientId + "::" + "marked");
        writer.writeAttribute("value", "", false);
        writer.endElement("input");
        if (tree.getSelectableAsEnum().isSupportedByTreeListbox()) {
            writer.startElement("input", (UIComponent)tree);
            writer.writeAttribute("type", "hidden", false);
            writer.writeNameAttribute(clientId + "-selectState");
            writer.writeIdAttribute(clientId + "-selectState");
            writer.writeAttribute("value", ";", false);
            writer.endElement("input");
        }
        RenderUtils.encode((FacesContext)facesContext, (UIComponent)root);
        writer.startElement("div", (UIComponent)tree);
        Style scrollDivStyle = new Style();
        scrollDivStyle.setWidth(Measure.valueOf((int)960));
        scrollDivStyle.setHeight(style.getHeight().subtract(15));
        scrollDivStyle.setPosition(Position.ABSOLUTE);
        writer.writeStyleAttribute(scrollDivStyle);
        ResponseWriterDivider divider = ResponseWriterDivider.getInstance((FacesContext)facesContext, (String)DIVIDER);
        while (divider.activateBranch(facesContext)) {
            writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
            writer.endElement("div");
        }
        while (divider.passivateBranch(facesContext)) {
        }
        divider.writeOutAndCleanUp(facesContext);
        writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        writer.endElement("div");
        writer.endElement("div");
    }
}

