/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITree;
import org.apache.myfaces.tobago.component.UITreeIndent;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUITree;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeIndentRenderer
extends LayoutComponentRendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeIndent indent = (UITreeIndent)component;
        UITreeNode node = (UITreeNode)ComponentUtils.findAncestor((UIComponent)indent, UITreeNode.class);
        AbstractUITree tree = (AbstractUITree)ComponentUtils.findAncestor((UIComponent)indent, AbstractUITree.class);
        boolean folder = node.isFolder();
        int level = node.getLevel();
        boolean hasNextSibling = node.isHasNextSibling();
        List junctions = node.getJunctions();
        boolean showRoot = ((UITree)tree).isShowRoot();
        boolean showJunctions = indent.isShowJunctions();
        boolean showRootJunction = ((UITree)tree).isShowRootJunction();
        boolean expanded = folder && node.isExpanded() || !showRoot && level == 0;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)indent);
        this.encodeIndent(facesContext, writer, node, showJunctions, !showRoot || !showRootJunction && showJunctions, junctions);
        this.encodeTreeJunction(facesContext, writer, node, !showJunctions, !showRootJunction, expanded, folder, level == 0, hasNextSibling);
    }

    private void encodeIndent(FacesContext facesContext, TobagoResponseWriter writer, UITreeNode node, boolean showJunctions, boolean dropFirst, List<Boolean> junctions) throws IOException {
        int i;
        String blank = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)"image/blank.gif");
        String perpendicular = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)"image/I.gif");
        int n = i = dropFirst ? 1 : 0;
        while (i < junctions.size()) {
            Boolean junction = junctions.get(i);
            writer.startElement("img", null);
            writer.writeClassAttribute(Classes.create((UIComponent)node, (String)"junction"));
            writer.writeAttribute("alt", "", false);
            if (junction.booleanValue() && showJunctions) {
                writer.writeAttribute("src", perpendicular, true);
            } else {
                writer.writeAttribute("src", blank, true);
            }
            writer.endElement("img");
            ++i;
        }
    }

    private void encodeTreeJunction(FacesContext facesContext, TobagoResponseWriter writer, UITreeNode node, boolean hideJunctions, boolean hideRootJunction, boolean expanded, boolean folder, boolean root, boolean hasNextSibling) throws IOException {
        String close;
        String open;
        if (hideJunctions || hideRootJunction && root) {
            return;
        }
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)node, (String)"toggle", (Markup)Markup.NULL));
        if (root) {
            open = "Rminus.gif";
            close = "Rplus.gif";
        } else if (hasNextSibling) {
            if (folder) {
                open = "Tminus.gif";
                close = "Tplus.gif";
            } else {
                open = "T.gif";
                close = "T.gif";
            }
        } else if (folder) {
            open = "Lminus.gif";
            close = "Lplus.gif";
        } else {
            open = "L.gif";
            close = "L.gif";
        }
        String srcOpen = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)("image/" + open));
        String srcClose = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)("image/" + close));
        String src = expanded ? srcOpen : srcClose;
        writer.writeAttribute("src", src, true);
        if (folder) {
            writer.writeAttribute("data-tobago-srcopen", srcOpen, true);
            writer.writeAttribute("data-tobago-srcclose", srcClose, true);
        }
        writer.writeAttribute("alt", "", false);
        writer.endElement("img");
    }
}

