/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UISelectOneChoice;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.HtmlUtils;
import org.apache.myfaces.tobago.renderkit.SelectOneRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.VariableResolverUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectOneChoiceRenderer
extends SelectOneRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SelectOneChoiceRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String onchange;
        if (!(component instanceof UISelectOneChoice)) {
            LOG.error("Wrong type: Need " + UISelectOneChoice.class.getName() + ", but was " + component.getClass().getName());
            return;
        }
        UISelectOneChoice select = (UISelectOneChoice)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        String id = select.getClientId(facesContext);
        List items = RenderUtils.getSelectItems((UIComponent)select);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages((FacesContext)facesContext, (UIComponent)select);
        boolean disabled = items.size() == 0 || select.isDisabled() || select.isReadonly();
        writer.startElement("select", (UIComponent)select);
        writer.writeNameAttribute(id);
        writer.writeIdAttribute(id);
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)select);
        writer.writeAttribute("disabled", disabled);
        Integer tabIndex = select.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        Style style = new Style(facesContext, (LayoutBase)select);
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)select));
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        if ((onchange = HtmlUtils.generateOnchange((UIInput)select, (FacesContext)facesContext)) != null) {
            writer.writeAttribute("onchange", onchange, true);
        }
        if (VariableResolverUtils.resolveClientProperties((FacesContext)facesContext).getUserAgent().isMsie6()) {
            writer.writeAttribute("onfocusin", "Tobago.fixSelectionOnFocusIn()", false);
            writer.writeAttribute("onfocus", "Tobago.fixSelectionOnFocus()", false);
        }
        Object[] values = new Object[]{select.getValue()};
        HtmlRendererUtils.renderSelectItems((UIInput)select, (List)items, (Object[])values, (TobagoResponseWriter)writer, (FacesContext)facesContext);
        writer.endElement("select");
        super.encodeEnd(facesContext, (UIComponent)select);
        HtmlRendererUtils.renderFocusId((FacesContext)facesContext, (UIInput)select);
        HtmlRendererUtils.checkForCommandFacet((UIComponent)select, (FacesContext)facesContext, (TobagoResponseWriter)writer);
    }
}

