/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UISelectManyListbox;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.SelectManyRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectManyListboxRenderer
extends SelectManyRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SelectManyListboxRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (!(component instanceof UISelectManyListbox)) {
            LOG.error("Wrong type: Need " + UISelectManyListbox.class.getName() + ", but was " + component.getClass().getName());
            return;
        }
        UISelectManyListbox select = (UISelectManyListbox)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        String id = select.getClientId(facesContext);
        List items = RenderUtils.getSelectItems((UIComponent)select);
        boolean disabled = items.size() == 0 || select.isDisabled() || select.isReadonly();
        String title = HtmlRendererUtils.getTitleFromTipAndMessages((FacesContext)facesContext, (UIComponent)select);
        writer.startElement("select", (UIComponent)select);
        writer.writeNameAttribute(id);
        writer.writeIdAttribute(id);
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)select);
        writer.writeAttribute("disabled", disabled);
        Integer tabIndex = select.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        Style style = new Style(facesContext, (LayoutBase)select);
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)select));
        writer.writeAttribute("multiple", "multiple", false);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        Object[] values = select.getSelectedValues();
        HtmlRendererUtils.renderSelectItems((UIInput)select, (List)items, (Object[])values, (TobagoResponseWriter)writer, (FacesContext)facesContext);
        writer.endElement("select");
        HtmlRendererUtils.renderFocusId((FacesContext)facesContext, (UIInput)select);
        HtmlRendererUtils.checkForCommandFacet((UIComponent)select, (FacesContext)facesContext, (TobagoResponseWriter)writer);
    }
}

