/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UISelectBooleanCheckbox;
import org.apache.myfaces.tobago.internal.util.AccessKeyMap;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectBooleanCheckboxRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SelectBooleanCheckboxRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        UIInput input = (UIInput)component;
        if (ComponentUtils.isOutputOnly((UIComponent)input)) {
            return;
        }
        String newValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(input.getClientId(facesContext));
        if (LOG.isDebugEnabled()) {
            LOG.debug("new value = '" + newValue + "'");
        }
        input.setSubmittedValue((Object)("true".equals(newValue) ? "true" : "false"));
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UISelectBooleanCheckbox select = (UISelectBooleanCheckbox)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        String id = select.getClientId(facesContext);
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)select);
        boolean checked = "true".equals(currentValue);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages((FacesContext)facesContext, (UIComponent)select);
        writer.startElement("div", (UIComponent)select);
        writer.writeStyleAttribute(new Style(facesContext, (LayoutBase)select));
        writer.writeClassAttribute(Classes.create((UIComponent)select));
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)select);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        writer.startElement("input", (UIComponent)select);
        writer.writeAttribute("type", "checkbox", false);
        writer.writeAttribute("value", "true", false);
        writer.writeNameAttribute(id);
        writer.writeIdAttribute(id);
        writer.writeAttribute("checked", checked);
        if (ComponentUtils.getBooleanAttribute((UIComponent)select, (String)"readonly")) {
            writer.writeAttribute("readonly", true);
            if (checked) {
                writer.writeAttribute("onclick", "this.checked=true", false);
            } else {
                writer.writeAttribute("onclick", "this.checked=false", false);
            }
        }
        writer.writeAttribute("disabled", select.isDisabled());
        Integer tabIndex = select.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        writer.endElement("input");
        String label = select.getItemLabel();
        if (label == null) {
            label = select.getLabel();
        }
        if (label != null) {
            LabelWithAccessKey labelWithAccessKey = new LabelWithAccessKey(label);
            writer.startElement("label", (UIComponent)select);
            writer.writeAttribute("for", id, false);
            HtmlRendererUtils.writeLabelWithAccessKey((TobagoResponseWriter)writer, (LabelWithAccessKey)labelWithAccessKey);
            writer.endElement("label");
            if (labelWithAccessKey.getAccessKey() != null) {
                if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)labelWithAccessKey.getAccessKey())) {
                    LOG.info("duplicated accessKey : " + labelWithAccessKey.getAccessKey());
                }
                HtmlRendererUtils.addClickAcceleratorKey((FacesContext)facesContext, (String)id, (char)labelWithAccessKey.getAccessKey().charValue());
            }
        }
        writer.endElement("div");
        HtmlRendererUtils.checkForCommandFacet((UIComponent)select, (FacesContext)facesContext, (TobagoResponseWriter)writer);
    }
}

