/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.application.ProjectStage;
import org.apache.myfaces.tobago.component.UIForm;
import org.apache.myfaces.tobago.component.UIMenuBar;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.internal.ajax.AjaxInternalUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUICommandBase;
import org.apache.myfaces.tobago.internal.layout.LayoutContext;
import org.apache.myfaces.tobago.internal.util.AccessKeyMap;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.internal.util.FastStringWriter;
import org.apache.myfaces.tobago.internal.util.MimeTypeUtils;
import org.apache.myfaces.tobago.internal.util.ResponseUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.PageRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.CommandRendererHelper;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.FacesVersion;
import org.apache.myfaces.tobago.util.VariableResolverUtils;
import org.apache.myfaces.tobago.webapp.Secret;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageRenderer
extends PageRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(PageRenderer.class);
    private static final String CLIENT_DEBUG_SEVERITY = "clientDebugSeverity";
    private static final String LAST_FOCUS_ID = "lastFocusId";

    public void decode(FacesContext facesContext, UIComponent component) {
        String lastFocusId;
        super.decode(facesContext, component);
        String clientId = component.getClientId(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        String severity = (String)externalContext.getRequestParameterMap().get(clientId + "::" + "clientSeverity");
        if (severity != null) {
            externalContext.getRequestMap().put(CLIENT_DEBUG_SEVERITY, severity);
        }
        if ((lastFocusId = (String)externalContext.getRequestParameterMap().get(clientId + "::" + LAST_FOCUS_ID)) != null) {
            component.getAttributes().put(LAST_FOCUS_ID, lastFocusId);
        }
        String name = clientId + "::" + "scrollbarWeight";
        String value = null;
        try {
            value = (String)facesContext.getExternalContext().getRequestParameterMap().get(name);
            if (StringUtils.isNotBlank((String)value)) {
                StringTokenizer tokenizer = new StringTokenizer(value, ";");
                Measure vertical = Measure.valueOf((String)tokenizer.nextToken());
                Measure horizontal = Measure.valueOf((String)tokenizer.nextToken());
                if (vertical.greaterThan(Measure.valueOf((int)30)) || vertical.lessThan(Measure.valueOf((int)3)) || horizontal.greaterThan(Measure.valueOf((int)30)) || horizontal.lessThan(Measure.valueOf((int)3))) {
                    LOG.error("Ignoring strange values: vertical=" + vertical + " horizontal=" + horizontal);
                } else {
                    ClientProperties client = VariableResolverUtils.resolveClientProperties((FacesContext)facesContext);
                    client.setVerticalScrollbarWeight(vertical);
                    client.setHorizontalScrollbarWeight(horizontal);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error in decoding '" + name + "': value='" + value + "'", (Throwable)e);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UIMenuBar menuBar;
        String lastFocusId;
        UIPage page = (UIPage)component;
        RenderUtils.prepareRendererAll((FacesContext)facesContext, (UIComponent)page);
        LayoutContext layoutContext = new LayoutContext((LayoutContainer)page);
        layoutContext.layout();
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        facesContext.setResponseWriter((ResponseWriter)writer);
        ResponseUtils.ensureNoCacheHeader((FacesContext)facesContext);
        if (LOG.isDebugEnabled()) {
            Iterator i$ = page.getAttributes().entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i$.next();
                LOG.debug("*** '" + entry.getKey() + "' -> '" + entry.getValue() + "'");
            }
        }
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        String viewId = facesContext.getViewRoot().getViewId();
        String formAction = viewHandler.getActionURL(facesContext, viewId);
        formAction = facesContext.getExternalContext().encodeActionURL(formAction);
        String contentType = writer.getContentTypeWithCharSet();
        ResponseUtils.ensureContentTypeHeader((FacesContext)facesContext, (String)contentType);
        String clientId = page.getClientId(facesContext);
        ClientProperties client = VariableResolverUtils.resolveClientProperties((FacesContext)facesContext);
        ProjectStage projectStage = TobagoConfig.getInstance((FacesContext)facesContext).getProjectStage();
        boolean developmentMode = projectStage == ProjectStage.Development;
        boolean debugMode = client.isDebugMode() || developmentMode;
        boolean productionMode = !debugMode && projectStage == ProjectStage.Production;
        boolean calculateScrollbarWeight = false;
        int clientLogSeverity = 2;
        if (debugMode) {
            String severity = (String)facesContext.getExternalContext().getRequestMap().get(CLIENT_DEBUG_SEVERITY);
            if (LOG.isDebugEnabled()) {
                LOG.debug("get clientDebugSeverity = " + severity);
            }
            if (severity != null) {
                try {
                    int index = severity.indexOf(59);
                    if (index == -1) {
                        index = severity.length();
                    }
                    clientLogSeverity = Integer.parseInt(severity.substring(0, index));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (!FacesContextUtils.isAjax((FacesContext)facesContext)) {
            CommandRendererHelper helper;
            UIComponent command;
            String focusId;
            Set styleBlocks;
            String icon;
            HtmlRendererUtils.renderDojoDndSource((FacesContext)facesContext, (UIComponent)component);
            String title = (String)page.getAttributes().get("label");
            writer.startElement("head", null);
            writer.startElement("meta", null);
            writer.writeAttribute("http-equiv", "Content-Type", false);
            writer.writeAttribute("content", contentType, false);
            writer.endElement("meta");
            writer.startElement("title", null);
            writer.writeText(title != null ? title : "");
            writer.endElement("title");
            Theme theme = client.getTheme();
            if (debugMode) {
                writer.writeJavascript("var TbgHeadStart = new Date();");
            }
            for (String styleFile : theme.getStyleResources(productionMode)) {
                this.writeStyle(facesContext, writer, styleFile);
            }
            for (String styleFile : FacesContextUtils.getStyleFiles((FacesContext)facesContext)) {
                this.writeStyle(facesContext, writer, styleFile);
            }
            if (!productionMode) {
                this.checkDuplicates(theme.getStyleResources(productionMode), FacesContextUtils.getStyleFiles((FacesContext)facesContext));
            }
            if ((icon = page.getApplicationIcon()) != null) {
                if (!ResourceManagerUtils.isAbsoluteResource((String)icon)) {
                    icon = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)icon);
                }
                writer.startElement("link", null);
                if (icon.endsWith(".ico")) {
                    writer.writeAttribute("rel", "shortcut icon", false);
                    writer.writeAttribute("href", icon, false);
                } else {
                    writer.writeAttribute("rel", "icon", false);
                    writer.writeAttribute("type", MimeTypeUtils.getMimeTypeForFile((String)icon), false);
                    writer.writeAttribute("href", icon, false);
                }
                writer.endElement("link");
            }
            if ((styleBlocks = FacesContextUtils.getStyleBlocks((FacesContext)facesContext)).size() > 0) {
                writer.startElement("style", null);
                writer.flush();
                for (String cssBlock : styleBlocks) {
                    writer.write(cssBlock);
                }
                writer.endElement("style");
            }
            if (debugMode) {
                boolean hideClientLogging = true;
                String severity = (String)facesContext.getExternalContext().getRequestMap().get(CLIENT_DEBUG_SEVERITY);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("get clientDebugSeverity = " + severity);
                }
                if (severity != null) {
                    try {
                        int index = severity.indexOf(59);
                        if (index == -1) {
                            index = severity.length();
                        }
                        clientLogSeverity = Integer.parseInt(severity.substring(0, index));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    hideClientLogging = !severity.contains("show");
                }
                FacesContextUtils.addOnloadScript((FacesContext)facesContext, (int)0, (String)("new LOG.LogArea({hide: " + hideClientLogging + "});"));
            }
            for (String scriptFile : theme.getScriptResources(productionMode)) {
                this.encodeScript(facesContext, writer, scriptFile);
            }
            for (String scriptFile : FacesContextUtils.getScriptFiles((FacesContext)facesContext)) {
                this.encodeScript(facesContext, writer, scriptFile);
            }
            if (!productionMode) {
                this.checkDuplicates(theme.getScriptResources(productionMode), FacesContextUtils.getScriptFiles((FacesContext)facesContext));
            }
            if ((focusId = page.getFocusId()) != null) {
                writer.startJavascript();
                writer.write("Tobago.focusId = '");
                writer.write(focusId);
                writer.write("';");
                writer.endJavascript();
            }
            if (component.getFacets().containsKey("action") && (command = component.getFacet("action")) != null && command.isRendered()) {
                int duration = ComponentUtils.getIntAttribute((UIComponent)command, (String)"delay", (int)100);
                boolean transition = ComponentUtils.getBooleanAttribute((UIComponent)command, (String)"transition");
                String target = ComponentUtils.getStringAttribute((UIComponent)command, (String)"target");
                String action = HtmlRendererUtils.createSubmitAction((String)command.getClientId(facesContext), (boolean)transition, (String)target, null);
                FacesContextUtils.addOnloadScript((FacesContext)facesContext, (String)("setTimeout(\"" + action + "\", " + duration + ");\n"));
            }
            boolean bl = calculateScrollbarWeight = client.getVerticalScrollbarWeight() == null || client.getHorizontalScrollbarWeight() == null;
            if (calculateScrollbarWeight) {
                FacesContextUtils.addOnloadScript((FacesContext)facesContext, (String)("Tobago.calculateScrollbarWeights('" + clientId + "::" + "scrollbarWeight" + "');"));
            } else {
                FacesContextUtils.addOnloadScript((FacesContext)facesContext, (String)("Tobago.Config.set('Tobago', 'verticalScrollbarWeight', '" + client.getVerticalScrollbarWeight().getPixel() + "');"));
                FacesContextUtils.addOnloadScript((FacesContext)facesContext, (String)("Tobago.Config.set('Tobago', 'horizontalScrollbarWeight', '" + client.getHorizontalScrollbarWeight().getPixel() + "');"));
            }
            command = null;
            if (component.getFacets().containsKey("resizeAction")) {
                Deprecation.LOG.warn("Please use 'resize' instead of 'resizeAction' as facet.");
                UIComponent facet = component.getFacet("resizeAction");
                if (facet instanceof UICommand) {
                    command = facet;
                } else if (facet instanceof UIForm && facet.getChildCount() == 1) {
                    Deprecation.LOG.warn("Please don't use a form, but a command with immediate=true instead.");
                    command = (UIComponent)facet.getChildren().get(0);
                }
            }
            if (component.getFacets().containsKey("resize")) {
                UIComponent facet = component.getFacet("resize");
                if (facet instanceof UICommand) {
                    command = facet;
                } else if (facet instanceof UIForm && facet.getChildCount() == 1) {
                    Deprecation.LOG.warn("Please don't use a form, but a command with immediate=true instead.");
                    command = (UIComponent)facet.getChildren().get(0);
                }
            }
            if (command != null && command.isRendered() && !(helper = new CommandRendererHelper(facesContext, (AbstractUICommandBase)command)).isDisabled()) {
                writer.writeJavascript("Tobago.resizeAction = function() {\n" + helper.getOnclick() + "\n};\n");
            }
            writer.startJavascript();
            this.writeEventFunction(writer, FacesContextUtils.getOnloadScripts((FacesContext)facesContext), "load", false);
            this.writeEventFunction(writer, FacesContextUtils.getOnunloadScripts((FacesContext)facesContext), "unload", false);
            this.writeEventFunction(writer, FacesContextUtils.getOnexitScripts((FacesContext)facesContext), "exit", false);
            this.writeEventFunction(writer, FacesContextUtils.getOnsubmitScripts((FacesContext)facesContext), "submit", true);
            int debugCounter = 0;
            for (String scriptBlock : FacesContextUtils.getScriptBlocks((FacesContext)facesContext)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("write scriptblock " + ++debugCounter + " :\n" + scriptBlock);
                }
                writer.write(scriptBlock);
                writer.write(10);
            }
            writer.endJavascript();
            writer.endElement("head");
        }
        String defaultActionId = page.getDefaultActionId() != null ? page.getDefaultActionId() : "";
        writer.startElement("body", (UIComponent)page);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(Classes.create((UIComponent)page));
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)page);
        writer.startJavascript();
        writer.write("Tobago.pngFixBlankImage = '");
        writer.write(ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)"image/blank.gif"));
        writer.write("';\n");
        writer.write("Tobago.OVERLAY_BACKGROUND = '");
        writer.write(ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)"image/tobago-overlay-background.png"));
        writer.write("';\n");
        writer.endJavascript();
        if (debugMode) {
            writer.writeJavascript("TbgTimer.startBody = new Date();");
        }
        writer.startElement("form", (UIComponent)page);
        writer.writeAttribute("action", formAction, true);
        writer.writeIdAttribute(page.getFormId(facesContext));
        writer.writeAttribute("method", this.getMethod(page), false);
        String enctype = FacesContextUtils.getEnctype((FacesContext)facesContext);
        if (enctype != null) {
            writer.writeAttribute("enctype", enctype, false);
        }
        writer.writeAttribute("accept-charset", "utf-8", false);
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId + "::" + "form-action");
        writer.writeIdAttribute(clientId + "::" + "form-action");
        writer.writeAttribute("value", defaultActionId, true);
        writer.endElement("input");
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId + "::" + "context-path");
        writer.writeIdAttribute(clientId + "::" + "context-path");
        writer.writeAttribute("value", facesContext.getExternalContext().getRequestContextPath(), true);
        writer.endElement("input");
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(clientId + "::" + "action-position");
        writer.writeIdAttribute(clientId + "::" + "action-position");
        writer.endElement("input");
        if (calculateScrollbarWeight) {
            writer.startElement("div", null);
            writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"scrollbarWeight", (Markup)Markup.NULL));
            writer.startElement("div", null);
            writer.endElement("div");
            writer.endElement("div");
            writer.startElement("input", null);
            writer.writeAttribute("type", "hidden", false);
            writer.writeNameAttribute(clientId + "::" + "scrollbarWeight");
            writer.writeIdAttribute(clientId + "::" + "scrollbarWeight");
            writer.endElement("input");
        }
        if (TobagoConfig.getInstance((FacesContext)FacesContext.getCurrentInstance()).isCheckSessionSecret()) {
            Secret.encode((FacesContext)facesContext, (TobagoResponseWriter)writer);
        }
        if (debugMode) {
            writer.startElement("input", null);
            writer.writeAttribute("value", clientLogSeverity);
            writer.writeAttribute("id", clientId + "::" + "clientSeverity", false);
            writer.writeAttribute("name", clientId + "::" + "clientSeverity", false);
            writer.writeAttribute("type", "hidden", false);
            writer.endElement("input");
        }
        if (component.getFacet("backButtonDetector") != null) {
            UIComponent hidden = component.getFacet("backButtonDetector");
            RenderUtils.encode((FacesContext)facesContext, (UIComponent)hidden);
        }
        if ((lastFocusId = (String)component.getAttributes().get(LAST_FOCUS_ID)) != null) {
            writer.writeJavascript("Tobago.lastFocusId = '" + lastFocusId + "';");
            component.getAttributes().remove(LAST_FOCUS_ID);
        }
        if ((menuBar = (UIMenuBar)page.getFacet("menuBar")) != null) {
            menuBar.getAttributes().put("pageMenu", Boolean.TRUE);
            RenderUtils.encode((FacesContext)facesContext, (UIComponent)menuBar);
        }
        writer.startElement("div", (UIComponent)page);
        writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"content"));
        writer.writeIdAttribute(clientId + "::" + "content");
        Style style = new Style(facesContext, (LayoutBase)page);
        Measure border = this.getBorderBottom(facesContext, (Configurable)page);
        style.setHeight(page.getCurrentHeight().subtract(border));
        style.setTop(border);
        writer.writeStyleAttribute(style);
    }

    private void checkDuplicates(String[] resources, Collection<String> files) {
        for (String resource : resources) {
            if (!files.contains(resource)) continue;
            throw new RuntimeException("The resource '" + resource + "' will be included twice! " + "The resource is in the theme list, and explicit in the page. " + "Please remove it from the page!");
        }
    }

    private void writeStyle(FacesContext facesContext, TobagoResponseWriter writer, String styleFile) throws IOException {
        List styles = ResourceManagerUtils.getStyles((FacesContext)facesContext, (String)styleFile);
        for (String styleString : styles) {
            if (styleString.length() <= 0) continue;
            writer.startElement("link", null);
            writer.writeAttribute("rel", "stylesheet", false);
            writer.writeAttribute("href", styleString, false);
            writer.writeAttribute("type", "text/css", false);
            writer.endElement("link");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        List messageClientIds;
        UIPopup[] popupArray;
        UIPage page = (UIPage)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        writer.endElement("div");
        for (UIPopup popup : popupArray = FacesContextUtils.getPopups((FacesContext)facesContext).toArray(new UIPopup[FacesContextUtils.getPopups((FacesContext)facesContext).size()])) {
            RenderUtils.encode((FacesContext)facesContext, (UIComponent)popup);
        }
        String clientId = page.getClientId(facesContext);
        boolean debugMode = VariableResolverUtils.resolveClientProperties((FacesContext)facesContext).isDebugMode();
        if (VariableResolverUtils.resolveClientProperties((FacesContext)facesContext).getUserAgent().isMsie()) {
            writer.startElement("input", null);
            writer.writeAttribute("type", "text", false);
            writer.writeAttribute("name", "tobago.dummy", false);
            writer.writeAttribute("tabindex", "-1", false);
            writer.writeAttribute("style", "visibility:hidden;display:none;", false);
            writer.endElement("input");
        }
        if ((messageClientIds = AjaxInternalUtils.getMessagesClientIds((FacesContext)facesContext)) != null) {
            writer.startElement("input", null);
            writer.writeAttribute("value", StringUtils.join((Collection)messageClientIds, (char)','), true);
            writer.writeAttribute("id", clientId + "::" + "messagesClientIds", false);
            writer.writeAttribute("name", clientId + "::" + "messagesClientIds", false);
            writer.writeAttribute("type", "hidden", false);
            writer.endElement("input");
        }
        writer.startElement("div", (UIComponent)page);
        writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"menuStore"));
        writer.endElement("div");
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        writer.startElement("span", null);
        writer.writeIdAttribute(clientId + "::" + "jsf-state-container");
        writer.flush();
        if (!FacesContextUtils.isAjax((FacesContext)facesContext)) {
            if (FacesVersion.supports12()) {
                viewHandler.writeState(facesContext);
            } else {
                FastStringWriter buffer = new FastStringWriter(40);
                TobagoResponseWriter originalWriter = (TobagoResponseWriter)facesContext.getResponseWriter();
                writer = (TobagoResponseWriter)writer.cloneWithWriter((Writer)buffer);
                facesContext.setResponseWriter((ResponseWriter)writer);
                viewHandler.writeState(facesContext);
                String stateContent = buffer.toString();
                writer = originalWriter;
                facesContext.setResponseWriter((ResponseWriter)writer);
                if (StringUtils.isBlank((String)stateContent)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Writing state will not happen! So we write the hidden field manually.");
                    }
                    writer.startElement("input", null);
                    writer.writeAttribute("type", "hidden", false);
                    writer.writeAttribute("name", "javax.faces.ViewState", false);
                    writer.writeAttribute("id", "javax.faces.ViewState", false);
                    writer.writeAttribute("value", "workaround", false);
                    writer.endElement("input");
                } else {
                    writer.write(stateContent);
                }
            }
        }
        writer.endElement("span");
        writer.endElement("form");
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"overlayWaitPreloadedImage"));
        String wait = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)"image/tobago-overlay-wait.gif");
        writer.writeAttribute("src", wait, false);
        writer.endElement("img");
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"overlayErrorPreloadedImage"));
        String error = ClientProperties.getInstance((FacesContext)facesContext).getUserAgent().isMsie6() ? ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)"image/remove.gif") : ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)"image/dialog-error.png");
        writer.writeAttribute("src", error, false);
        writer.endElement("img");
        if (debugMode) {
            ArrayList<String> logMessages = new ArrayList<String>();
            Iterator ids = facesContext.getClientIdsWithMessages();
            while (ids.hasNext()) {
                String id = (String)ids.next();
                Iterator messages = facesContext.getMessages(id);
                while (messages.hasNext()) {
                    FacesMessage message = (FacesMessage)messages.next();
                    logMessages.add(this.errorMessageForDebugging(id, message));
                }
            }
            if (!logMessages.isEmpty()) {
                logMessages.add(0, "LOG.show();");
            }
            HtmlRendererUtils.writeScriptLoader((FacesContext)facesContext, null, (String[])logMessages.toArray(new String[logMessages.size()]));
        }
        if (debugMode) {
            writer.writeJavascript("TbgTimer.endBody = new Date();");
        }
        writer.startElement("noscript", null);
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)page, (String)"noscript"));
        writer.writeText(ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"pageNoscript"));
        writer.endElement("div");
        writer.endElement("noscript");
        writer.endElement("body");
        if (LOG.isDebugEnabled()) {
            LOG.debug("unused AccessKeys    : " + AccessKeyMap.getUnusedKeys((FacesContext)facesContext));
            LOG.debug("duplicated AccessKeys: " + AccessKeyMap.getDublicatedKeys((FacesContext)facesContext));
        }
        if (facesContext.getExternalContext().getRequestParameterMap().get("X") != null) {
            throw new RuntimeException("Debugging activated via X parameter");
        }
    }

    private void writeEventFunction(TobagoResponseWriter writer, Collection<String> eventFunctions, String event, boolean returnBoolean) throws IOException {
        if (!eventFunctions.isEmpty()) {
            writer.write("Tobago.applicationOn");
            writer.write(event);
            writer.write(" = function() {\n");
            if (returnBoolean) {
                writer.write("  var result;\n");
            }
            for (String function : eventFunctions) {
                if (returnBoolean) {
                    writer.write("  result = ");
                } else {
                    writer.write("  ");
                }
                writer.write(function);
                if (!function.trim().endsWith(";")) {
                    writer.write(";\n");
                } else {
                    writer.write("\n");
                }
                if (!returnBoolean) continue;
                writer.write("  if (typeof result == \"boolean\" && ! result) {\n");
                writer.write("    return false;\n");
                writer.write("  }\n");
            }
            writer.write("\n  return true;\n}\n");
        }
    }

    private void encodeScript(FacesContext facesContext, TobagoResponseWriter writer, String script) throws IOException {
        List<String> list;
        if (ResourceManagerUtils.isAbsoluteResource((String)script)) {
            list = new ArrayList();
            list.add(script);
        } else {
            list = ResourceManagerUtils.getScripts((FacesContext)facesContext, (String)script);
        }
        for (String src : list) {
            if (!StringUtils.isNotBlank((String)src)) continue;
            writer.startElement("script", null);
            writer.writeAttribute("src", src, true);
            writer.writeAttribute("type", "text/javascript", false);
            writer.endElement("script");
        }
    }

    private void errorMessageForDebugging(String id, FacesMessage message, ResponseWriter writer) throws IOException {
        writer.startElement("div", null);
        writer.writeAttribute("style", (Object)"color: red", null);
        writer.flush();
        writer.write("[");
        writer.write(id != null ? id : "null");
        writer.write("]");
        writer.write("[");
        writer.write(message.getSummary() == null ? "null" : message.getSummary());
        writer.write("/");
        writer.write(message.getDetail() == null ? "null" : message.getDetail());
        writer.write("]");
        writer.endElement("div");
        writer.startElement("br", null);
        writer.endElement("br");
    }

    private String errorMessageForDebugging(String id, FacesMessage message) {
        StringBuilder sb = new StringBuilder("LOG.info(\"FacesMessage: [");
        sb.append(id != null ? id : "null");
        sb.append("][");
        sb.append(message.getSummary() == null ? "null" : this.escape(message.getSummary()));
        sb.append("/");
        sb.append(message.getDetail() == null ? "null" : this.escape(message.getDetail()));
        sb.append("]\");");
        return sb.toString();
    }

    private String escape(String s) {
        return StringUtils.replace((String)StringUtils.replace((String)s, (String)"\\", (String)"\\\\"), (String)"\"", (String)"\\\"");
    }

    private String getMethod(UIPage page) {
        String method = (String)page.getAttributes().get("method");
        return method == null ? "post" : method;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public Measure getBorderBottom(FacesContext facesContext, Configurable component) {
        UIPage page = (UIPage)component;
        UIMenuBar menuBar = (UIMenuBar)page.getFacet("menuBar");
        if (menuBar != null) {
            return this.getResourceManager().getThemeMeasure(facesContext, (Configurable)page, "custom.menuBar-height");
        }
        return Measure.ZERO;
    }

    public Measure getWidth(FacesContext facesContext, Configurable component) {
        Measure width = ClientProperties.getInstance((FacesContext)facesContext).getPageWidth();
        if (width != null) {
            return width;
        }
        return super.getWidth(facesContext, component);
    }

    public Measure getHeight(FacesContext facesContext, Configurable component) {
        Measure height = ClientProperties.getInstance((FacesContext)facesContext).getPageHeight();
        if (height != null) {
            return height;
        }
        return super.getHeight(facesContext, component);
    }
}

