/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.UIMenuCommand;
import org.apache.myfaces.tobago.component.UISelectBooleanCheckbox;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUICommandBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyMap;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.CommandRendererHelper;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.JQueryUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuCommandRenderer
extends CommandRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(MenuCommandRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UIMenuCommand menu = (UIMenuCommand)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        boolean disabled = menu.isDisabled();
        boolean firstLevel = "MenuBar".equals(menu.getParent().getRendererType());
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)menu);
        String clientId = menu.getClientId(facesContext);
        String submit = HtmlRendererUtils.createSubmitAction((String)clientId, (boolean)true, null, null);
        if (menu.getFacet("checkbox") != null) {
            UISelectBooleanCheckbox checkbox = (UISelectBooleanCheckbox)menu.getFacet("checkbox");
            boolean checked = ComponentUtils.getBooleanAttribute((UIComponent)checkbox, (String)"value");
            String image = checked ? "image/MenuCheckmark.gif" : null;
            String hiddenId = checkbox.getClientId(facesContext);
            String setValue = JQueryUtils.selectId((String)hiddenId) + ".each(function(){jQuery(this).val(jQuery(this).val() == 'true' ? 'false' : 'true')}); ";
            this.encodeItem(facesContext, writer, menu, label, setValue + submit, disabled, firstLevel, image);
            this.encodeHidden(writer, hiddenId, checked);
        } else if (menu.getFacet("radio") != null) {
            UISelectOne radio = (UISelectOne)menu.getFacet("radio");
            List items = RenderUtils.getSelectItems((UIComponent)radio);
            String hiddenId = radio.getClientId(facesContext);
            for (SelectItem item : items) {
                boolean checked = item.getValue().equals(radio.getValue());
                String image = checked ? "image/MenuRadioChecked.gif" : null;
                String labelText = item.getLabel();
                label.reset();
                if (labelText != null) {
                    if (labelText.indexOf(95) > -1) {
                        label.setup(labelText);
                    } else {
                        label.setText(labelText);
                    }
                } else {
                    LOG.warn("Menu item has label=null where clientId=" + clientId);
                }
                String formattedValue = RenderUtils.getFormattedValue((FacesContext)facesContext, (UIComponent)radio, (Object)item.getValue());
                String setValue = JQueryUtils.selectId((String)hiddenId) + ".val('" + JQueryUtils.escapeValue((String)formattedValue) + "'); ";
                this.encodeItem(facesContext, writer, null, label, setValue + submit, disabled, firstLevel, image);
            }
            this.encodeHidden(writer, hiddenId, this.getCurrentValue(facesContext, (UIComponent)radio));
        } else {
            CommandRendererHelper helper = new CommandRendererHelper(facesContext, (AbstractUICommandBase)menu);
            String onclick = helper.getOnclick();
            String image = menu.getImage();
            this.encodeItem(facesContext, writer, menu, label, onclick != null ? onclick : submit, disabled, firstLevel, image);
        }
    }

    private void encodeHidden(TobagoResponseWriter writer, String hiddenId, Object value) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeIdAttribute(hiddenId);
        writer.writeNameAttribute(hiddenId);
        if (value != null) {
            writer.writeAttribute("value", value.toString(), true);
        }
        writer.endElement("input");
    }

    private void encodeItem(FacesContext facesContext, TobagoResponseWriter writer, UIMenuCommand component, LabelWithAccessKey label, String onclick, boolean disabled, boolean firstLevel, String image) throws IOException {
        writer.startElement("li", null);
        if (component != null) {
            writer.writeIdAttribute(component.getClientId(facesContext));
        }
        Markup markup = null;
        if (component != null) {
            markup = component.getCurrentMarkup();
            if (firstLevel) {
                markup = Markup.TOP.add(markup);
            }
        }
        writer.writeClassAttribute(Classes.createWorkaround((String)"menu", (Markup)markup));
        writer.writeAttribute("onclick", onclick, true);
        if (component != null) {
            HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)component);
        }
        if (image != null) {
            if (firstLevel) {
                Style iconStyle = new Style();
                iconStyle.setLeft(Measure.valueOf((int)0));
                iconStyle.setTop(Measure.valueOf((int)0));
                iconStyle.setHeight(Measure.valueOf((int)16));
                iconStyle.setWidth(Measure.valueOf((int)16));
                writer.startElement("img", null);
                String imageWithPath = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)image, (boolean)true);
                writer.writeAttribute("src", imageWithPath, false);
                String imageHover = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)HtmlRendererUtils.createSrc((String)image, (String)"Hover"), (boolean)true);
                if (imageHover != null) {
                    writer.writeAttribute("data-tobago-srcdefault", imageWithPath, false);
                    writer.writeAttribute("data-tobago-srchover", imageHover, false);
                }
                writer.writeAttribute("alt", label.getText(), true);
                writer.writeStyleAttribute(iconStyle);
                writer.endElement("img");
            } else {
                Style style = new Style();
                style.setBackgroundImage("url(" + ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)image) + ")");
                writer.writeStyleAttribute(style);
            }
        }
        writer.startElement("a", null);
        writer.writeAttribute("href", "#", false);
        if (image != null && firstLevel) {
            writer.writeStyleAttribute("vertical-align:top");
        }
        if (label.getText() != null) {
            if (label.getAccessKey() != null) {
                if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                    LOG.info("duplicated accessKey : " + label.getAccessKey());
                }
                if (!disabled && component != null) {
                    HtmlRendererUtils.addAcceleratorKey((FacesContext)facesContext, (UIComponent)component, (Character)label.getAccessKey());
                }
            }
            HtmlRendererUtils.writeLabelWithAccessKey((TobagoResponseWriter)writer, (LabelWithAccessKey)label);
        }
        writer.endElement("a");
        writer.endElement("li");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

