/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UILabel;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.util.AccessKeyMap;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(LabelRenderer.class);

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        ComponentUtils.evaluateAutoFor((UIComponent)component, UIInput.class);
        UILabel label = (UILabel)component;
        UIComponent corresponding = ComponentUtils.findFor((UIComponent)label);
        if (corresponding != null) {
            Markup markup = label.getCurrentMarkup();
            markup = ComponentUtils.updateMarkup((UIComponent)corresponding, (Markup)markup);
            label.setCurrentMarkup(markup);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UILabel label = (UILabel)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        String forValue = ComponentUtils.findClientIdFor((UIComponent)label, (FacesContext)facesContext);
        String clientId = label.getClientId(facesContext);
        writer.startElement("label", (UIComponent)label);
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)label);
        HtmlRendererUtils.renderDojoDndItem((UIComponent)label, (TobagoResponseWriter)writer, (boolean)true);
        Classes classes = Classes.create((UIComponent)label);
        writer.writeClassAttribute(classes);
        writer.writeStyleAttribute(new Style(facesContext, (LayoutBase)label));
        writer.writeIdAttribute(clientId);
        if (forValue != null) {
            writer.writeAttribute("for", forValue, false);
        }
        HtmlRendererUtils.renderTip((UIComponent)label, (TobagoResponseWriter)writer);
        this.encodeTextContent(facesContext, writer, label);
        writer.endElement("label");
    }

    protected void encodeTextContent(FacesContext facesContext, TobagoResponseWriter writer, UILabel label) throws IOException {
        String clientId = label.getClientId(facesContext);
        LabelWithAccessKey key = new LabelWithAccessKey((UIComponent)label);
        if (key.getText() != null) {
            HtmlRendererUtils.writeLabelWithAccessKey((TobagoResponseWriter)writer, (LabelWithAccessKey)key);
        }
        if (key.getAccessKey() != null) {
            if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)key.getAccessKey())) {
                LOG.info("Duplicated accessKey : " + key.getAccessKey());
            }
            HtmlRendererUtils.addClickAcceleratorKey((FacesContext)facesContext, (String)clientId, (char)key.getAccessKey().charValue());
        }
    }
}

