/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUIImage;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(ImageRenderer.class);

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        HtmlRendererUtils.renderDojoDndSource((FacesContext)facesContext, (UIComponent)component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String alt;
        String border;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        AbstractUIImage image = (AbstractUIImage)component;
        String value = image.getUrl();
        String src = value;
        if (src != null && !ResourceManagerUtils.isAbsoluteResource((String)src)) {
            src = null;
            if (this.isDisabled(image)) {
                src = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)HtmlRendererUtils.createSrc((String)value, (String)"Disabled"), (boolean)true);
            }
            if (src == null) {
                src = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)value);
            }
        }
        if ((border = (String)image.getAttributes().get("border")) == null) {
            border = "0";
        }
        if ((alt = (String)image.getAttributes().get("alt")) == null) {
            alt = "";
        }
        writer.startElement("img", (UIComponent)image);
        String clientId = image.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)image);
        if (src != null) {
            writer.writeAttribute("src", src, true);
        }
        writer.writeAttribute("alt", alt, true);
        HtmlRendererUtils.renderTip((UIComponent)image, (TobagoResponseWriter)writer);
        writer.writeAttribute("border", border, false);
        Style style = new Style(facesContext, (LayoutBase)image);
        writer.writeStyleAttribute(style);
        HtmlRendererUtils.renderDojoDndItem((UIComponent)image, (TobagoResponseWriter)writer, (boolean)true);
        writer.writeClassAttribute(Classes.create((UIComponent)image));
        writer.endElement("img");
    }

    private String createSrc(String src, String ext) {
        int dot = src.lastIndexOf(46);
        if (dot == -1) {
            LOG.warn("Image src without extension: '" + src + "'");
            return src;
        }
        return src.substring(0, dot) + ext + src.substring(dot);
    }

    private boolean isDisabled(AbstractUIImage graphic) {
        return graphic.isDisabled() || graphic.getParent() instanceof UICommand && ((UICommand)graphic.getParent()).isDisabled();
    }
}

