/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UICalendar;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.model.CalendarModel;
import org.apache.myfaces.tobago.model.DateModel;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(CalendarRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Calendar calendar;
        UICalendar output = (UICalendar)component;
        String id = output.getClientId(facesContext);
        String dateTextBoxId = (String)component.getAttributes().get("dateInputId");
        if (LOG.isDebugEnabled()) {
            LOG.debug("dateTextBoxId = '" + dateTextBoxId + "'");
        }
        Locale locale = facesContext.getViewRoot().getLocale();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMMM yyyy", locale);
        Object value = output.getValue();
        if (value instanceof Calendar) {
            calendar = (Calendar)value;
        } else {
            calendar = new GregorianCalendar();
            if (value instanceof Date) {
                calendar.setTime((Date)value);
            }
        }
        CalendarModel model = new CalendarModel(calendar);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("div", component);
        writer.writeIdAttribute(id);
        writer.writeClassAttribute(Classes.create((UIComponent)output));
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)component);
        Style style = new Style(facesContext, (LayoutBase)output);
        writer.writeStyleAttribute(style);
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"row"));
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"header"));
        writer.writeAttribute("alt", "", false);
        writer.writeAttribute("src", ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)"image/calendarFastPrev.gif"), false);
        writer.writeAttribute("onclick", "addMonth('" + id + "', -12)", false);
        writer.endElement("img");
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"header"));
        writer.writeAttribute("alt", "", false);
        writer.writeAttribute("src", ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)"image/calendarPrev.gif"), false);
        writer.writeAttribute("onclick", "addMonth('" + id + "', -1)", false);
        writer.endElement("img");
        writer.startElement("span", null);
        writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"header"));
        writer.writeIdAttribute(id + ":title");
        writer.writeText(dateFormat.format(calendar.getTime()));
        writer.endElement("span");
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"header"));
        writer.writeAttribute("alt", "", false);
        writer.writeAttribute("src", ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)"image/calendarNext.gif"), false);
        writer.writeAttribute("onclick", "addMonth('" + id + "', 1)", false);
        writer.endElement("img");
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"header"));
        writer.writeAttribute("alt", "", false);
        writer.writeAttribute("src", ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)"image/calendarFastNext.gif"), false);
        writer.writeAttribute("onclick", "addMonth('" + id + "', 12)", false);
        writer.endElement("img");
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"row"));
        dateFormat = new SimpleDateFormat("E", locale);
        for (int dayIt = 0; dayIt < 7; ++dayIt) {
            DateModel date = model.getDate(0, dayIt);
            String dayName = dateFormat.format(date.getCalendar().getTime());
            dayName = StringUtils.substring((String)dayName, (int)0, (int)2);
            writer.startElement("span", null);
            writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"dayOfWeek"));
            writer.writeText(dayName);
            writer.endElement("span");
        }
        writer.endElement("div");
        for (int week = 0; week < 6; ++week) {
            writer.startElement("div", null);
            writer.writeIdAttribute(id + ":" + week);
            writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"row"));
            for (int dayIt = 0; dayIt < 7; ++dayIt) {
                DateModel date = model.getDate(week, dayIt);
                String dayDescription = String.valueOf(date.getDay());
                String onclick = "selectDay('" + id + "', " + week + " , " + dayIt + ");";
                writer.startElement("span", null);
                writer.writeAttribute("onclick", onclick, true);
                writer.writeIdAttribute(id + ":" + week + ":" + dayIt);
                writer.writeClassAttribute(Classes.create((UIComponent)output, (String)"day", (Markup)(date.getMonth() == model.getMonth() ? null : Markup.DISABLED)));
                writer.writeText(dayDescription);
                writer.endElement("span");
            }
            writer.endElement("div");
        }
        writer.endElement("div");
        this.writeInputHidden(writer, "/" + id + "/year", id + ":year", Integer.toString(calendar.get(1)));
        this.writeInputHidden(writer, "/" + id + "/month", id + ":month", Integer.toString(1 + calendar.get(2)));
        this.writeInputHidden(writer, "/" + id + "/day", id + ":day", Integer.toString(calendar.get(5)));
        this.writeInputHidden(writer, id + ":firstDayOfWeek", Integer.toString(calendar.getFirstDayOfWeek()));
        this.writeInputHidden(writer, id + ":monthNames", this.getMonthNames(locale));
        this.writeInputHidden(writer, id + ":fieldId", "");
        String[] cmd = new String[]{"document.calendar = new Object();", dateTextBoxId != null ? "initCalendarParse('" + id + "', '" + dateTextBoxId + "');" : ""};
        HtmlRendererUtils.writeScriptLoader((FacesContext)facesContext, null, (String[])cmd);
    }

    private void writeInputHidden(TobagoResponseWriter writer, String id, String value) throws IOException {
        this.writeInputHidden(writer, null, id, value);
    }

    private void writeInputHidden(TobagoResponseWriter writer, String name, String id, String value) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        if (name != null) {
            writer.writeNameAttribute(name);
        }
        writer.writeIdAttribute(id);
        writer.writeAttribute("value", value, true);
        writer.endElement("input");
    }

    private String getMonthNames(Locale locale) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMMM", locale);
        StringBuilder buffer = new StringBuilder(64);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2000, 0, 1);
        for (int month = 0; month < 12; ++month) {
            if (month > 0) {
                buffer.append(',');
            }
            buffer.append(dateFormat.format(calendar.getTime()));
            calendar.add(2, 1);
        }
        return buffer.toString();
    }
}

