/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.LegacyValueBinding;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.apache.myfaces.tobago.compat.FacesUtils;
import org.apache.myfaces.tobago.event.TabChangeListener;
import org.apache.myfaces.tobago.event.TabChangeSource;
import org.apache.myfaces.tobago.util.FacesVersion;

public class TabChangeListenerHandler
extends TagHandler {
    private Class listenerType;
    private final TagAttribute type;
    private final TagAttribute binding = this.getAttribute("binding");

    public TabChangeListenerHandler(TagConfig config) {
        super(config);
        this.type = this.getAttribute("type");
        if (this.type != null) {
            if (!this.type.isLiteral()) {
                throw new TagAttributeException(this.tag, this.type, "Must be literal");
            }
            try {
                this.listenerType = Class.forName(this.type.getValue());
            }
            catch (Exception e) {
                throw new TagAttributeException(this.tag, this.type, (Throwable)e);
            }
        }
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws IOException, FacesException, ELException {
        if (parent instanceof TabChangeSource) {
            if (parent.getParent() == null) {
                TabChangeSource changeSource = (TabChangeSource)parent;
                TabChangeListener listener = null;
                ValueExpression valueExpression = null;
                if (this.binding != null) {
                    valueExpression = this.binding.getValueExpression(faceletContext, TabChangeListener.class);
                    listener = (TabChangeListener)valueExpression.getValue((ELContext)faceletContext);
                }
                if (listener == null) {
                    try {
                        listener = (TabChangeListener)this.listenerType.newInstance();
                    }
                    catch (Exception e) {
                        throw new TagAttributeException(this.tag, this.type, e.getCause());
                    }
                    if (valueExpression != null) {
                        valueExpression.setValue((ELContext)faceletContext, (Object)listener);
                    }
                }
                if (valueExpression != null) {
                    if (FacesVersion.supports12()) {
                        FacesUtils.addBindingOrExpressionTabChangeListener((TabChangeSource)changeSource, (String)this.type.getValue(), (Object)valueExpression);
                    } else {
                        FacesUtils.addBindingOrExpressionTabChangeListener((TabChangeSource)changeSource, (String)this.type.getValue(), (Object)new LegacyValueBinding(valueExpression));
                    }
                } else {
                    changeSource.addTabChangeListener(listener);
                }
            }
        } else {
            throw new TagException(this.tag, "Parent is not of type TabChangeSource, type is: " + parent);
        }
    }
}

