/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets;

import com.sun.facelets.impl.DefaultResourceResolver;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaInfResourcesClasspathResourceResolver
extends DefaultResourceResolver {
    private static final Logger LOG = LoggerFactory.getLogger((Class)MetaInfResourcesClasspathResourceResolver.class);

    public MetaInfResourcesClasspathResourceResolver() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("MetaInfResourcesClasspathResourceResolver is configured to resolve resources.");
        }
    }

    public URL resolveUrl(String path) {
        URL url = super.resolveUrl(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("default   url='" + url + "'");
        }
        if (url == null) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            path = "META-INF/resources/" + path;
            url = Thread.currentThread().getContextClassLoader().getResource(path);
            if (LOG.isDebugEnabled()) {
                LOG.debug("classpath url='" + url + "'");
            }
        }
        return url;
    }
}

