/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.event;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.event.AbstractResetInputActionListener;
import org.apache.myfaces.tobago.internal.util.FindComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueBindingResetInputActionListener
extends AbstractResetInputActionListener
implements StateHolder {
    private static final Logger LOG = LoggerFactory.getLogger(ValueBindingResetInputActionListener.class);
    private ValueBinding clientIdsBinding;

    public ValueBindingResetInputActionListener(Object binding) {
        this.clientIdsBinding = (ValueBinding)binding;
    }

    public void processAction(ActionEvent event) {
        String[] clientIds;
        Object obj = this.clientIdsBinding.getValue(FacesContext.getCurrentInstance());
        if (obj instanceof String[]) {
            clientIds = (String[])obj;
        } else if (obj instanceof String) {
            clientIds = StringUtils.split((String)((String)obj), (String)", ");
        } else {
            LOG.error("Ignore unknown value of " + obj + " for reset.");
            return;
        }
        for (String clientId : clientIds) {
            UIComponent component = FindComponentUtils.findComponent(event.getComponent(), clientId);
            if (component == null) continue;
            this.resetChildren(component);
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.clientIdsBinding = (ValueBinding)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[0]);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.clientIdsBinding)};
        return values;
    }

    public void setTransient(boolean newTransientValue) {
    }
}

