/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.compat;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.ActionSource;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.webapp.UIComponentTag;
import org.apache.myfaces.tobago.compat.FacesInvokeOnComponent12;
import org.apache.myfaces.tobago.compat.FacesUtilsEL;
import org.apache.myfaces.tobago.compat.InvokeOnComponent;
import org.apache.myfaces.tobago.event.TabChangeSource;
import org.apache.myfaces.tobago.event.ValueBindingPopupActionListener;
import org.apache.myfaces.tobago.event.ValueBindingResetInputActionListener;
import org.apache.myfaces.tobago.event.ValueBindingTabChangeListener;
import org.apache.myfaces.tobago.util.FacesVersion;
import org.apache.myfaces.tobago.util.ValueBindingComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FacesUtilsEL.class);
    public static final Class[] VALIDATOR_ARGS = new Class[]{FacesContext.class, UIComponent.class, Object.class};
    private static final boolean USE_BINDING = !FacesVersion.supports12();

    public static boolean invokeOnComponent(FacesContext context, UIComponent component, String clientId, ContextCallback callback) {
        String thisClientId = component.getClientId(context);
        if (USE_BINDING) {
            if (clientId.equals(thisClientId)) {
                callback.invokeContextCallback(context, component);
                return true;
            }
            return component instanceof NamingContainer ? clientId.startsWith(thisClientId) && clientId.charAt(thisClientId.length()) == ':' && FacesUtils.invokeOnComponentFacetsAndChildren(context, component, clientId, callback) : FacesUtils.invokeOnComponentFacetsAndChildren(context, component, clientId, callback);
        }
        return FacesInvokeOnComponent12.invokeOnComponent(context, component, clientId, callback);
    }

    private static boolean invokeOnComponentFacetsAndChildren(FacesContext context, UIComponent component, String clientId, ContextCallback callback) {
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (child instanceof InvokeOnComponent) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found InvokeOnComponent with clientId " + child.getClientId(context));
                }
                if (!((InvokeOnComponent)child).invokeOnComponent(context, clientId, callback)) continue;
                return true;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Did not found InvokeOnComponent " + child.getClass().getName() + " " + child.getClientId(context) + " " + child.getRendererType() + (child.getParent() != null ? child.getParent().getClass().getName() : "null"));
        }
        return false;
    }

    public static void invokeMethodBinding(FacesContext facesContext, MethodBinding methodBinding, FacesEvent event) {
        if (methodBinding != null && event != null) {
            try {
                methodBinding.invoke(facesContext, new Object[]{event});
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw e;
            }
        }
    }

    public static Object getValueFromValueBindingOrValueExpression(FacesContext context, UIComponent component, String name) {
        if (USE_BINDING) {
            return component.getValueBinding(name).getValue(context);
        }
        return FacesUtilsEL.getValueFromValueBindingOrValueExpression(context, component, name);
    }

    public static boolean hasValueBindingOrValueExpression(UIComponent component, String name) {
        if (USE_BINDING) {
            return component.getValueBinding(name) != null;
        }
        return FacesUtilsEL.hasValueBindingOrValueExpression(component, name);
    }

    public static boolean isReadonlyValueBindingOrValueExpression(FacesContext context, UIComponent component, String name) {
        if (USE_BINDING) {
            return component.getValueBinding(name).isReadOnly(context);
        }
        return FacesUtilsEL.isReadonlyValueBindingOrValueExpression(context, component, name);
    }

    public static String getExpressionString(UIComponent component, String name) {
        if (USE_BINDING) {
            return component.getValueBinding(name).getExpressionString();
        }
        return FacesUtilsEL.getExpressionString(component, name);
    }

    public static void setValueOfBindingOrExpression(FacesContext context, Object value, UIComponent component, String bindingName) {
        if (USE_BINDING) {
            ValueBinding vb = component.getValueBinding(bindingName);
            if (vb != null) {
                vb.setValue(context, value);
            }
        } else {
            FacesUtilsEL.setValueOfBindingOrExpression(context, value, component, bindingName);
        }
    }

    public static void setValueOfBindingOrExpression(FacesContext context, Object value, Object bindingOrExpression) {
        if (USE_BINDING) {
            if (bindingOrExpression instanceof ValueBinding) {
                ValueBinding vb = (ValueBinding)bindingOrExpression;
                vb.setValue(context, value);
            }
        } else {
            FacesUtilsEL.setValueOfBindingOrExpression(context, value, bindingOrExpression);
        }
    }

    public static void copyValueBindingOrValueExpression(UIComponent fromComponent, String fromName, UIComponent toComponent, String toName) {
        if (USE_BINDING) {
            ValueBinding vb = fromComponent.getValueBinding(fromName);
            if (vb != null) {
                toComponent.setValueBinding(toName, vb);
            }
        } else {
            FacesUtilsEL.copyValueBindingOrValueExpression(fromComponent, fromName, toComponent, toName);
        }
    }

    public static Object getValueFromBindingOrExpression(Object obj) {
        if (USE_BINDING) {
            if (obj instanceof ValueBinding) {
                return ((ValueBinding)obj).getValue(FacesContext.getCurrentInstance());
            }
        } else {
            return FacesUtilsEL.getValueFromBindingOrExpression(obj);
        }
        return null;
    }

    public static Object createExpressionOrBinding(String string) {
        if (USE_BINDING) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ValueBinding valueBinding = facesContext.getApplication().createValueBinding(string);
            return valueBinding;
        }
        return FacesUtilsEL.createExpressionOrBinding(string);
    }

    public static void setValidator(EditableValueHolder editableValueHolder, Object validator) {
        if (USE_BINDING) {
            MethodBinding methodBinding = FacesContext.getCurrentInstance().getApplication().createMethodBinding(validator.toString(), VALIDATOR_ARGS);
            editableValueHolder.setValidator(methodBinding);
        } else {
            FacesUtilsEL.setValidator(editableValueHolder, validator);
        }
    }

    public static void setConverter(ValueHolder valueHolder, Object converterExpression) {
        if (USE_BINDING) {
            if (converterExpression != null && converterExpression instanceof String) {
                String converterExpressionStr = (String)converterExpression;
                FacesContext context = FacesContext.getCurrentInstance();
                if (UIComponentTag.isValueReference((String)converterExpressionStr)) {
                    ValueBinding valueBinding = context.getApplication().createValueBinding(converterExpressionStr);
                    if (valueHolder instanceof UIComponent) {
                        ((UIComponent)valueHolder).setValueBinding("converter", valueBinding);
                    }
                } else {
                    Converter converter = context.getApplication().createConverter(converterExpressionStr);
                    valueHolder.setConverter(converter);
                }
            }
        } else {
            FacesUtilsEL.setConverter(valueHolder, converterExpression);
        }
    }

    public static void setBindingOrExpression(UIComponent component, String name, Object valueBindingOrExpression) {
        if (USE_BINDING) {
            component.setValueBinding(name, (ValueBinding)valueBindingOrExpression);
        } else {
            FacesUtilsEL.setBindingOrExpression(component, name, valueBindingOrExpression);
        }
    }

    public static void setBindingOrExpression(UIComponent component, String name, String valueBindingOrExpression) {
        FacesUtils.setBindingOrExpression(component, name, FacesUtils.createExpressionOrBinding(valueBindingOrExpression));
    }

    public static void addBindingOrExpressionTabChangeListener(TabChangeSource source, String type, Object bindingOrExpression) {
        if (USE_BINDING) {
            source.addTabChangeListener(new ValueBindingTabChangeListener(type, (ValueBinding)bindingOrExpression));
        } else {
            FacesUtilsEL.addBindingOrExpressionTabChangeListener(source, type, bindingOrExpression);
        }
    }

    public static Comparator getBindingOrExpressionComparator(FacesContext facesContext, UIComponent child, String var, boolean descending, Comparator comparator) {
        if (USE_BINDING) {
            ValueBinding valueBinding = child.getValueBinding("value");
            return new ValueBindingComparator(facesContext, var, valueBinding, descending, comparator);
        }
        return FacesUtilsEL.getBindingOrExpressionComparator(facesContext, child, var, descending, comparator);
    }

    public static void addBindingOrExpressionPopupActionListener(ActionSource actionSource, Object bindingOrExpression) {
        if (USE_BINDING) {
            actionSource.addActionListener((ActionListener)new ValueBindingPopupActionListener(bindingOrExpression));
        } else {
            FacesUtilsEL.addBindingOrExpressionPopupActionListener(actionSource, bindingOrExpression);
        }
    }

    public static void addBindingOrExpressionResetActionListener(ActionSource actionSource, Object bindingOrExpression) {
        if (USE_BINDING) {
            actionSource.addActionListener((ActionListener)new ValueBindingResetInputActionListener(bindingOrExpression));
        } else {
            FacesUtilsEL.addBindingOrExpressionResetActionListener(actionSource, bindingOrExpression);
        }
    }

    public static Map getFacesContextAttributes(FacesContext context) {
        if (FacesVersion.supports20()) {
            return context.getAttributes();
        }
        return context.getExternalContext().getRequestMap();
    }

    public static boolean supportsEL() {
        return !USE_BINDING;
    }
}

