/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.DebugUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RenderUtils.class);
    public static final String COMPONENT_IN_REQUEST = "org.apache.myfaces.tobago.component";

    private RenderUtils() {
    }

    public static boolean contains(Object[] list, Object value) {
        if (list == null) {
            return false;
        }
        for (Object aList : list) {
            if (aList == null || !aList.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static void encodeChildren(FacesContext facesContext, UIComponent panel) throws IOException {
        for (UIComponent child : panel.getChildren()) {
            RenderUtils.encode(facesContext, child);
        }
    }

    public static void encode(FacesContext facesContext, UIComponent component) throws IOException {
        RenderUtils.encode(facesContext, component, null);
    }

    public static void encode(FacesContext facesContext, UIComponent component, List<? extends Class<? extends UIComponent>> only) throws IOException {
        if (only != null && !RenderUtils.matchFilter(component, only)) {
            return;
        }
        if (component.isRendered()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("rendering " + component.getRendererType() + " " + component);
            }
            component.encodeBegin(facesContext);
            if (component.getRendersChildren()) {
                component.encodeChildren(facesContext);
            } else {
                for (Object o : component.getChildren()) {
                    UIComponent kid = (UIComponent)o;
                    RenderUtils.encode(facesContext, kid, only);
                }
            }
            component.encodeEnd(facesContext);
        }
    }

    private static boolean matchFilter(UIComponent component, List<? extends Class<? extends UIComponent>> only) {
        for (Class<? extends UIComponent> clazz : only) {
            if (!clazz.isAssignableFrom(component.getClass())) continue;
            return true;
        }
        return false;
    }

    public static void prepareRendererAll(FacesContext facesContext, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        RendererBase renderer = ComponentUtils.getRenderer((FacesContext)facesContext, (UIComponent)component);
        boolean prepareRendersChildren = false;
        if (renderer != null) {
            renderer.prepareRender(facesContext, component);
            prepareRendersChildren = renderer.getPrepareRendersChildren();
        }
        if (prepareRendersChildren) {
            renderer.prepareRendersChildren(facesContext, component);
        } else {
            Iterator it = component.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                RenderUtils.prepareRendererAll(facesContext, child);
            }
        }
    }

    public static String getFormattedValue(FacesContext facesContext, UIComponent component) {
        Object value = null;
        if (component instanceof ValueHolder && (value = ((ValueHolder)component).getLocalValue()) == null) {
            value = ((ValueHolder)component).getValue();
        }
        return RenderUtils.getFormattedValue(facesContext, component, value);
    }

    public static String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        if (currentValue == null) {
            return "";
        }
        if (!(component instanceof ValueHolder)) {
            return currentValue.toString();
        }
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter == null) {
            if (currentValue instanceof String) {
                return (String)currentValue;
            }
            Class<?> converterType = currentValue.getClass();
            converter = context.getApplication().createConverter(converterType);
        }
        if (converter == null) {
            return currentValue.toString();
        }
        return converter.getAsString(context, component, currentValue);
    }

    public static Measure calculateStringWidth(FacesContext facesContext, UIComponent component, String text) {
        return RenderUtils.calculateStringWidth(facesContext, (Configurable)component, text, "tobago.font.widths");
    }

    public static Measure calculateStringWidth2(FacesContext facesContext, UIComponent component, String text) {
        return RenderUtils.calculateStringWidth(facesContext, (Configurable)component, text, "tobago.font2.widths");
    }

    private static Measure calculateStringWidth(FacesContext facesContext, Configurable component, String text, String type) {
        if (text == null) {
            return Measure.ZERO;
        }
        int width = 0;
        int defaultCharWidth = 10;
        try {
            defaultCharWidth = ResourceManagerUtils.getThemeMeasure((FacesContext)facesContext, (Configurable)component, (String)"fontWidth").getPixel();
        }
        catch (NullPointerException e) {
            LOG.warn("no value for 'fontWidth' for type '" + component.getRendererType() + "' found in theme-config");
        }
        String fontWidths = ResourceManagerUtils.getProperty((FacesContext)facesContext, (String)"tobago", (String)type);
        for (char c : text.toCharArray()) {
            if (c >= ' ' && c < '\u0080') {
                int begin = (c - 32) * 2;
                width += Integer.parseInt(fontWidths.substring(begin, begin + 2), 16);
                continue;
            }
            width += defaultCharWidth;
        }
        return Measure.valueOf((int)(width += text.length()));
    }

    public static List<SelectItem> getItemsToRender(UISelectOne component) {
        return RenderUtils.getItems((UIInput)component);
    }

    public static List<SelectItem> getItemsToRender(UISelectMany component) {
        return RenderUtils.getItems((UIInput)component);
    }

    public static List<SelectItem> getItems(UIInput component) {
        List<SelectItem> selectItems = RenderUtils.getSelectItems((UIComponent)component);
        String renderRange = (String)component.getAttributes().get("renderRangeExtern");
        if (renderRange == null) {
            renderRange = (String)component.getAttributes().get("renderRange");
        }
        if (renderRange == null) {
            return selectItems;
        }
        int[] indices = StringUtils.getIndices((String)renderRange);
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(indices.length);
        if (selectItems.size() != 0) {
            for (int indice : indices) {
                items.add(selectItems.get(indice));
            }
        } else {
            LOG.warn("No items found! rendering dummies instead!");
            for (int i = 0; i < indices.length; ++i) {
                items.add(new SelectItem((Object)Integer.toString(i), "Item " + i, ""));
            }
        }
        return items;
    }

    public static String currentValue(UIComponent component) {
        String currentValue = null;
        if (component instanceof ValueHolder) {
            Object value;
            if (component instanceof EditableValueHolder && (value = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return (String)value;
            }
            value = ((ValueHolder)component).getValue();
            if (value != null) {
                Converter converter = ((ValueHolder)component).getConverter();
                if (converter == null) {
                    FacesContext context = FacesContext.getCurrentInstance();
                    converter = context.getApplication().createConverter(value.getClass());
                }
                currentValue = converter != null ? converter.getAsString(FacesContext.getCurrentInstance(), component, value) : value.toString();
            }
        }
        return currentValue;
    }

    public static List<SelectItem> getSelectItems(UIComponent component) {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        for (Object o1 : component.getChildren()) {
            String message;
            Object value;
            UIComponent kid = (UIComponent)o1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("kid " + kid);
                LOG.debug("kid " + kid.getClass().getName());
            }
            if (kid instanceof UISelectItem) {
                value = ((UISelectItem)kid).getValue();
                if (value == null) {
                    UISelectItem item = (UISelectItem)kid;
                    if (kid instanceof org.apache.myfaces.tobago.component.UISelectItem) {
                        list.add(RenderUtils.getSelectItem((org.apache.myfaces.tobago.component.UISelectItem)kid));
                        continue;
                    }
                    list.add(new SelectItem(item.getItemValue() == null ? "" : item.getItemValue(), item.getItemLabel() != null ? item.getItemLabel() : item.getItemValue().toString(), item.getItemDescription()));
                    continue;
                }
                if (value instanceof SelectItem) {
                    list.add((SelectItem)value);
                    continue;
                }
                message = "TYPE ERROR: value NOT instanceof SelectItem. type=" + value.getClass().getName() + " value=" + value;
                LOG.error(message);
                DebugUtils.addDevelopmentMessage((FacesContext)FacesContext.getCurrentInstance(), (String)message);
                continue;
            }
            if (!(kid instanceof UISelectItems)) continue;
            value = ((UISelectItems)kid).getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("value " + value);
                if (value != null) {
                    LOG.debug("value " + value.getClass().getName());
                }
            }
            if (value == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("value is null");
                continue;
            }
            if (value instanceof SelectItem) {
                list.add((SelectItem)value);
                continue;
            }
            if (value instanceof SelectItem[]) {
                SelectItem[] items = (SelectItem[])value;
                list.addAll(Arrays.asList(items));
                continue;
            }
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    list.add((SelectItem)o);
                }
                continue;
            }
            if (value instanceof Map) {
                for (Object key : ((Map)value).keySet()) {
                    Object val;
                    if (key == null || (val = ((Map)value).get(key)) == null) continue;
                    list.add(new SelectItem((Object)val.toString(), key.toString(), null));
                }
                continue;
            }
            message = "TYPE ERROR: value NOT instanceof SelectItem, SelectItem[], Collection, Map. type=" + value.getClass().getName() + " value=" + value;
            LOG.error(message);
            DebugUtils.addDevelopmentMessage((FacesContext)FacesContext.getCurrentInstance(), (String)message);
        }
        return list;
    }

    private static SelectItem getSelectItem(org.apache.myfaces.tobago.component.UISelectItem component) {
        return new org.apache.myfaces.tobago.model.SelectItem(component.getItemValue() == null ? "" : component.getItemValue(), component.getItemLabel(), component.getItemDescription(), component.isItemDisabled(), component.getItemImage(), component.getMarkup());
    }
}

