/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UILabel;
import org.apache.myfaces.tobago.component.UISeparator;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.VariableResolverUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SeparatorRenderer
extends LayoutComponentRendererBase {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UISeparator separator = (UISeparator)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        String label = this.getLabel(separator);
        if (label != null) {
            if (VariableResolverUtils.resolveClientProperties((FacesContext)facesContext).getUserAgent().isMsie()) {
                label = StringUtils.replace((String)label, (String)" ", (String)"\u00a0");
            }
            writer.startElement("table", component);
            writer.writeIdAttribute(separator.getClientId(facesContext));
            writer.writeClassAttribute(Classes.create((UIComponent)component));
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
            Style style = new Style(facesContext, (LayoutBase)separator);
            writer.writeStyleAttribute(style);
            writer.writeAttribute("cellpadding", "0", false);
            writer.writeAttribute("cellspacing", "0", false);
            writer.startElement("tr", component);
            writer.startElement("td", component);
            writer.writeClassAttribute(Classes.create((UIComponent)component, (String)"start"));
            writer.startElement("hr", component);
            writer.endElement("hr");
            writer.endElement("td");
            writer.startElement("td", component);
            writer.writeClassAttribute(Classes.create((UIComponent)component, (String)"label"));
            writer.writeText(label);
            writer.endElement("td");
            writer.startElement("td", component);
            writer.writeClassAttribute(Classes.create((UIComponent)component, (String)"end"));
            writer.startElement("hr", component);
            writer.endElement("hr");
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("table");
        } else {
            writer.startElement("hr", component);
            writer.writeIdAttribute(separator.getClientId(facesContext));
            writer.writeClassAttribute(Classes.create((UIComponent)component));
            Style style = new Style(facesContext, (LayoutBase)separator);
            style.setHeight(Measure.ZERO);
            writer.writeStyleAttribute(style);
            writer.endElement("hr");
        }
    }

    private String getLabel(UISeparator separator) {
        String label = separator.getLabel();
        if (label == null && separator.getFacet("label") != null) {
            Deprecation.LOG.warn("label facet in tc:separator is deprecated, use label attribute instead, please.");
            label = String.valueOf(((UILabel)separator.getFacet("label")).getValue());
        }
        return label;
    }

    public Measure getHeight(FacesContext facesContext, Configurable component) {
        String label = this.getLabel((UISeparator)component);
        if (label == null) {
            return this.getResourceManager().getThemeMeasure(facesContext, component, "withoutLabelHeight");
        }
        return super.getHeight(facesContext, component);
    }
}

