/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.sandbox.standard.tag;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.AbstractUINumberSlider;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Position;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class NumberSliderRenderer
extends LayoutComponentRendererBase {
    private static final String SLIDER_WIDTH_PERCENT = "sliderWidthPercent";

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUINumberSlider slider = (AbstractUINumberSlider)component;
        String id = slider.getClientId(facesContext);
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)slider);
        boolean readonly = slider.isReadonly();
        boolean disabled = slider.isDisabled();
        Integer min = ComponentUtils.getIntAttribute((UIComponent)slider, (String)"min");
        Integer max = ComponentUtils.getIntAttribute((UIComponent)slider, (String)"max");
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        Style style = new Style(facesContext, (LayoutBase)slider);
        int width = -1;
        int sliderWidthPerc = this.getResourceManager().getThemeMeasure(facesContext, (Configurable)slider, SLIDER_WIDTH_PERCENT).getPixel();
        if (sliderWidthPerc <= 25) {
            sliderWidthPerc = 25;
        }
        if (sliderWidthPerc >= 75) {
            sliderWidthPerc = 75;
        }
        int sliderWidth = 100;
        int inputWidth = 50;
        if (style.getWidth() != null && style.getWidth().getPixel() >= 0) {
            sliderWidth = width * sliderWidthPerc / 100;
            inputWidth = width * (100 - sliderWidthPerc) / 100;
        }
        writer.startElement("table", (UIComponent)slider);
        writer.writeIdAttribute(id);
        writer.writeClassAttribute(Classes.create((UIComponent)slider));
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)slider);
        writer.writeStyleAttribute(style);
        writer.startElement("tr", null);
        writer.startElement("td", null);
        writer.writeClassAttribute(Classes.create((UIComponent)slider, (String)"min"));
        Style widthStyle = new Style();
        widthStyle.setWidth(Measure.valueOf((int)(sliderWidth / 2)));
        writer.writeStyleAttribute(widthStyle);
        writer.startElement("span", null);
        writer.writeClassAttribute(Classes.create((UIComponent)slider, (String)"min"));
        writer.write(Integer.toString(min));
        writer.endElement("span");
        writer.endElement("td");
        writer.startElement("td", null);
        writer.writeClassAttribute(Classes.create((UIComponent)slider, (String)"max"));
        writer.writeStyleAttribute(widthStyle);
        writer.startElement("span", null);
        writer.writeClassAttribute(Classes.create((UIComponent)slider, (String)"max"));
        writer.write(Integer.toString(max));
        writer.endElement("span");
        writer.endElement("td");
        writer.startElement("td", null);
        writer.writeAttribute("rowspan", "2", false);
        writer.writeClassAttribute(Classes.create((UIComponent)slider, (String)"td"));
        writer.startElement("input", null);
        writer.writeClassAttribute(Classes.create((UIComponent)slider, (String)"input"));
        widthStyle.setWidth(Measure.valueOf((int)inputWidth));
        writer.writeStyleAttribute(widthStyle);
        String inputIdAndName = this.getIdForInputField(facesContext, (UIComponent)slider);
        writer.writeNameAttribute(inputIdAndName);
        writer.writeIdAttribute(inputIdAndName);
        if (currentValue != null) {
            writer.writeAttribute("value", currentValue, false);
        }
        writer.writeAttribute("readonly", readonly);
        writer.writeAttribute("disabled", disabled);
        writer.endElement("input");
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", null);
        writer.startElement("td", null);
        writer.writeAttribute("colspan", 2);
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)slider, (String)"slider"));
        writer.writeIdAttribute(this.getIdForSliderTrack(facesContext, (UIComponent)slider));
        writer.startElement("div", null);
        writer.writeIdAttribute(this.getIdForSliderHandle(facesContext, (UIComponent)slider));
        Style handleStyle = new Style();
        handleStyle.setPosition(Position.RELATIVE);
        handleStyle.setTop(Measure.valueOf((int)-6));
        handleStyle.setWidth(Measure.valueOf((int)12));
        handleStyle.setHeight(Measure.valueOf((int)6));
        writer.writeStyleAttribute(handleStyle);
        writer.startElement("img", null);
        writer.writeAttribute("src", this.getAbsoluteImagePath(facesContext, "image/sliderTriangle.gif"), true);
        writer.endElement("img");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        this.writeSliderJavaScript(facesContext, (UIComponent)slider, writer);
    }

    public void decode(FacesContext context, UIComponent component) {
        if (!(component instanceof UIInput) || ComponentUtils.isOutputOnly((UIComponent)component)) {
            return;
        }
        UIInput uiInput = (UIInput)component;
        String inputId = this.getIdForInputField(context, component);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(inputId)) {
            String newValue = (String)requestParameterMap.get(inputId);
            uiInput.setSubmittedValue((Object)newValue);
        }
    }

    private String getAbsoluteImagePath(FacesContext facesContext, String relativeImagePath) {
        return facesContext.getExternalContext().getRequestContextPath() + ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)relativeImagePath);
    }

    private String getIdForInputField(FacesContext context, UIComponent component) {
        String id = component.getClientId(context);
        return id + "::" + "input";
    }

    private String getIdForSliderTrack(FacesContext context, UIComponent component) {
        String id = component.getClientId(context);
        return id + "::" + "track";
    }

    private String getIdForSliderHandle(FacesContext context, UIComponent component) {
        String id = component.getClientId(context);
        return id + "::" + "handle";
    }

    private void writeSliderJavaScript(FacesContext context, UIComponent component, TobagoResponseWriter writer) throws IOException {
        String trackId = this.getIdForSliderTrack(context, component);
        String handleId = this.getIdForSliderHandle(context, component);
        String inputId = this.getIdForInputField(context, component);
        String jsId = component.getClientId(context).replace(":", "_");
        Integer min = ComponentUtils.getIntAttribute((UIComponent)component, (String)"min");
        Integer max = ComponentUtils.getIntAttribute((UIComponent)component, (String)"max");
        String script = "    var slider_" + jsId + " = new Control.Slider('" + handleId + "', '" + trackId + "', {\n" + "        sliderValue:$('" + inputId + "').value,\n" + "        range : $R(" + min + ", " + max + "),\n" + "        values: $R(" + min + ", " + max + ").toArray(),\n" + "        onSlide:function(v) {\n" + "            $('" + inputId + "').value = v;\n" + "        },\n" + "        onChange:function(v) {\n" + "            $('" + inputId + "').value = v;\n" + "        }\n" + "    });\n" + "\n" + "    Event.observe('value', 'change', function() {\n" + "        slider_" + jsId + ".setValue($('" + inputId + "').value);\n" + "    });\n";
        writer.writeJavascript(script);
    }
}

