/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import javax.faces.FactoryFinder;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.webapp.TobagoServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeblogicWorkaroundServlet
extends HttpServlet {
    private static final long serialVersionUID = -8636608446986072719L;
    private static final Logger LOG = LoggerFactory.getLogger(WeblogicWorkaroundServlet.class);

    public void init() throws ServletException {
        TobagoConfig tobagoConfig;
        LifecycleFactory factory;
        if (LOG.isDebugEnabled()) {
            LOG.debug("1st");
        }
        if ((factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory")) == null) {
            String className = "com.sun.faces.config.ConfigureListener";
            if (LOG.isDebugEnabled()) {
                LOG.debug("Init of com.sun.faces.config.ConfigureListener by servlet!");
            }
            this.callInit("com.sun.faces.config.ConfigureListener");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("2nd");
        }
        if ((tobagoConfig = (TobagoConfig)this.getServletContext().getAttribute("org.apache.myfaces.tobago.config.TobagoConfig")) == null) {
            String className = TobagoServletContextListener.class.getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Init of " + className + " by servlet!");
            }
            this.callInit(className);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("3rd");
        }
    }

    private void callInit(String className) {
        try {
            Class<?> aClass = Class.forName(className);
            ServletContextListener listener = (ServletContextListener)aClass.newInstance();
            listener.contextInitialized(new ServletContextEvent(this.getServletContext()));
        }
        catch (ClassNotFoundException e) {
            LOG.error("", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error("", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.error("", (Throwable)e);
        }
    }
}

