/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.internal.config.TobagoConfigBuilder;
import org.apache.myfaces.tobago.internal.context.ResourceManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TobagoServletContextListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoServletContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext;
        if (LOG.isInfoEnabled()) {
            LOG.info("*** contextInitialized ***");
        }
        if ((servletContext = event.getServletContext()).getAttribute("org.apache.myfaces.tobago.config.TobagoConfig") != null) {
            LOG.warn("Tobago has been already initialized. Do nothing.");
            return;
        }
        TobagoConfigBuilder.init(servletContext);
        if (LOG.isInfoEnabled()) {
            LOG.info("tobago config: " + TobagoConfig.getInstance(servletContext));
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (LOG.isInfoEnabled()) {
            LOG.info("*** contextDestroyed ***\n--- snip -----------------------------------------------------------------------");
        }
        ServletContext servletContext = event.getServletContext();
        servletContext.removeAttribute("org.apache.myfaces.tobago.config.TobagoConfig");
        ResourceManagerFactory.release(servletContext);
    }
}

